/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.jetbrains.rider.ProjectExtensionsKt;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.UnityProjectFileIndexAugmentor;
import com.jetbrains.rider.projectView.ideaInterop.ProjectFileIndexAugmentor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J4\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J*\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J,\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\f\u001a\u00020\u0005H\u0016J2\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/plugins/unity/UnityProjectFileIndexAugmentor;", "Lcom/jetbrains/rider/projectView/ideaInterop/ProjectFileIndexAugmentor;", "<init>", "()V", "isInProject", "", "project", "Lcom/intellij/openapi/project/Project;", "index", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "current", "getContentRootForFile", "honorExclusion", "iterateExtraContent", "processor", "Lcom/intellij/openapi/roots/ContentIterator;", "filter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "isInContent", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetWithCustomData;", "iterateUnityContentUnderDirectory", "dir", "Lcom/intellij/openapi/roots/ContentIteratorEx;", "customFilter", "toContentIteratorEx", "unityRoots", "", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityProjectFileIndexAugmentor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityProjectFileIndexAugmentor.kt\ncom/jetbrains/rider/plugins/unity/UnityProjectFileIndexAugmentor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1761#2,3:146\n295#2,2:149\n774#2:151\n865#2,2:152\n1#3:154\n*S KotlinDebug\n*F\n+ 1 UnityProjectFileIndexAugmentor.kt\ncom/jetbrains/rider/plugins/unity/UnityProjectFileIndexAugmentor\n*L\n22#1:146,3\n35#1:149,2\n46#1:151\n46#1:152,2\n*E\n"})
public final class UnityProjectFileIndexAugmentor
implements ProjectFileIndexAugmentor {
    public boolean isInProject(@NotNull Project project, @NotNull ProjectFileIndex index, @NotNull VirtualFile file, boolean current) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (current) {
                return true;
            }
            if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(project).getValue()).booleanValue()) {
                return false;
            }
            if (index.isExcluded(file)) {
                return false;
            }
            Iterable $this$any$iv = this.unityRoots(project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile root = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public VirtualFile getContentRootForFile(@NotNull Project project, @NotNull ProjectFileIndex index, @NotNull VirtualFile file, boolean honorExclusion, @Nullable VirtualFile current) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            VirtualFile virtualFile = current;
            if (virtualFile != null) {
                return virtualFile;
            }
            if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(project).getValue()).booleanValue()) {
                return null;
            }
            if (honorExclusion && index.isExcluded(file)) {
                return null;
            }
            Iterable $this$firstOrNull$iv = this.unityRoots(project);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile root = (VirtualFile)element$iv;
                boolean bl = false;
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean iterateExtraContent(@NotNull Project project, @NotNull ProjectFileIndex index, @NotNull ContentIterator processor, @Nullable VirtualFileFilter filter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(project).getValue()).booleanValue()) {
            return true;
        }
        Iterable $this$filter$iv = this.unityRoots(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(it.isValid() && it.isDirectory())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List extraRoots = (List)destination$iv$iv;
        if (extraRoots.isEmpty()) {
            return true;
        }
        ContentIteratorEx processorEx = this.toContentIteratorEx(processor);
        WorkspaceFileIndexEx workspaceIndex = WorkspaceFileIndexEx.Companion.getInstance(project);
        for (VirtualFile root : extraRoots) {
            VirtualFile parentContentRoot = (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> UnityProjectFileIndexAugmentor.iterateExtraContent$lambda$1(workspaceIndex, root));
            if (parentContentRoot != null && !Intrinsics.areEqual((Object)parentContentRoot, (Object)root) || this.iterateUnityContentUnderDirectory(project, index, root, processorEx, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean isInContent(@NotNull Project project, @NotNull ProjectFileIndex index, @NotNull WorkspaceFileSetWithCustomData<?> fileSet, boolean current) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter(fileSet, (String)"fileSet");
        if (current) {
            return true;
        }
        return this.isInProject(project, index, fileSet.getRoot(), false);
    }

    private final boolean iterateUnityContentUnderDirectory(Project project, ProjectFileIndex index, VirtualFile dir, ContentIteratorEx processor, VirtualFileFilter customFilter) {
        WorkspaceFileIndexEx workspaceIndex = WorkspaceFileIndexEx.Companion.getInstance(project);
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VirtualFileVisitor<Void> visitor2 = new VirtualFileVisitor<Void>(project, dir, customFilter, processor, index, workspaceIndex, optionArray){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $dir;
            final /* synthetic */ VirtualFileFilter $customFilter;
            final /* synthetic */ ContentIteratorEx $processor;
            final /* synthetic */ ProjectFileIndex $index;
            final /* synthetic */ WorkspaceFileIndexEx $workspaceIndex;
            {
                this.$project = $project;
                this.$dir = $dir;
                this.$customFilter = $customFilter;
                this.$processor = $processor;
                this.$index = $index;
                this.$workspaceIndex = $workspaceIndex;
                super($super_call_param$1);
            }

            public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                VirtualFile parentContentRoot;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (this.$project.isDisposed()) {
                    VirtualFileVisitor.Result result = VirtualFileVisitor.skipTo((VirtualFile)this.$dir);
                    Intrinsics.checkNotNullExpressionValue((Object)result, (String)"skipTo(...)");
                    return result;
                }
                if (this.$customFilter != null && !this.$customFilter.accept(file)) {
                    VirtualFileVisitor.Result result;
                    if (file.isDirectory()) {
                        VirtualFileVisitor.Result result2 = VirtualFileVisitor.SKIP_CHILDREN;
                        result = result2;
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"SKIP_CHILDREN");
                    } else {
                        VirtualFileVisitor.Result result3 = VirtualFileVisitor.CONTINUE;
                        result = result3;
                        Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"CONTINUE");
                    }
                    return result;
                }
                Boolean excludedOrIgnored = (Boolean)ApplicationManager.getApplication().runReadAction(() -> iterateUnityContentUnderDirectory.visitor.1.visitFileEx$lambda$0(this.$index, file));
                if (excludedOrIgnored.booleanValue()) {
                    VirtualFileVisitor.Result result;
                    if (file.isDirectory()) {
                        VirtualFileVisitor.Result result4 = VirtualFileVisitor.SKIP_CHILDREN;
                        result = result4;
                        Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"SKIP_CHILDREN");
                    } else {
                        VirtualFileVisitor.Result result5 = VirtualFileVisitor.CONTINUE;
                        result = result5;
                        Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"CONTINUE");
                    }
                    return result;
                }
                if (file.isDirectory() && (parentContentRoot = (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> iterateUnityContentUnderDirectory.visitor.1.visitFileEx$lambda$1(this.$workspaceIndex, file))) != null && !Intrinsics.areEqual((Object)parentContentRoot, (Object)file)) {
                    VirtualFileVisitor.Result result = VirtualFileVisitor.SKIP_CHILDREN;
                    Intrinsics.checkNotNullExpressionValue((Object)result, (String)"SKIP_CHILDREN");
                    return result;
                }
                Boolean alreadyInWorkspace = (Boolean)ApplicationManager.getApplication().runReadAction(() -> iterateUnityContentUnderDirectory.visitor.1.visitFileEx$lambda$2(this.$workspaceIndex, file));
                if (!alreadyInWorkspace.booleanValue()) {
                    VirtualFileVisitor.Result result;
                    TreeNodeProcessingResult treeNodeProcessingResult = this.$processor.processFileEx(file);
                    Intrinsics.checkNotNullExpressionValue((Object)treeNodeProcessingResult, (String)"processFileEx(...)");
                    TreeNodeProcessingResult status = treeNodeProcessingResult;
                    switch (iterateUnityContentUnderDirectory.visitor.WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: {
                            VirtualFileVisitor.Result result6 = VirtualFileVisitor.CONTINUE;
                            result = result6;
                            Intrinsics.checkNotNullExpressionValue((Object)result6, (String)"CONTINUE");
                            break;
                        }
                        case 2: {
                            VirtualFileVisitor.Result result7 = VirtualFileVisitor.SKIP_CHILDREN;
                            result = result7;
                            Intrinsics.checkNotNullExpressionValue((Object)result7, (String)"SKIP_CHILDREN");
                            break;
                        }
                        case 3: {
                            VirtualFileVisitor.Result result8 = VirtualFileVisitor.skipTo((VirtualFile)file.getParent());
                            result = result8;
                            Intrinsics.checkNotNullExpressionValue((Object)result8, (String)"skipTo(...)");
                            break;
                        }
                        case 4: {
                            VirtualFileVisitor.Result result9 = VirtualFileVisitor.skipTo((VirtualFile)this.$dir);
                            result = result9;
                            Intrinsics.checkNotNullExpressionValue((Object)result9, (String)"skipTo(...)");
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return result;
                }
                VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"CONTINUE");
                return result;
            }

            private static final Boolean visitFileEx$lambda$0(ProjectFileIndex $index, VirtualFile $file) {
                return $index.isExcluded($file) || $index.isUnderIgnored($file);
            }

            private static final VirtualFile visitFileEx$lambda$1(WorkspaceFileIndexEx $workspaceIndex, VirtualFile $file) {
                return $workspaceIndex.getContentFileSetRoot($file, true);
            }

            private static final Boolean visitFileEx$lambda$2(WorkspaceFileIndexEx $workspaceIndex, VirtualFile $file) {
                return $workspaceIndex.getContentFileSetRoot($file, true) != null;
            }
        };
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)((VirtualFileVisitor)visitor2));
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"visitChildrenRecursively(...)");
        VirtualFileVisitor.Result result2 = result;
        return !Intrinsics.areEqual((Object)result2.skipToParent, (Object)dir);
    }

    private final ContentIteratorEx toContentIteratorEx(ContentIterator processor) {
        ContentIteratorEx contentIteratorEx = processor instanceof ContentIteratorEx ? (ContentIteratorEx)processor : null;
        if (contentIteratorEx == null) {
            contentIteratorEx = arg_0 -> UnityProjectFileIndexAugmentor.toContentIteratorEx$lambda$0(processor, arg_0);
        }
        return contentIteratorEx;
    }

    private final List<VirtualFile> unityRoots(Project project) {
        List roots;
        block3: {
            VirtualFile it;
            VirtualFile baseDir = ProjectExtensionsKt.getProjectDir(project);
            roots = new ArrayList();
            VirtualFile virtualFile = baseDir.findChild("Assets");
            if (virtualFile != null) {
                it = virtualFile;
                boolean bl = false;
                if (it.isValid() && it.isDirectory()) {
                    roots.add(it);
                }
            }
            VirtualFile virtualFile2 = baseDir.findChild("Packages");
            if (virtualFile2 == null) break block3;
            it = virtualFile2;
            boolean bl = false;
            if (it.isValid() && it.isDirectory()) {
                roots.add(it);
            }
        }
        return roots;
    }

    private static final VirtualFile iterateExtraContent$lambda$1(WorkspaceFileIndexEx $workspaceIndex, VirtualFile $root) {
        return $workspaceIndex.getContentFileSetRoot($root, true);
    }

    private static final TreeNodeProcessingResult toContentIteratorEx$lambda$0(ContentIterator $processor, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return $processor.processFile(fileOrDir) ? TreeNodeProcessingResult.CONTINUE : TreeNodeProcessingResult.STOP;
    }
}

