/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.agent;

import com.intellij.ml.llm.matterhorn.CodeEngine;
import com.intellij.ml.llm.matterhorn.CodeEnginePath;
import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.agent.AgentContext;
import com.intellij.ml.llm.matterhorn.agent.AgentSessionHistory;
import com.intellij.ml.llm.matterhorn.agent.AgentState;
import com.intellij.ml.llm.matterhorn.agent.FileWithLine;
import com.intellij.ml.llm.matterhorn.agent.hitl.HumanInLoop;
import com.intellij.ml.llm.matterhorn.agent.util.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.ej.api.FileChange;
import com.intellij.ml.llm.matterhorn.execution.ExecutionEnvironment;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R \u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R$\u00102\u001a\u0002012\u0006\u0010\u000e\u001a\u0002018V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00067"}, d2={"Lcom/intellij/ml/llm/matterhorn/agent/SimpleExecutionAgentContext;", "Lcom/intellij/ml/llm/matterhorn/agent/util/ExecutionAgentContext;", "agentContext", "Lcom/intellij/ml/llm/matterhorn/agent/AgentContext;", "executionContext", "Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/agent/AgentContext;Lcom/intellij/ml/llm/matterhorn/ExecutionContext;)V", "getExecutionContext", "()Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "engine", "Lcom/intellij/ml/llm/matterhorn/CodeEngine;", "getEngine", "()Lcom/intellij/ml/llm/matterhorn/CodeEngine;", "value", "Lcom/intellij/ml/llm/matterhorn/CodeEnginePath;", "currentDir", "getCurrentDir", "()Lcom/intellij/ml/llm/matterhorn/CodeEnginePath;", "setCurrentDir", "(Lcom/intellij/ml/llm/matterhorn/CodeEnginePath;)V", "Lcom/intellij/ml/llm/matterhorn/agent/FileWithLine;", "currentScreenPosition", "getCurrentScreenPosition", "()Lcom/intellij/ml/llm/matterhorn/agent/FileWithLine;", "setCurrentScreenPosition", "(Lcom/intellij/ml/llm/matterhorn/agent/FileWithLine;)V", "disableDirChange", "", "getDisableDirChange", "()Z", "setDisableDirChange", "(Z)V", "executionEnvironment", "Lcom/intellij/ml/llm/matterhorn/execution/ExecutionEnvironment;", "getExecutionEnvironment", "()Lcom/intellij/ml/llm/matterhorn/execution/ExecutionEnvironment;", "pushChange", "", "changes", "", "Lcom/intellij/ml/llm/matterhorn/ej/api/FileChange;", "popChange", "getChanges", "()Ljava/util/List;", "sessionHistory", "Lcom/intellij/ml/llm/matterhorn/agent/AgentSessionHistory;", "getSessionHistory", "()Lcom/intellij/ml/llm/matterhorn/agent/AgentSessionHistory;", "Lcom/intellij/ml/llm/matterhorn/agent/AgentState;", "currentAgentState", "getCurrentAgentState", "()Lcom/intellij/ml/llm/matterhorn/agent/AgentState;", "setCurrentAgentState", "(Lcom/intellij/ml/llm/matterhorn/agent/AgentState;)V", "ej-core"})
public final class SimpleExecutionAgentContext
implements ExecutionAgentContext {
    @NotNull
    private final AgentContext agentContext;
    @NotNull
    private final ExecutionContext executionContext;
    private boolean disableDirChange;

    public SimpleExecutionAgentContext(@NotNull AgentContext agentContext, @NotNull ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)agentContext, (String)"agentContext");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        this.agentContext = agentContext;
        this.executionContext = executionContext;
    }

    @Override
    @NotNull
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    @NotNull
    public CodeEngine getEngine() {
        return this.getExecutionContext().getRoot().getService().getEngine();
    }

    @Override
    @NotNull
    public CodeEnginePath getCurrentDir() {
        return this.agentContext.getCurrentDir();
    }

    @Override
    public void setCurrentDir(@NotNull CodeEnginePath value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.agentContext.setCurrentDir(value);
    }

    @Override
    @Nullable
    public FileWithLine getCurrentScreenPosition() {
        return this.agentContext.getCurrentScreenPosition();
    }

    @Override
    public void setCurrentScreenPosition(@Nullable FileWithLine value) {
        this.agentContext.setCurrentScreenPosition(value);
    }

    @Override
    public boolean getDisableDirChange() {
        return this.disableDirChange;
    }

    @Override
    public void setDisableDirChange(boolean bl) {
        this.disableDirChange = bl;
    }

    @Override
    @NotNull
    public ExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)this.getExecutionContext().lookupContext(ExecutionEnvironment.Companion.getKEY());
        if (executionEnvironment == null) {
            executionEnvironment = (ExecutionEnvironment)ExecutionEnvironment.DummyEnvironment.INSTANCE;
        }
        return executionEnvironment;
    }

    @Override
    public void pushChange(@NotNull List<FileChange> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.agentContext.pushChange(changes);
    }

    @Override
    @NotNull
    public List<FileChange> popChange() {
        return this.agentContext.popChange();
    }

    @Override
    @NotNull
    public List<List<FileChange>> getChanges() {
        return this.agentContext.getChanges();
    }

    @Override
    @NotNull
    public AgentSessionHistory getSessionHistory() {
        return this.agentContext.getSessionHistory();
    }

    @Override
    @NotNull
    public AgentState getCurrentAgentState() {
        return this.agentContext.getCurrentAgentState();
    }

    @Override
    public void setCurrentAgentState(@NotNull AgentState value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.agentContext.setCurrentAgentState(value);
    }

    @Override
    @Nullable
    public HumanInLoop getHumanInLoopOverride() {
        return ExecutionAgentContext.DefaultImpls.getHumanInLoopOverride(this);
    }
}

