/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.agent;

import com.intellij.ml.llm.matterhorn.CodeEnginePath;
import com.intellij.ml.llm.matterhorn.CustomContext;
import com.intellij.ml.llm.matterhorn.ExecutionContextUserDataKey;
import com.intellij.ml.llm.matterhorn.agent.AgentSessionHistory;
import com.intellij.ml.llm.matterhorn.agent.AgentState;
import com.intellij.ml.llm.matterhorn.agent.FileWithLine;
import com.intellij.ml.llm.matterhorn.ej.api.FileChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010$\u001a\u00020%2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001d\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006("}, d2={"Lcom/intellij/ml/llm/matterhorn/agent/AgentContext;", "Lcom/intellij/ml/llm/matterhorn/CustomContext;", "state", "Lcom/intellij/ml/llm/matterhorn/agent/AgentState;", "currentDir", "Lcom/intellij/ml/llm/matterhorn/CodeEnginePath;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/agent/AgentState;Lcom/intellij/ml/llm/matterhorn/CodeEnginePath;)V", "getCurrentDir", "()Lcom/intellij/ml/llm/matterhorn/CodeEnginePath;", "setCurrentDir", "(Lcom/intellij/ml/llm/matterhorn/CodeEnginePath;)V", "currentScreenPosition", "Lcom/intellij/ml/llm/matterhorn/agent/FileWithLine;", "getCurrentScreenPosition", "()Lcom/intellij/ml/llm/matterhorn/agent/FileWithLine;", "setCurrentScreenPosition", "(Lcom/intellij/ml/llm/matterhorn/agent/FileWithLine;)V", "editsHistory", "", "", "Lcom/intellij/ml/llm/matterhorn/ej/api/FileChange;", "sessionHistory", "Lcom/intellij/ml/llm/matterhorn/agent/AgentSessionHistory;", "getSessionHistory", "()Lcom/intellij/ml/llm/matterhorn/agent/AgentSessionHistory;", "setSessionHistory", "(Lcom/intellij/ml/llm/matterhorn/agent/AgentSessionHistory;)V", "currentAgentState", "getCurrentAgentState", "()Lcom/intellij/ml/llm/matterhorn/agent/AgentState;", "setCurrentAgentState", "(Lcom/intellij/ml/llm/matterhorn/agent/AgentState;)V", "changes", "getChanges", "()Ljava/util/List;", "pushChange", "", "popChange", "Companion", "ej-core"})
public final class AgentContext
implements CustomContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CodeEnginePath currentDir;
    @Nullable
    private FileWithLine currentScreenPosition;
    @NotNull
    private List<List<FileChange>> editsHistory;
    @NotNull
    private AgentSessionHistory sessionHistory;
    @NotNull
    private AgentState currentAgentState;
    @NotNull
    private final List<List<FileChange>> changes;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ExecutionContextUserDataKey<AgentContext> KEY;

    public AgentContext(@NotNull AgentState state, @NotNull CodeEnginePath currentDir) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)currentDir, (String)"currentDir");
        this.currentDir = currentDir;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.editsHistory = list;
        this.sessionHistory = AgentSessionHistory.Companion.initialHistoryContext();
        this.currentAgentState = state;
        this.changes = this.editsHistory;
    }

    @NotNull
    public final CodeEnginePath getCurrentDir() {
        return this.currentDir;
    }

    public final void setCurrentDir(@NotNull CodeEnginePath codeEnginePath) {
        Intrinsics.checkNotNullParameter((Object)codeEnginePath, (String)"<set-?>");
        this.currentDir = codeEnginePath;
    }

    @Nullable
    public final FileWithLine getCurrentScreenPosition() {
        return this.currentScreenPosition;
    }

    public final void setCurrentScreenPosition(@Nullable FileWithLine fileWithLine) {
        this.currentScreenPosition = fileWithLine;
    }

    @NotNull
    public final AgentSessionHistory getSessionHistory() {
        return this.sessionHistory;
    }

    public final void setSessionHistory(@NotNull AgentSessionHistory agentSessionHistory) {
        Intrinsics.checkNotNullParameter((Object)agentSessionHistory, (String)"<set-?>");
        this.sessionHistory = agentSessionHistory;
    }

    @NotNull
    public final AgentState getCurrentAgentState() {
        return this.currentAgentState;
    }

    public final void setCurrentAgentState(@NotNull AgentState agentState) {
        Intrinsics.checkNotNullParameter((Object)agentState, (String)"<set-?>");
        this.currentAgentState = agentState;
    }

    @NotNull
    public final List<List<FileChange>> getChanges() {
        return this.changes;
    }

    public final void pushChange(@NotNull List<FileChange> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.editsHistory.add(changes);
    }

    @NotNull
    public final List<FileChange> popChange() {
        if (this.editsHistory.isEmpty()) {
            logger.warn("Pop change: changes history is empty");
            return CollectionsKt.emptyList();
        }
        List<FileChange> list = this.editsHistory.removeLast();
        Intrinsics.checkNotNullExpressionValue(list, (String)"removeLast(...)");
        List<FileChange> last = list;
        return last;
    }

    static {
        Logger logger = LoggerFactory.getLogger(AgentContext.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        AgentContext.logger = logger;
        KEY = new ExecutionContextUserDataKey("AgentContextKey");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/matterhorn/agent/AgentContext$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "KEY", "Lcom/intellij/ml/llm/matterhorn/ExecutionContextUserDataKey;", "Lcom/intellij/ml/llm/matterhorn/agent/AgentContext;", "getKEY", "()Lcom/intellij/ml/llm/matterhorn/ExecutionContextUserDataKey;", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final ExecutionContextUserDataKey<AgentContext> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

