/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 85855036684474L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1359589110 - -((char)-24598), 1359589110 - (char)-31403, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1359589110 - -((char)-24597), 1359589110 - 13054, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 84365703358223L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.G();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-339209160 + -9461, 339209160 + (char)-30790, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-339209160 + -9462, -339209160 + -((char)-30901), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-339209160 + -9459, 339209160 + 23998, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 70112387018173L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    n2 = SshAgentIpcService.G();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1340846100 + (char)-18974, -1340846100 + -29300, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1340846100 + (char)-18975, -1340846100 + -((char)-26420), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1340846100 + (char)-18976, -1340846100 + -((char)-25323), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 == 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1340846100 + (char)-18969, -1340846100 + -((char)-31053), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1340846100 + (char)-18970, -1340846100 + -((char)-27616), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1340846100 + (char)-18971, -1340846100 + -((char)-24903), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1340846100 + (char)-18969, -1340846100 + -((char)-31053), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1340846100 + (char)-18972, -1340846100 + -((char)-16572), (int)l2));
            if (ActionTimestamp.x() == null) {
                SshAgentIpcService.x(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 38278537272557L;
                    n3 = SshAgentIpcService.G();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 109843784106441L;
                int n3 = SshAgentIpcService.x();
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            n2 = n3;
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 != 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-4456380 + -14009, -4456380 + -25499, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-4456380 + -14005, 4456380 + 26001, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-4456380 + -14010, 4456380 + 29595, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-4456380 + -14005, 4456380 + 26001, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-4456380 + -14011, 4456380 + 11851, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-4456380 + -14009, -4456380 + -25499, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-4456380 + -14005, 4456380 + 26001, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-4456380 + -14012, 4456380 + 15253, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 != 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-4456380 + -14009, -4456380 + -25499, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-4456380 + -14005, 4456380 + 26001, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-4456380 + -13997, 4456380 + 25717, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-4456380 + -14005, 4456380 + 26001, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-4456380 + -13998, 4456380 + 19816, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 != 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-4456380 + -14005, 4456380 + 26001, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-4456380 + -14011, 4456380 + 11851, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-4456380 + -14009, -4456380 + -25499, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-4456380 + -14005, 4456380 + 26001, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-4456380 + -13999, -4456380 + -27045, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 37794640409762L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1071759390 + (char)-31874, 1071759390 + (char)-20023, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 22621794412713L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-201716730 - -((char)-11376), 201716730 - (char)-11271, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = ">\u00c4n2NV\t\u009b \u0080e\u00fb\u00f1\u00cd\u0000\u00de~4y\u0014\u00d9C\u0092\u00c4\u00caJ\u00e4\u009d\u001fFG\u00f7w\u00b5\u0011Z\u00b1b\u0087\u008e";
                        var4_3 = ">\u00c4n2NV\t\u009b \u0080e\u00fb\u00f1\u00cd\u0000\u00de~4y\u0014\u00d9C\u0092\u00c4\u00caJ\u00e4\u009d\u001fFG\u00f7w\u00b5\u0011Z\u00b1b\u0087\u008e".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 115;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 1;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 112;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 64;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 57;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 97;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 58;
                                        break;
                                    }
                                    default: {
                                        v11 = 39;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFF73E) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 87;
                            case 1 -> 245;
                            case 2 -> 151;
                            case 3 -> 240;
                            case 4 -> 159;
                            case 5 -> 177;
                            case 6 -> 40;
                            case 7 -> 106;
                            case 8 -> 0;
                            case 9 -> 221;
                            case 10 -> 225;
                            case 11 -> 3;
                            case 12 -> 76;
                            case 13 -> 147;
                            case 14 -> 206;
                            case 15 -> 67;
                            case 16 -> 129;
                            case 17 -> 184;
                            case 18 -> 121;
                            case 19 -> 100;
                            case 20 -> 61;
                            case 21 -> 2;
                            case 22 -> 117;
                            case 23 -> 235;
                            case 24 -> 145;
                            case 25 -> 176;
                            case 26 -> 192;
                            case 27 -> 66;
                            case 28 -> 86;
                            case 29 -> 24;
                            case 30 -> 217;
                            case 31 -> 201;
                            case 32 -> 156;
                            case 33 -> 172;
                            case 34 -> 53;
                            case 35 -> 34;
                            case 36 -> 79;
                            case 37 -> 197;
                            case 38 -> 63;
                            case 39 -> 138;
                            case 40 -> 120;
                            case 41 -> 115;
                            case 42 -> 26;
                            case 43 -> 27;
                            case 44 -> 11;
                            case 45 -> 25;
                            case 46 -> 203;
                            case 47 -> 110;
                            case 48 -> 133;
                            case 49 -> 56;
                            case 50 -> 7;
                            case 51 -> 5;
                            case 52 -> 208;
                            case 53 -> 243;
                            case 54 -> 55;
                            case 55 -> 199;
                            case 56 -> 141;
                            case 57 -> 47;
                            case 58 -> 213;
                            case 59 -> 146;
                            case 60 -> 149;
                            case 61 -> 194;
                            case 62 -> 32;
                            case 63 -> 162;
                            case 64 -> 126;
                            case 65 -> 233;
                            case 66 -> 94;
                            case 67 -> 96;
                            case 68 -> 109;
                            case 69 -> 38;
                            case 70 -> 200;
                            case 71 -> 41;
                            case 72 -> 91;
                            case 73 -> 140;
                            case 74 -> 30;
                            case 75 -> 247;
                            case 76 -> 35;
                            case 77 -> 222;
                            case 78 -> 241;
                            case 79 -> 131;
                            case 80 -> 98;
                            case 81 -> 28;
                            case 82 -> 80;
                            case 83 -> 251;
                            case 84 -> 153;
                            case 85 -> 239;
                            case 86 -> 148;
                            case 87 -> 8;
                            case 88 -> 122;
                            case 89 -> 219;
                            case 90 -> 50;
                            case 91 -> 124;
                            case 92 -> 234;
                            case 93 -> 212;
                            case 94 -> 182;
                            case 95 -> 190;
                            case 96 -> 231;
                            case 97 -> 198;
                            case 98 -> 128;
                            case 99 -> 224;
                            case 100 -> 85;
                            case 101 -> 209;
                            case 102 -> 92;
                            case 103 -> 130;
                            case 104 -> 73;
                            case 105 -> 174;
                            case 106 -> 29;
                            case 107 -> 215;
                            case 108 -> 216;
                            case 109 -> 160;
                            case 110 -> 42;
                            case 111 -> 6;
                            case 112 -> 46;
                            case 113 -> 237;
                            case 114 -> 161;
                            case 115 -> 107;
                            case 116 -> 169;
                            case 117 -> 18;
                            case 118 -> 152;
                            case 119 -> 249;
                            case 120 -> 113;
                            case 121 -> 81;
                            case 122 -> 14;
                            case 123 -> 255;
                            case 124 -> 58;
                            case 125 -> 49;
                            case 126 -> 13;
                            case 127 -> 57;
                            case 128 -> 48;
                            case 129 -> 193;
                            case 130 -> 75;
                            case 131 -> 37;
                            case 132 -> 142;
                            case 133 -> 65;
                            case 134 -> 186;
                            case 135 -> 189;
                            case 136 -> 16;
                            case 137 -> 82;
                            case 138 -> 191;
                            case 139 -> 223;
                            case 140 -> 167;
                            case 141 -> 118;
                            case 142 -> 204;
                            case 143 -> 137;
                            case 144 -> 105;
                            case 145 -> 139;
                            case 146 -> 154;
                            case 147 -> 62;
                            case 148 -> 22;
                            case 149 -> 125;
                            case 150 -> 54;
                            case 151 -> 17;
                            case 152 -> 236;
                            case 153 -> 230;
                            case 154 -> 195;
                            case 155 -> 253;
                            case 156 -> 111;
                            case 157 -> 228;
                            case 158 -> 101;
                            case 159 -> 9;
                            case 160 -> 71;
                            case 161 -> 164;
                            case 162 -> 52;
                            case 163 -> 196;
                            case 164 -> 99;
                            case 165 -> 248;
                            case 166 -> 119;
                            case 167 -> 202;
                            case 168 -> 250;
                            case 169 -> 158;
                            case 170 -> 252;
                            case 171 -> 227;
                            case 172 -> 127;
                            case 173 -> 220;
                            case 174 -> 103;
                            case 175 -> 185;
                            case 176 -> 232;
                            case 177 -> 15;
                            case 178 -> 155;
                            case 179 -> 43;
                            case 180 -> 44;
                            case 181 -> 78;
                            case 182 -> 33;
                            case 183 -> 163;
                            case 184 -> 188;
                            case 185 -> 171;
                            case 186 -> 166;
                            case 187 -> 242;
                            case 188 -> 36;
                            case 189 -> 88;
                            case 190 -> 214;
                            case 191 -> 168;
                            case 192 -> 173;
                            case 193 -> 72;
                            case 194 -> 143;
                            case 195 -> 150;
                            case 196 -> 74;
                            case 197 -> 104;
                            case 198 -> 64;
                            case 199 -> 84;
                            case 200 -> 102;
                            case 201 -> 97;
                            case 202 -> 45;
                            case 203 -> 4;
                            case 204 -> 211;
                            case 205 -> 244;
                            case 206 -> 20;
                            case 207 -> 135;
                            case 208 -> 39;
                            case 209 -> 21;
                            case 210 -> 116;
                            case 211 -> 178;
                            case 212 -> 132;
                            case 213 -> 210;
                            case 214 -> 246;
                            case 215 -> 31;
                            case 216 -> 175;
                            case 217 -> 123;
                            case 218 -> 165;
                            case 219 -> 60;
                            case 220 -> 181;
                            case 221 -> 183;
                            case 222 -> 205;
                            case 223 -> 207;
                            case 224 -> 12;
                            case 225 -> 95;
                            case 226 -> 19;
                            case 227 -> 10;
                            case 228 -> 218;
                            case 229 -> 108;
                            case 230 -> 68;
                            case 231 -> 179;
                            case 232 -> 254;
                            case 233 -> 23;
                            case 234 -> 93;
                            case 235 -> 238;
                            case 236 -> 144;
                            case 237 -> 134;
                            case 238 -> 77;
                            case 239 -> 89;
                            case 240 -> 90;
                            case 241 -> 157;
                            case 242 -> 1;
                            case 243 -> 51;
                            case 244 -> 226;
                            case 245 -> 70;
                            case 246 -> 83;
                            case 247 -> 112;
                            case 248 -> 187;
                            case 249 -> 180;
                            case 250 -> 59;
                            case 251 -> 69;
                            case 252 -> 114;
                            case 253 -> 170;
                            case 254 -> 136;
                            default -> 229;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 != 0) {
                ActionTimestamp.x(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 22380885423901L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.x();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-189134010 + -3047, -189134010 + -24777, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-189134010 + -3051, 189134010 + 24287, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-189134010 + -3078, 189134010 + 18454, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-189134010 + -3047, -189134010 + -24777, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-189134010 + -3051, 189134010 + 24287, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-189134010 + -3071, 189134010 + 29136, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 91316689415356L;
                        int n3 = SshAgentIpcService.x();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1389735210 + 14269, 1389735210 + 7853, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 != 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 != 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1389735210 + 14266, -1389735210 - -2650, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 != 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 42031935364569L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                n2 = SshAgentIpcService.G();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1385409900 + 10287, 1385409900 - 11443, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1385409900 + 10291, -1385409900 - -9929, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1385409900 + 10260, -1385409900 + -15878, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1385409900 + 10291, -1385409900 - -9929, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1385409900 + 10285, -1385409900 + -8317, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1385409900 + 10287, 1385409900 - 11443, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1385409900 + 10291, -1385409900 - -9929, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1385409900 + 10275, -1385409900 + -1844, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1385409900 + 10287, 1385409900 - 11443, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1385409900 + 10291, -1385409900 - -9929, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1385409900 + 10274, 1385409900 + 4652, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1385409900 + 10287, 1385409900 - 11443, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1385409900 + 10291, -1385409900 - -9929, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1385409900 + 10273, 1385409900 + 11987, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 7793192193890L;
                    Object object = this.lock;
                    n3 = SshAgentIpcService.G();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2121499020 + 1428, 2121499020 + 20598, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(2121499020 + 1432, -2121499020 + -21134, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2121499020 + 1451, 2121499020 + 25697, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(2121499020 + 1444, -2121499020 + -21891, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2121499020 + 1428, 2121499020 + 20598, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2121499020 + 1432, -2121499020 + -21134, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2121499020 + 1445, 2121499020 + 7456, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2121499020 + 1428, 2121499020 + 20598, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(2121499020 + 1432, -2121499020 + -21134, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2121499020 + 1446, -2121499020 + -24184, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2121499020 + 1428, 2121499020 + 20598, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2121499020 + 1432, -2121499020 + -21134, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2121499020 + 1447, 2121499020 + 27646, (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2121499020 + 1428, 2121499020 + 20598, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2121499020 + 1432, -2121499020 + -21134, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2121499020 + 1408, -2121499020 + -21427, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2121499020 + 1409, 2121499020 + 24236, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\n\u0083\u0010\u00fe'/Y\u00a4\u0014@\u00c0aq\u00f7V\u00ec\u0091\u00bb\u0098\u00d75i\u00bc\u00d3\u008e\u00d0\u00ae-\r\u0006S\u008b;\u00ff(N\u0018\u0090\u000e\u001b\u0098:\u00aeWN\u0004\u001e/\u0095\u0010W\u00aeq\u00d68\u00c3BVF\u00f6c\t\u00e3T\u00ebbOn\u00e1\u001e\u00ee\u0005XzZ\u00c1\u001e\brm\u001fR\u0094\u009c)0\u0014#/u\u0017\u0018\u0092$\u009e\u00cc\u00a4\u0092\u0006\u008by4\u00db>\u00d7\t`\u0005\u00a3\u001c%\r\u00f1\u001e\u00beI\u0093\u00c3\u00ba\u0001\u00e5\u00c1\u00f7\u00fb\u001a\u00ae\u00fa\u0010Q\u00fd\u00c88\u00d2\u00b6\u00d8\u00f7+\u0098\u0092\u0090\u0095\u00d2\u0098G\u0010\u00d5\u00df\u001a\u00d4\u00dc\u00d1\u00df\"\u00cd5\u00d0\u008a\u00a5\u00c1\u0015X\ti\u009dlJ\u00ecL\u00b3\u00c5J\u0010\u00bb|\u00d7\u00a0e_\u00e8\u00f3+\u000f\f\u00cd>)fE?\u008dm\u00fdGz\u0098x\u009e5\u00c1\u0007\u0012\u00e6q\u00ef\u00e8\u00da\u00ff\u00ed\u008b\u00b1\u0002}@Hc\u00c3\u0018eHt\u00f0'\u0019?'\u00d7P&\"\u0013|\u00cch\u00a7\u00813\u00bfW\b\u000fp$za\u008c\u0092\u00ab]\u00a6.\u00a4\u0091\b\u00ba\u0081\u0006\u00cf\u00b7/MF\f\u00fd\u0083\u00fe\u0094\u00b5&\u00e3`c5W\u008eF\u00ff\u00d6\u00be>\u00bds\u00e2\u00caClYa\u00bb\u0017[\u0002\u00b0\u00c5\u00a0c\nM\t\u009b\u00f03'\u0019FA*\u00ed\u00d0\f\u0003\u00a4\u008am&A\u0080\u00055\u00bcF\u009e[!\u00bd#4\u00bf\u00ac\u0015fz\u00ed\u0001$O2\u00f0N\u0090C\u00e9^\u00b7\u00b9D\u001f\u00bc\u0081\u00d3\u00da\u00b2\"\u00e4\u00a5\u00d7w\u001e?z?J\u00a9\u00d0Z\u00ac0\u00dc\u00a7|9\u0019t\u00f3\u0082I\u00bc\u00c9\u000b\"y\u0005\u00cb\u00ca\u00cd\f\u001d\u009e\u0096\u00e2\u0015\u0019\u00bbb\u0090!\u00ce\u009d\u0000\u0092\u00d5\u00ab\u00a0r`V\u0014\u00a8y~-\u00b0)\u0097M\u00b6C\u001e\u0011q\u00c3e\u00bbH\u00a6\u00b4\u0006\r\u008bg\u0096\u0081\u000e\u0089\u0018\u0010\u00d6\u00fb\u00c0xl\u0017\u0095\u0080I{=\u0010\u000f\u00f6\u0005\"\u00e5\u00a3\u0007\u00ac\u00ac\u00dbe\u0097\u0088\u00db\u0007\u0018{)\u00f3.\u00b5\u00fa(\u0094\u0005\u009ak+~!\t\u001f5-A;{\u00be\u00a7\u0016\u00be\u0001H\u00f8\u00eeQ\u00c3C\u00de\u00d9\u00d4\u0014\u00e2;\u00be\u00f7\u00a8\u001f\u0010\u00ad\u009b\u00da\u00c5\u000f6\u00c9\u0080\u00db\u0080\u0004\u00f1\u0085p)a\u0093\u0012u\u0005\"E\u00b8\u00ec\u00fdU\u00c6\u00189H\u00e4\u00edM\u0003w\u009fk\u00de\u00a3<\u00ea\u00d4\u0084\u001b\u0015\t\u00ec\u00eb7A\u00cc\u00e8eXK\u000e\u00f9\u00bey5\u00bf\u00d9\u0016>\u008c^\u00fe}\u00ed\u00a2\u001bB\u00f3\t\u0099J\u00f9=f\u00be\u00d25\u00ed\u00c4\u0086AC\u00ad\f\u00ef\u0083\u0095\u009d@\u0090)1\u00ba\n\u00b6\bS\u00e1\u0015\u0012\u00051\u0012Z\u0018\u00a385\u00ed\u00cc\u00cb\u00cc~\u009e\u0018\u00f3+\u00a5\r\u0091\u0013\u00c0\u0007\u0095\u009b\u00a2\u00d5\u00fd\u00ca)\u008dC\u00f5\u0082v)|\u00c4\u00c4[|\u00ba6\u008c\u00c2\u00a1\u00e0\u00a6\u00ae\u00cdVp\u00a2\u00d7\u00d8r\u0081\u00d6{\u009e\u00b6\u00b9\u0098\u00fd\u00b9\u0083\u001d\u00b0_S\f\t\u00ed\u00ab\u00fc\u0092\u00f4\u0098\u00e6\u0004]";
                var4_3 = "\n\u0083\u0010\u00fe'/Y\u00a4\u0014@\u00c0aq\u00f7V\u00ec\u0091\u00bb\u0098\u00d75i\u00bc\u00d3\u008e\u00d0\u00ae-\r\u0006S\u008b;\u00ff(N\u0018\u0090\u000e\u001b\u0098:\u00aeWN\u0004\u001e/\u0095\u0010W\u00aeq\u00d68\u00c3BVF\u00f6c\t\u00e3T\u00ebbOn\u00e1\u001e\u00ee\u0005XzZ\u00c1\u001e\brm\u001fR\u0094\u009c)0\u0014#/u\u0017\u0018\u0092$\u009e\u00cc\u00a4\u0092\u0006\u008by4\u00db>\u00d7\t`\u0005\u00a3\u001c%\r\u00f1\u001e\u00beI\u0093\u00c3\u00ba\u0001\u00e5\u00c1\u00f7\u00fb\u001a\u00ae\u00fa\u0010Q\u00fd\u00c88\u00d2\u00b6\u00d8\u00f7+\u0098\u0092\u0090\u0095\u00d2\u0098G\u0010\u00d5\u00df\u001a\u00d4\u00dc\u00d1\u00df\"\u00cd5\u00d0\u008a\u00a5\u00c1\u0015X\ti\u009dlJ\u00ecL\u00b3\u00c5J\u0010\u00bb|\u00d7\u00a0e_\u00e8\u00f3+\u000f\f\u00cd>)fE?\u008dm\u00fdGz\u0098x\u009e5\u00c1\u0007\u0012\u00e6q\u00ef\u00e8\u00da\u00ff\u00ed\u008b\u00b1\u0002}@Hc\u00c3\u0018eHt\u00f0'\u0019?'\u00d7P&\"\u0013|\u00cch\u00a7\u00813\u00bfW\b\u000fp$za\u008c\u0092\u00ab]\u00a6.\u00a4\u0091\b\u00ba\u0081\u0006\u00cf\u00b7/MF\f\u00fd\u0083\u00fe\u0094\u00b5&\u00e3`c5W\u008eF\u00ff\u00d6\u00be>\u00bds\u00e2\u00caClYa\u00bb\u0017[\u0002\u00b0\u00c5\u00a0c\nM\t\u009b\u00f03'\u0019FA*\u00ed\u00d0\f\u0003\u00a4\u008am&A\u0080\u00055\u00bcF\u009e[!\u00bd#4\u00bf\u00ac\u0015fz\u00ed\u0001$O2\u00f0N\u0090C\u00e9^\u00b7\u00b9D\u001f\u00bc\u0081\u00d3\u00da\u00b2\"\u00e4\u00a5\u00d7w\u001e?z?J\u00a9\u00d0Z\u00ac0\u00dc\u00a7|9\u0019t\u00f3\u0082I\u00bc\u00c9\u000b\"y\u0005\u00cb\u00ca\u00cd\f\u001d\u009e\u0096\u00e2\u0015\u0019\u00bbb\u0090!\u00ce\u009d\u0000\u0092\u00d5\u00ab\u00a0r`V\u0014\u00a8y~-\u00b0)\u0097M\u00b6C\u001e\u0011q\u00c3e\u00bbH\u00a6\u00b4\u0006\r\u008bg\u0096\u0081\u000e\u0089\u0018\u0010\u00d6\u00fb\u00c0xl\u0017\u0095\u0080I{=\u0010\u000f\u00f6\u0005\"\u00e5\u00a3\u0007\u00ac\u00ac\u00dbe\u0097\u0088\u00db\u0007\u0018{)\u00f3.\u00b5\u00fa(\u0094\u0005\u009ak+~!\t\u001f5-A;{\u00be\u00a7\u0016\u00be\u0001H\u00f8\u00eeQ\u00c3C\u00de\u00d9\u00d4\u0014\u00e2;\u00be\u00f7\u00a8\u001f\u0010\u00ad\u009b\u00da\u00c5\u000f6\u00c9\u0080\u00db\u0080\u0004\u00f1\u0085p)a\u0093\u0012u\u0005\"E\u00b8\u00ec\u00fdU\u00c6\u00189H\u00e4\u00edM\u0003w\u009fk\u00de\u00a3<\u00ea\u00d4\u0084\u001b\u0015\t\u00ec\u00eb7A\u00cc\u00e8eXK\u000e\u00f9\u00bey5\u00bf\u00d9\u0016>\u008c^\u00fe}\u00ed\u00a2\u001bB\u00f3\t\u0099J\u00f9=f\u00be\u00d25\u00ed\u00c4\u0086AC\u00ad\f\u00ef\u0083\u0095\u009d@\u0090)1\u00ba\n\u00b6\bS\u00e1\u0015\u0012\u00051\u0012Z\u0018\u00a385\u00ed\u00cc\u00cb\u00cc~\u009e\u0018\u00f3+\u00a5\r\u0091\u0013\u00c0\u0007\u0095\u009b\u00a2\u00d5\u00fd\u00ca)\u008dC\u00f5\u0082v)|\u00c4\u00c4[|\u00ba6\u008c\u00c2\u00a1\u00e0\u00a6\u00ae\u00cdVp\u00a2\u00d7\u00d8r\u0081\u00d6{\u009e\u00b6\u00b9\u0098\u00fd\u00b9\u0083\u001d\u00b0_S\f\t\u00ed\u00ab\u00fc\u0092\u00f4\u0098\u00e6\u0004]".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 80;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f9\u00a7e\u0000zg\u00e3\u0013)\u00bf\u00df8\\\u00c2\u0091v\u0094NnJ\u0005\u00a1%-\u009d/\u00a6&\u0011\u0014p*y2\u00ea QA\u0012\u009c\u00fc\u00ab\u0012q\u00a2)\u00e0D5N";
                    var4_3 = "\u00f9\u00a7e\u0000zg\u00e3\u0013)\u00bf\u00df8\\\u00c2\u0091v\u0094NnJ\u0005\u00a1%-\u009d/\u00a6&\u0011\u0014p*y2\u00ea QA\u0012\u009c\u00fc\u00ab\u0012q\u00a2)\u00e0D5N".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 105;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 51;
                            break;
                        }
                        case 1: {
                            v15 = 53;
                            break;
                        }
                        case 2: {
                            v15 = 99;
                            break;
                        }
                        case 3: {
                            v15 = 83;
                            break;
                        }
                        case 4: {
                            v15 = 61;
                            break;
                        }
                        case 5: {
                            v15 = 104;
                            break;
                        }
                        default: {
                            v15 = 110;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x484E) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 34;
                case 1 -> 236;
                case 2 -> 7;
                case 3 -> 87;
                case 4 -> 146;
                case 5 -> 134;
                case 6 -> 251;
                case 7 -> 136;
                case 8 -> 254;
                case 9 -> 23;
                case 10 -> 229;
                case 11 -> 13;
                case 12 -> 193;
                case 13 -> 203;
                case 14 -> 19;
                case 15 -> 135;
                case 16 -> 209;
                case 17 -> 114;
                case 18 -> 150;
                case 19 -> 101;
                case 20 -> 177;
                case 21 -> 21;
                case 22 -> 95;
                case 23 -> 117;
                case 24 -> 67;
                case 25 -> 57;
                case 26 -> 92;
                case 27 -> 226;
                case 28 -> 66;
                case 29 -> 112;
                case 30 -> 59;
                case 31 -> 255;
                case 32 -> 144;
                case 33 -> 116;
                case 34 -> 170;
                case 35 -> 216;
                case 36 -> 207;
                case 37 -> 241;
                case 38 -> 37;
                case 39 -> 71;
                case 40 -> 246;
                case 41 -> 158;
                case 42 -> 247;
                case 43 -> 65;
                case 44 -> 118;
                case 45 -> 38;
                case 46 -> 213;
                case 47 -> 152;
                case 48 -> 77;
                case 49 -> 80;
                case 50 -> 174;
                case 51 -> 49;
                case 52 -> 200;
                case 53 -> 0;
                case 54 -> 145;
                case 55 -> 227;
                case 56 -> 40;
                case 57 -> 159;
                case 58 -> 210;
                case 59 -> 122;
                case 60 -> 20;
                case 61 -> 190;
                case 62 -> 113;
                case 63 -> 233;
                case 64 -> 103;
                case 65 -> 219;
                case 66 -> 155;
                case 67 -> 139;
                case 68 -> 102;
                case 69 -> 58;
                case 70 -> 218;
                case 71 -> 169;
                case 72 -> 64;
                case 73 -> 211;
                case 74 -> 208;
                case 75 -> 160;
                case 76 -> 48;
                case 77 -> 69;
                case 78 -> 171;
                case 79 -> 106;
                case 80 -> 162;
                case 81 -> 183;
                case 82 -> 250;
                case 83 -> 142;
                case 84 -> 239;
                case 85 -> 74;
                case 86 -> 123;
                case 87 -> 121;
                case 88 -> 173;
                case 89 -> 242;
                case 90 -> 68;
                case 91 -> 120;
                case 92 -> 51;
                case 93 -> 252;
                case 94 -> 53;
                case 95 -> 96;
                case 96 -> 90;
                case 97 -> 88;
                case 98 -> 50;
                case 99 -> 224;
                case 100 -> 97;
                case 101 -> 167;
                case 102 -> 192;
                case 103 -> 130;
                case 104 -> 217;
                case 105 -> 2;
                case 106 -> 179;
                case 107 -> 234;
                case 108 -> 109;
                case 109 -> 205;
                case 110 -> 237;
                case 111 -> 104;
                case 112 -> 47;
                case 113 -> 137;
                case 114 -> 148;
                case 115 -> 180;
                case 116 -> 108;
                case 117 -> 61;
                case 118 -> 55;
                case 119 -> 188;
                case 120 -> 22;
                case 121 -> 63;
                case 122 -> 141;
                case 123 -> 132;
                case 124 -> 39;
                case 125 -> 184;
                case 126 -> 126;
                case 127 -> 91;
                case 128 -> 221;
                case 129 -> 84;
                case 130 -> 166;
                case 131 -> 12;
                case 132 -> 191;
                case 133 -> 93;
                case 134 -> 75;
                case 135 -> 81;
                case 136 -> 1;
                case 137 -> 36;
                case 138 -> 115;
                case 139 -> 243;
                case 140 -> 182;
                case 141 -> 100;
                case 142 -> 52;
                case 143 -> 186;
                case 144 -> 157;
                case 145 -> 124;
                case 146 -> 178;
                case 147 -> 110;
                case 148 -> 76;
                case 149 -> 187;
                case 150 -> 14;
                case 151 -> 225;
                case 152 -> 43;
                case 153 -> 16;
                case 154 -> 70;
                case 155 -> 9;
                case 156 -> 82;
                case 157 -> 175;
                case 158 -> 244;
                case 159 -> 119;
                case 160 -> 56;
                case 161 -> 54;
                case 162 -> 176;
                case 163 -> 10;
                case 164 -> 181;
                case 165 -> 35;
                case 166 -> 196;
                case 167 -> 215;
                case 168 -> 165;
                case 169 -> 72;
                case 170 -> 94;
                case 171 -> 168;
                case 172 -> 156;
                case 173 -> 73;
                case 174 -> 33;
                case 175 -> 17;
                case 176 -> 197;
                case 177 -> 44;
                case 178 -> 89;
                case 179 -> 245;
                case 180 -> 99;
                case 181 -> 32;
                case 182 -> 189;
                case 183 -> 133;
                case 184 -> 11;
                case 185 -> 223;
                case 186 -> 240;
                case 187 -> 204;
                case 188 -> 220;
                case 189 -> 238;
                case 190 -> 107;
                case 191 -> 131;
                case 192 -> 212;
                case 193 -> 198;
                case 194 -> 140;
                case 195 -> 79;
                case 196 -> 143;
                case 197 -> 164;
                case 198 -> 147;
                case 199 -> 25;
                case 200 -> 111;
                case 201 -> 60;
                case 202 -> 85;
                case 203 -> 230;
                case 204 -> 78;
                case 205 -> 206;
                case 206 -> 5;
                case 207 -> 172;
                case 208 -> 3;
                case 209 -> 46;
                case 210 -> 27;
                case 211 -> 228;
                case 212 -> 45;
                case 213 -> 154;
                case 214 -> 253;
                case 215 -> 125;
                case 216 -> 161;
                case 217 -> 235;
                case 218 -> 105;
                case 219 -> 42;
                case 220 -> 163;
                case 221 -> 138;
                case 222 -> 149;
                case 223 -> 8;
                case 224 -> 29;
                case 225 -> 26;
                case 226 -> 185;
                case 227 -> 6;
                case 228 -> 194;
                case 229 -> 30;
                case 230 -> 199;
                case 231 -> 153;
                case 232 -> 18;
                case 233 -> 232;
                case 234 -> 86;
                case 235 -> 24;
                case 236 -> 222;
                case 237 -> 83;
                case 238 -> 202;
                case 239 -> 249;
                case 240 -> 41;
                case 241 -> 4;
                case 242 -> 127;
                case 243 -> 15;
                case 244 -> 201;
                case 245 -> 98;
                case 246 -> 248;
                case 247 -> 128;
                case 248 -> 129;
                case 249 -> 214;
                case 250 -> 31;
                case 251 -> 62;
                case 252 -> 231;
                case 253 -> 195;
                case 254 -> 28;
                default -> 151;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 138581952983838L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(538173420 + (char)-31331, 538173420 + 21194, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 79623725383107L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.x();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 != 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 != 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-673306590 + -15565, -673306590 + -28202, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-673306590 + -15564, 673306590 + (char)-25095, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-673306590 + -15563, 673306590 + 15770, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "+\u009bg\u00bc\u009ef)\u000e\u0010\u0098\u00fb\u00e0\u0011\u00d4h\u0099\u0096\u00f2\u00f0vep{,\u00f8";
                    var4_3 = "+\u009bg\u00bc\u009ef)\u000e\u0010\u0098\u00fb\u00e0\u0011\u00d4h\u0099\u0096\u00f2\u00f0vep{,\u00f8".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 116;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u008f|\u00a6\u0015\u00835\u009b\n3\u00b7\u00e3\u00d02\u007f\u00a5#[\u008aw9\u009co\u00ac\u00d2\u00b6\u00eb\u00d4]\u00df\u00f9i\u00f9\u00acs\u00ce\u00b7\u00d6\\\u008dd|\u001f\u00d8{\u0097.\u00c1\u00c0\u00d7\u00b5\u0097\u00c5\u00c5\u00f1/\u00e1\u00b1n\u00a2";
                        var4_3 = "\u008f|\u00a6\u0015\u00835\u009b\n3\u00b7\u00e3\u00d02\u007f\u00a5#[\u008aw9\u009co\u00ac\u00d2\u00b6\u00eb\u00d4]\u00df\u00f9i\u00f9\u00acs\u00ce\u00b7\u00d6\\\u008dd|\u001f\u00d8{\u0097.\u00c1\u00c0\u00d7\u00b5\u0097\u00c5\u00c5\u00f1/\u00e1\u00b1n\u00a2".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 71;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 28;
                                break;
                            }
                            case 1: {
                                v15 = 74;
                                break;
                            }
                            case 2: {
                                v15 = 117;
                                break;
                            }
                            case 3: {
                                v15 = 93;
                                break;
                            }
                            case 4: {
                                v15 = 8;
                                break;
                            }
                            case 5: {
                                v15 = 8;
                                break;
                            }
                            default: {
                                v15 = 47;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x1697) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 65;
                    case 1 -> 243;
                    case 2 -> 208;
                    case 3 -> 6;
                    case 4 -> 185;
                    case 5 -> 9;
                    case 6 -> 160;
                    case 7 -> 181;
                    case 8 -> 94;
                    case 9 -> 134;
                    case 10 -> 191;
                    case 11 -> 227;
                    case 12 -> 102;
                    case 13 -> 246;
                    case 14 -> 63;
                    case 15 -> 129;
                    case 16 -> 161;
                    case 17 -> 43;
                    case 18 -> 162;
                    case 19 -> 15;
                    case 20 -> 158;
                    case 21 -> 79;
                    case 22 -> 104;
                    case 23 -> 220;
                    case 24 -> 36;
                    case 25 -> 199;
                    case 26 -> 73;
                    case 27 -> 80;
                    case 28 -> 151;
                    case 29 -> 214;
                    case 30 -> 169;
                    case 31 -> 51;
                    case 32 -> 44;
                    case 33 -> 238;
                    case 34 -> 32;
                    case 35 -> 118;
                    case 36 -> 52;
                    case 37 -> 75;
                    case 38 -> 110;
                    case 39 -> 25;
                    case 40 -> 78;
                    case 41 -> 100;
                    case 42 -> 198;
                    case 43 -> 173;
                    case 44 -> 121;
                    case 45 -> 62;
                    case 46 -> 39;
                    case 47 -> 137;
                    case 48 -> 103;
                    case 49 -> 34;
                    case 50 -> 147;
                    case 51 -> 92;
                    case 52 -> 7;
                    case 53 -> 18;
                    case 54 -> 1;
                    case 55 -> 205;
                    case 56 -> 109;
                    case 57 -> 115;
                    case 58 -> 48;
                    case 59 -> 97;
                    case 60 -> 101;
                    case 61 -> 172;
                    case 62 -> 96;
                    case 63 -> 165;
                    case 64 -> 30;
                    case 65 -> 12;
                    case 66 -> 135;
                    case 67 -> 117;
                    case 68 -> 24;
                    case 69 -> 29;
                    case 70 -> 23;
                    case 71 -> 10;
                    case 72 -> 108;
                    case 73 -> 225;
                    case 74 -> 26;
                    case 75 -> 3;
                    case 76 -> 98;
                    case 77 -> 250;
                    case 78 -> 197;
                    case 79 -> 106;
                    case 80 -> 76;
                    case 81 -> 200;
                    case 82 -> 166;
                    case 83 -> 167;
                    case 84 -> 163;
                    case 85 -> 31;
                    case 86 -> 144;
                    case 87 -> 113;
                    case 88 -> 218;
                    case 89 -> 231;
                    case 90 -> 148;
                    case 91 -> 155;
                    case 92 -> 194;
                    case 93 -> 99;
                    case 94 -> 153;
                    case 95 -> 222;
                    case 96 -> 249;
                    case 97 -> 20;
                    case 98 -> 122;
                    case 99 -> 216;
                    case 100 -> 40;
                    case 101 -> 210;
                    case 102 -> 202;
                    case 103 -> 251;
                    case 104 -> 188;
                    case 105 -> 136;
                    case 106 -> 38;
                    case 107 -> 201;
                    case 108 -> 152;
                    case 109 -> 90;
                    case 110 -> 178;
                    case 111 -> 252;
                    case 112 -> 19;
                    case 113 -> 211;
                    case 114 -> 83;
                    case 115 -> 123;
                    case 116 -> 174;
                    case 117 -> 241;
                    case 118 -> 170;
                    case 119 -> 125;
                    case 120 -> 61;
                    case 121 -> 16;
                    case 122 -> 60;
                    case 123 -> 72;
                    case 124 -> 87;
                    case 125 -> 49;
                    case 126 -> 224;
                    case 127 -> 168;
                    case 128 -> 27;
                    case 129 -> 66;
                    case 130 -> 142;
                    case 131 -> 195;
                    case 132 -> 82;
                    case 133 -> 13;
                    case 134 -> 8;
                    case 135 -> 192;
                    case 136 -> 77;
                    case 137 -> 206;
                    case 138 -> 124;
                    case 139 -> 212;
                    case 140 -> 254;
                    case 141 -> 235;
                    case 142 -> 242;
                    case 143 -> 237;
                    case 144 -> 187;
                    case 145 -> 54;
                    case 146 -> 111;
                    case 147 -> 228;
                    case 148 -> 91;
                    case 149 -> 130;
                    case 150 -> 131;
                    case 151 -> 221;
                    case 152 -> 59;
                    case 153 -> 58;
                    case 154 -> 182;
                    case 155 -> 247;
                    case 156 -> 17;
                    case 157 -> 50;
                    case 158 -> 190;
                    case 159 -> 234;
                    case 160 -> 189;
                    case 161 -> 217;
                    case 162 -> 114;
                    case 163 -> 215;
                    case 164 -> 126;
                    case 165 -> 236;
                    case 166 -> 68;
                    case 167 -> 223;
                    case 168 -> 95;
                    case 169 -> 177;
                    case 170 -> 35;
                    case 171 -> 203;
                    case 172 -> 176;
                    case 173 -> 67;
                    case 174 -> 64;
                    case 175 -> 219;
                    case 176 -> 244;
                    case 177 -> 128;
                    case 178 -> 132;
                    case 179 -> 133;
                    case 180 -> 157;
                    case 181 -> 204;
                    case 182 -> 180;
                    case 183 -> 2;
                    case 184 -> 140;
                    case 185 -> 143;
                    case 186 -> 196;
                    case 187 -> 74;
                    case 188 -> 46;
                    case 189 -> 253;
                    case 190 -> 105;
                    case 191 -> 69;
                    case 192 -> 193;
                    case 193 -> 239;
                    case 194 -> 146;
                    case 195 -> 71;
                    case 196 -> 127;
                    case 197 -> 240;
                    case 198 -> 229;
                    case 199 -> 183;
                    case 200 -> 88;
                    case 201 -> 57;
                    case 202 -> 233;
                    case 203 -> 156;
                    case 204 -> 207;
                    case 205 -> 37;
                    case 206 -> 154;
                    case 207 -> 245;
                    case 208 -> 22;
                    case 209 -> 145;
                    case 210 -> 179;
                    case 211 -> 33;
                    case 212 -> 112;
                    case 213 -> 28;
                    case 214 -> 141;
                    case 215 -> 138;
                    case 216 -> 159;
                    case 217 -> 14;
                    case 218 -> 139;
                    case 219 -> 171;
                    case 220 -> 230;
                    case 221 -> 248;
                    case 222 -> 149;
                    case 223 -> 209;
                    case 224 -> 0;
                    case 225 -> 70;
                    case 226 -> 42;
                    case 227 -> 89;
                    case 228 -> 116;
                    case 229 -> 47;
                    case 230 -> 81;
                    case 231 -> 4;
                    case 232 -> 150;
                    case 233 -> 232;
                    case 234 -> 45;
                    case 235 -> 85;
                    case 236 -> 120;
                    case 237 -> 175;
                    case 238 -> 11;
                    case 239 -> 86;
                    case 240 -> 164;
                    case 241 -> 186;
                    case 242 -> 184;
                    case 243 -> 5;
                    case 244 -> 53;
                    case 245 -> 84;
                    case 246 -> 213;
                    case 247 -> 55;
                    case 248 -> 255;
                    case 249 -> 93;
                    case 250 -> 21;
                    case 251 -> 226;
                    case 252 -> 56;
                    case 253 -> 119;
                    case 254 -> 41;
                    default -> 107;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 111581823347630L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u001dl\u0001nY~)D\t\u001af\u0012d\u0014<4X ";
                    var5_4 = "\u001dl\u0001nY~)D\t\u001af\u0012d\u0014<4X ".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 81;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 39;
                                    break;
                                }
                                case 1: {
                                    v11 = 88;
                                    break;
                                }
                                case 2: {
                                    v11 = 34;
                                    break;
                                }
                                case 3: {
                                    v11 = 81;
                                    break;
                                }
                                case 4: {
                                    v11 = 109;
                                    break;
                                }
                                case 5: {
                                    v11 = 67;
                                    break;
                                }
                                default: {
                                    v11 = 75;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 65634944678801L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u0007\u0010=^\u001eIw\u0004\u0001\u000e1D\n\r\u0011:D\u0012Ko'\u00103\t\r\u0011:D\u0012Ko+\u001a\r\n\u0017'I\u0018Fu+\u001d C\u0019O";
                    var5_4 = "\u0007\u0010=^\u001eIw\u0004\u0001\u000e1D\n\r\u0011:D\u0012Ko'\u00103\t\r\u0011:D\u0012Ko+\u001a\r\n\u0017'I\u0018Fu+\u001d C\u0019O".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 57;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0003\u001c5W\u0010Hr\u0006\u0003\u001c5W\u001cB";
                        var5_4 = "\u0003\u001c5W\u0010Hr\u0006\u0003\u001c5W\u001cB".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 55;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 119;
                                break;
                            }
                            case 1: {
                                v15 = 71;
                                break;
                            }
                            case 2: {
                                v15 = 109;
                                break;
                            }
                            case 3: {
                                v15 = 19;
                                break;
                            }
                            case 4: {
                                v15 = 78;
                                break;
                            }
                            case 5: {
                                v15 = 17;
                                break;
                            }
                            default: {
                                v15 = 34;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 9494576833548L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1595777250 + (char)-7407, 1595908320 - (char)-19475, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 130776957395675L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\b\u00e7\u0015k\u00ad\u0003\u00c4\u00178\u0005\u0002(rV\u00a2\r\nAE1\u00b1\u0013\u009fz\u001e\u00d9\u0094\u00e3 \u0010\u008d\u00d4rhh\u00ad\u008f\u0090\u00d5\u0000\u000e\u0095\u0095\u00e4.\u00ee\u0005=\u001b\u00950^3\u00af\u0088\u00d65)B\u0097y\u00ab\u00c0J\u00a4\u00db\u0093\u00cb\u001f\u0013\u000e\u008d\u00cf\u00c04\u008b9\u00e1\u00c5\u00ebvs\u0013;\\J}\u00b0\u00bc\u000b(\u0094\u00f5\u00835e\u0089\u00d5\u00f9X\u00e3\u00c1x,";
                    var4_3 = "\b\u00e7\u0015k\u00ad\u0003\u00c4\u00178\u0005\u0002(rV\u00a2\r\nAE1\u00b1\u0013\u009fz\u001e\u00d9\u0094\u00e3 \u0010\u008d\u00d4rhh\u00ad\u008f\u0090\u00d5\u0000\u000e\u0095\u0095\u00e4.\u00ee\u0005=\u001b\u00950^3\u00af\u0088\u00d65)B\u0097y\u00ab\u00c0J\u00a4\u00db\u0093\u00cb\u001f\u0013\u000e\u008d\u00cf\u00c04\u008b9\u00e1\u00c5\u00ebvs\u0013;\\J}\u00b0\u00bc\u000b(\u0094\u00f5\u00835e\u0089\u00d5\u00f9X\u00e3\u00c1x,".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 118;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "+\u009e\u00d1Vk\u001d\u0098\u00f1@[\u00cb\u0089Z\u0010\u00a0\u0007L\u00b9@tG\u00f5\u00f7%\u00c2~\u00ae\u00a0\u008e9~_\u00b3\u00f3=\u0019(M\u00dbg\u0011(\\\u0080\u00f4\u0093}\u00bf\u0089\u00bd^H\u00b3Q`\u0092\u00ed\u0002\u00bc\u00ed\u00b2\u00a67\u008au\u001e\u00e9H\u00e9I^\u00afK\u0005\u00e2t\u001c\u00f1\u0017sS\u00f4\u0085\u00f8\u0095X\u00e6%pSz\u0000W";
                        var4_3 = "+\u009e\u00d1Vk\u001d\u0098\u00f1@[\u00cb\u0089Z\u0010\u00a0\u0007L\u00b9@tG\u00f5\u00f7%\u00c2~\u00ae\u00a0\u008e9~_\u00b3\u00f3=\u0019(M\u00dbg\u0011(\\\u0080\u00f4\u0093}\u00bf\u0089\u00bd^H\u00b3Q`\u0092\u00ed\u0002\u00bc\u00ed\u00b2\u00a67\u008au\u001e\u00e9H\u00e9I^\u00afK\u0005\u00e2t\u001c\u00f1\u0017sS\u00f4\u0085\u00f8\u0095X\u00e6%pSz\u0000W".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 14;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 45;
                                break;
                            }
                            case 1: {
                                v15 = 13;
                                break;
                            }
                            case 2: {
                                v15 = 33;
                                break;
                            }
                            case 3: {
                                v15 = 107;
                                break;
                            }
                            case 4: {
                                v15 = 46;
                                break;
                            }
                            case 5: {
                                v15 = 102;
                                break;
                            }
                            default: {
                                v15 = 40;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA7FF) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 230;
                    case 1 -> 245;
                    case 2 -> 201;
                    case 3 -> 131;
                    case 4 -> 140;
                    case 5 -> 200;
                    case 6 -> 197;
                    case 7 -> 81;
                    case 8 -> 28;
                    case 9 -> 173;
                    case 10 -> 241;
                    case 11 -> 166;
                    case 12 -> 224;
                    case 13 -> 217;
                    case 14 -> 101;
                    case 15 -> 203;
                    case 16 -> 246;
                    case 17 -> 84;
                    case 18 -> 19;
                    case 19 -> 36;
                    case 20 -> 174;
                    case 21 -> 128;
                    case 22 -> 208;
                    case 23 -> 30;
                    case 24 -> 47;
                    case 25 -> 17;
                    case 26 -> 43;
                    case 27 -> 27;
                    case 28 -> 177;
                    case 29 -> 209;
                    case 30 -> 85;
                    case 31 -> 181;
                    case 32 -> 253;
                    case 33 -> 255;
                    case 34 -> 104;
                    case 35 -> 92;
                    case 36 -> 67;
                    case 37 -> 194;
                    case 38 -> 236;
                    case 39 -> 178;
                    case 40 -> 98;
                    case 41 -> 139;
                    case 42 -> 132;
                    case 43 -> 210;
                    case 44 -> 34;
                    case 45 -> 161;
                    case 46 -> 127;
                    case 47 -> 90;
                    case 48 -> 111;
                    case 49 -> 193;
                    case 50 -> 49;
                    case 51 -> 233;
                    case 52 -> 65;
                    case 53 -> 151;
                    case 54 -> 155;
                    case 55 -> 153;
                    case 56 -> 18;
                    case 57 -> 112;
                    case 58 -> 199;
                    case 59 -> 44;
                    case 60 -> 4;
                    case 61 -> 80;
                    case 62 -> 198;
                    case 63 -> 100;
                    case 64 -> 26;
                    case 65 -> 12;
                    case 66 -> 74;
                    case 67 -> 232;
                    case 68 -> 142;
                    case 69 -> 103;
                    case 70 -> 2;
                    case 71 -> 229;
                    case 72 -> 105;
                    case 73 -> 96;
                    case 74 -> 66;
                    case 75 -> 53;
                    case 76 -> 226;
                    case 77 -> 95;
                    case 78 -> 239;
                    case 79 -> 119;
                    case 80 -> 54;
                    case 81 -> 22;
                    case 82 -> 79;
                    case 83 -> 205;
                    case 84 -> 78;
                    case 85 -> 211;
                    case 86 -> 86;
                    case 87 -> 206;
                    case 88 -> 7;
                    case 89 -> 202;
                    case 90 -> 228;
                    case 91 -> 115;
                    case 92 -> 184;
                    case 93 -> 169;
                    case 94 -> 221;
                    case 95 -> 125;
                    case 96 -> 120;
                    case 97 -> 94;
                    case 98 -> 75;
                    case 99 -> 29;
                    case 100 -> 20;
                    case 101 -> 31;
                    case 102 -> 87;
                    case 103 -> 242;
                    case 104 -> 247;
                    case 105 -> 89;
                    case 106 -> 191;
                    case 107 -> 45;
                    case 108 -> 146;
                    case 109 -> 218;
                    case 110 -> 187;
                    case 111 -> 56;
                    case 112 -> 25;
                    case 113 -> 243;
                    case 114 -> 91;
                    case 115 -> 183;
                    case 116 -> 225;
                    case 117 -> 124;
                    case 118 -> 21;
                    case 119 -> 16;
                    case 120 -> 62;
                    case 121 -> 97;
                    case 122 -> 88;
                    case 123 -> 144;
                    case 124 -> 235;
                    case 125 -> 244;
                    case 126 -> 39;
                    case 127 -> 147;
                    case 128 -> 77;
                    case 129 -> 73;
                    case 130 -> 102;
                    case 131 -> 6;
                    case 132 -> 160;
                    case 133 -> 163;
                    case 134 -> 237;
                    case 135 -> 220;
                    case 136 -> 82;
                    case 137 -> 106;
                    case 138 -> 48;
                    case 139 -> 93;
                    case 140 -> 37;
                    case 141 -> 180;
                    case 142 -> 42;
                    case 143 -> 192;
                    case 144 -> 60;
                    case 145 -> 195;
                    case 146 -> 145;
                    case 147 -> 14;
                    case 148 -> 134;
                    case 149 -> 38;
                    case 150 -> 254;
                    case 151 -> 149;
                    case 152 -> 204;
                    case 153 -> 152;
                    case 154 -> 32;
                    case 155 -> 227;
                    case 156 -> 9;
                    case 157 -> 13;
                    case 158 -> 123;
                    case 159 -> 214;
                    case 160 -> 168;
                    case 161 -> 61;
                    case 162 -> 51;
                    case 163 -> 148;
                    case 164 -> 70;
                    case 165 -> 35;
                    case 166 -> 188;
                    case 167 -> 8;
                    case 168 -> 156;
                    case 169 -> 11;
                    case 170 -> 69;
                    case 171 -> 154;
                    case 172 -> 57;
                    case 173 -> 72;
                    case 174 -> 250;
                    case 175 -> 186;
                    case 176 -> 248;
                    case 177 -> 117;
                    case 178 -> 234;
                    case 179 -> 83;
                    case 180 -> 110;
                    case 181 -> 126;
                    case 182 -> 109;
                    case 183 -> 207;
                    case 184 -> 159;
                    case 185 -> 172;
                    case 186 -> 179;
                    case 187 -> 52;
                    case 188 -> 231;
                    case 189 -> 64;
                    case 190 -> 164;
                    case 191 -> 137;
                    case 192 -> 133;
                    case 193 -> 165;
                    case 194 -> 129;
                    case 195 -> 3;
                    case 196 -> 219;
                    case 197 -> 58;
                    case 198 -> 240;
                    case 199 -> 40;
                    case 200 -> 71;
                    case 201 -> 162;
                    case 202 -> 5;
                    case 203 -> 170;
                    case 204 -> 121;
                    case 205 -> 212;
                    case 206 -> 238;
                    case 207 -> 216;
                    case 208 -> 222;
                    case 209 -> 1;
                    case 210 -> 24;
                    case 211 -> 55;
                    case 212 -> 189;
                    case 213 -> 33;
                    case 214 -> 185;
                    case 215 -> 41;
                    case 216 -> 15;
                    case 217 -> 171;
                    case 218 -> 0;
                    case 219 -> 138;
                    case 220 -> 50;
                    case 221 -> 150;
                    case 222 -> 213;
                    case 223 -> 59;
                    case 224 -> 176;
                    case 225 -> 10;
                    case 226 -> 130;
                    case 227 -> 23;
                    case 228 -> 143;
                    case 229 -> 157;
                    case 230 -> 46;
                    case 231 -> 63;
                    case 232 -> 175;
                    case 233 -> 167;
                    case 234 -> 251;
                    case 235 -> 122;
                    case 236 -> 190;
                    case 237 -> 196;
                    case 238 -> 108;
                    case 239 -> 68;
                    case 240 -> 135;
                    case 241 -> 182;
                    case 242 -> 116;
                    case 243 -> 158;
                    case 244 -> 141;
                    case 245 -> 113;
                    case 246 -> 114;
                    case 247 -> 252;
                    case 248 -> 215;
                    case 249 -> 136;
                    case 250 -> 118;
                    case 251 -> 107;
                    case 252 -> 223;
                    case 253 -> 249;
                    case 254 -> 76;
                    default -> 99;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 87768549792003L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(893110980 - 17953, -893110980 + -4380, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 111809326865109L;
                    int n3 = SshAgentIpcService.x();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1556718390 + -((char)-27306), -1556718390 + -((char)-13006), (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 != 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 132370180002075L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00f0n\u001b\u008d\u0083\u0003\u00ce\u00d1\u008a";
                var4_3 = "\u00f0n\u001b\u008d\u0083\u0003\u00ce\u00d1\u008a".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 116;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 7;
                                break;
                            }
                            case 1: {
                                v11 = 1;
                                break;
                            }
                            case 2: {
                                v11 = 55;
                                break;
                            }
                            case 3: {
                                v11 = 127;
                                break;
                            }
                            case 4: {
                                v11 = 65;
                                break;
                            }
                            case 5: {
                                v11 = 101;
                                break;
                            }
                            default: {
                                v11 = 108;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x1DA0) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 123;
                    case 1 -> 239;
                    case 2 -> 82;
                    case 3 -> 245;
                    case 4 -> 201;
                    case 5 -> 73;
                    case 6 -> 194;
                    case 7 -> 176;
                    case 8 -> 9;
                    case 9 -> 211;
                    case 10 -> 132;
                    case 11 -> 240;
                    case 12 -> 20;
                    case 13 -> 167;
                    case 14 -> 60;
                    case 15 -> 7;
                    case 16 -> 32;
                    case 17 -> 217;
                    case 18 -> 190;
                    case 19 -> 159;
                    case 20 -> 162;
                    case 21 -> 204;
                    case 22 -> 111;
                    case 23 -> 219;
                    case 24 -> 97;
                    case 25 -> 80;
                    case 26 -> 46;
                    case 27 -> 163;
                    case 28 -> 41;
                    case 29 -> 110;
                    case 30 -> 237;
                    case 31 -> 92;
                    case 32 -> 49;
                    case 33 -> 141;
                    case 34 -> 150;
                    case 35 -> 118;
                    case 36 -> 75;
                    case 37 -> 188;
                    case 38 -> 43;
                    case 39 -> 225;
                    case 40 -> 47;
                    case 41 -> 64;
                    case 42 -> 74;
                    case 43 -> 151;
                    case 44 -> 183;
                    case 45 -> 16;
                    case 46 -> 86;
                    case 47 -> 93;
                    case 48 -> 94;
                    case 49 -> 207;
                    case 50 -> 195;
                    case 51 -> 143;
                    case 52 -> 109;
                    case 53 -> 182;
                    case 54 -> 148;
                    case 55 -> 78;
                    case 56 -> 117;
                    case 57 -> 26;
                    case 58 -> 22;
                    case 59 -> 62;
                    case 60 -> 149;
                    case 61 -> 153;
                    case 62 -> 242;
                    case 63 -> 136;
                    case 64 -> 236;
                    case 65 -> 250;
                    case 66 -> 50;
                    case 67 -> 12;
                    case 68 -> 88;
                    case 69 -> 66;
                    case 70 -> 168;
                    case 71 -> 223;
                    case 72 -> 116;
                    case 73 -> 197;
                    case 74 -> 187;
                    case 75 -> 196;
                    case 76 -> 231;
                    case 77 -> 160;
                    case 78 -> 85;
                    case 79 -> 248;
                    case 80 -> 52;
                    case 81 -> 95;
                    case 82 -> 131;
                    case 83 -> 243;
                    case 84 -> 134;
                    case 85 -> 135;
                    case 86 -> 31;
                    case 87 -> 226;
                    case 88 -> 254;
                    case 89 -> 114;
                    case 90 -> 192;
                    case 91 -> 107;
                    case 92 -> 21;
                    case 93 -> 102;
                    case 94 -> 186;
                    case 95 -> 6;
                    case 96 -> 124;
                    case 97 -> 105;
                    case 98 -> 70;
                    case 99 -> 215;
                    case 100 -> 154;
                    case 101 -> 172;
                    case 102 -> 83;
                    case 103 -> 214;
                    case 104 -> 170;
                    case 105 -> 90;
                    case 106 -> 146;
                    case 107 -> 137;
                    case 108 -> 61;
                    case 109 -> 28;
                    case 110 -> 106;
                    case 111 -> 126;
                    case 112 -> 209;
                    case 113 -> 69;
                    case 114 -> 121;
                    case 115 -> 177;
                    case 116 -> 198;
                    case 117 -> 44;
                    case 118 -> 112;
                    case 119 -> 0;
                    case 120 -> 87;
                    case 121 -> 230;
                    case 122 -> 122;
                    case 123 -> 101;
                    case 124 -> 67;
                    case 125 -> 229;
                    case 126 -> 18;
                    case 127 -> 202;
                    case 128 -> 169;
                    case 129 -> 212;
                    case 130 -> 59;
                    case 131 -> 65;
                    case 132 -> 33;
                    case 133 -> 222;
                    case 134 -> 40;
                    case 135 -> 35;
                    case 136 -> 179;
                    case 137 -> 249;
                    case 138 -> 246;
                    case 139 -> 79;
                    case 140 -> 30;
                    case 141 -> 1;
                    case 142 -> 234;
                    case 143 -> 10;
                    case 144 -> 77;
                    case 145 -> 71;
                    case 146 -> 199;
                    case 147 -> 53;
                    case 148 -> 2;
                    case 149 -> 180;
                    case 150 -> 157;
                    case 151 -> 14;
                    case 152 -> 206;
                    case 153 -> 11;
                    case 154 -> 96;
                    case 155 -> 142;
                    case 156 -> 156;
                    case 157 -> 138;
                    case 158 -> 108;
                    case 159 -> 175;
                    case 160 -> 56;
                    case 161 -> 130;
                    case 162 -> 155;
                    case 163 -> 13;
                    case 164 -> 15;
                    case 165 -> 247;
                    case 166 -> 147;
                    case 167 -> 191;
                    case 168 -> 161;
                    case 169 -> 232;
                    case 170 -> 165;
                    case 171 -> 25;
                    case 172 -> 119;
                    case 173 -> 213;
                    case 174 -> 58;
                    case 175 -> 113;
                    case 176 -> 233;
                    case 177 -> 8;
                    case 178 -> 178;
                    case 179 -> 91;
                    case 180 -> 5;
                    case 181 -> 174;
                    case 182 -> 81;
                    case 183 -> 210;
                    case 184 -> 39;
                    case 185 -> 255;
                    case 186 -> 166;
                    case 187 -> 193;
                    case 188 -> 173;
                    case 189 -> 127;
                    case 190 -> 36;
                    case 191 -> 120;
                    case 192 -> 140;
                    case 193 -> 55;
                    case 194 -> 100;
                    case 195 -> 238;
                    case 196 -> 200;
                    case 197 -> 224;
                    case 198 -> 103;
                    case 199 -> 37;
                    case 200 -> 115;
                    case 201 -> 29;
                    case 202 -> 27;
                    case 203 -> 24;
                    case 204 -> 76;
                    case 205 -> 218;
                    case 206 -> 251;
                    case 207 -> 99;
                    case 208 -> 45;
                    case 209 -> 241;
                    case 210 -> 38;
                    case 211 -> 98;
                    case 212 -> 3;
                    case 213 -> 184;
                    case 214 -> 42;
                    case 215 -> 51;
                    case 216 -> 57;
                    case 217 -> 185;
                    case 218 -> 72;
                    case 219 -> 19;
                    case 220 -> 4;
                    case 221 -> 227;
                    case 222 -> 125;
                    case 223 -> 48;
                    case 224 -> 216;
                    case 225 -> 104;
                    case 226 -> 252;
                    case 227 -> 181;
                    case 228 -> 63;
                    case 229 -> 221;
                    case 230 -> 34;
                    case 231 -> 54;
                    case 232 -> 152;
                    case 233 -> 205;
                    case 234 -> 89;
                    case 235 -> 228;
                    case 236 -> 189;
                    case 237 -> 244;
                    case 238 -> 144;
                    case 239 -> 220;
                    case 240 -> 208;
                    case 241 -> 129;
                    case 242 -> 84;
                    case 243 -> 253;
                    case 244 -> 145;
                    case 245 -> 133;
                    case 246 -> 23;
                    case 247 -> 139;
                    case 248 -> 158;
                    case 249 -> 235;
                    case 250 -> 128;
                    case 251 -> 171;
                    case 252 -> 17;
                    case 253 -> 164;
                    case 254 -> 68;
                    default -> 203;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

