/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007J\u001c\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeometryUtil;", "", "()V", "changeHeight", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "r", "height", "", "changeHeightKeepBottom", "changeWidth", "width", "changeWidthKeepRight", "union", "head", "c", "", "first", "optionalSecond", "plot-builder"})
public final class GeometryUtil {
    @NotNull
    public static final GeometryUtil INSTANCE = new GeometryUtil();

    private GeometryUtil() {
    }

    @NotNull
    public final DoubleRectangle union(@NotNull DoubleRectangle first, @Nullable DoubleRectangle optionalSecond) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        return optionalSecond == null ? first : first.union(optionalSecond);
    }

    @NotNull
    public final DoubleRectangle union(@NotNull DoubleRectangle head, @NotNull Collection<DoubleRectangle> c) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        DoubleRectangle result2 = head;
        for (DoubleRectangle r : c) {
            result2 = result2.union(r);
        }
        return result2;
    }

    @NotNull
    public final DoubleRectangle changeWidth(@NotNull DoubleRectangle r, double width2) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new DoubleRectangle(r.getOrigin().getX(), r.getOrigin().getY(), width2, r.getDimension().getY());
    }

    @NotNull
    public final DoubleRectangle changeWidthKeepRight(@NotNull DoubleRectangle r, double width2) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new DoubleRectangle(r.getRight() - width2, r.getOrigin().getY(), width2, r.getDimension().getY());
    }

    @NotNull
    public final DoubleRectangle changeHeight(@NotNull DoubleRectangle r, double height) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new DoubleRectangle(r.getOrigin().getX(), r.getOrigin().getY(), r.getDimension().getX(), height);
    }

    @NotNull
    public final DoubleRectangle changeHeightKeepBottom(@NotNull DoubleRectangle r, double height) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new DoubleRectangle(r.getOrigin().getX(), r.getBottom() - height, r.getDimension().getX(), height);
    }
}

