/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.PointLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.PointRangeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.CompositeLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.VLineLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShapeSvg;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J&\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PointRangeGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "fattenMidPoint", "", "getFattenMidPoint", "()D", "setFattenMidPoint", "(D)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "fatten", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPointRangeGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointRangeGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PointRangeGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1855#2,2:113\n1#3:115\n*S KotlinDebug\n*F\n+ 1 PointRangeGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PointRangeGeom\n*L\n77#1:113,2\n*E\n"})
public final class PointRangeGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fattenMidPoint = 5.0;
    public static final boolean HANDLES_GROUPS = false;
    public static final double DEF_FATTEN = 5.0;

    public final double getFattenMidPoint() {
        return this.fattenMidPoint;
    }

    public final void setFattenMidPoint(double d) {
        this.fattenMidPoint = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        LegendKeyElementFactory[] legendKeyElementFactoryArray = new LegendKeyElementFactory[]{new VLineLegendKeyElementFactory(), new PointLegendKeyElementFactory(5.0)};
        return new CompositeLegendKeyElementFactory(legendKeyElementFactoryArray);
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper helper2 = geomHelper.createSvgElementHelper();
        helper2.setStrokeAlphaEnabled(true);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.POINT_RANGE, ctx2);
        Aes[] aesArray = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getYMAX()};
        RectangleTooltipHelper tooltipHelper2 = new RectangleTooltipHelper(pos, coord, ctx2, CollectionsKt.listOf((Object[])aesArray), null, buildIntern.tooltipHelper.1.INSTANCE, colorsByDataPoint, 16, null);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            DoubleVector location2;
            PointShape shape;
            Double d = p.finiteOrNull(Aes.Companion.getX());
            if (d == null) {
                continue;
            }
            double x2 = d;
            Double d2 = p.finiteOrNull(Aes.Companion.getYMIN());
            if (d2 == null) {
                continue;
            }
            double ymin = d2;
            Double d3 = p.finiteOrNull(Aes.Companion.getYMAX());
            if (d3 == null) {
                continue;
            }
            double ymax = d3;
            if (p.shape() == null) continue;
            DoubleVector start2 = new DoubleVector(x2, ymin);
            DoubleVector end = new DoubleVector(x2, ymax);
            Pair<SvgNode, List<DoubleVector>> pair2 = helper2.createLine(start2, end, p, (Function1<? super DataPointAesthetics, Double>)((Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AesScaling)this.receiver).lineWidth(p0);
                }
            }));
            if (pair2 == null) continue;
            SvgNode svg = (SvgNode)pair2.component1();
            root.add(svg);
            Double d4 = p.finiteOrNull(Aes.Companion.getY());
            if (d4 == null) {
                continue;
            }
            double y2 = d4;
            Intrinsics.checkNotNull((Object)geomHelper.toClient(new DoubleVector(x2, y2), p));
            SvgSlimObject o = PointShapeSvg.create$default(PointShapeSvg.INSTANCE, shape, location2, p, this.fattenMidPoint, false, 16, null);
            root.add(GeomBase.Companion.wrap(o));
        }
        Iterable<DataPointAesthetics> $this$forEach$iv = aesthetics2.dataPoints();
        boolean $i$f$forEach = false;
        Iterator<DataPointAesthetics> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            DoubleRectangle clientRect;
            DataPointAesthetics element$iv;
            DataPointAesthetics p = element$iv = iterator2.next();
            boolean bl = false;
            if ((DoubleRectangle)this.clientRectByDataPoint(geomHelper, this.fattenMidPoint).invoke((Object)p) == null) continue;
            boolean bl2 = false;
            SvgRectElement svgRect = new SvgRectElement(clientRect);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, svgRect, p, false, null, false, 28, null);
            tooltipHelper2.addTarget(p, clientRect);
        }
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomHelper geomHelper, double fatten) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(fatten, geomHelper){
            final /* synthetic */ double $fatten;
            final /* synthetic */ GeomHelper $geomHelper;
            {
                this.$fatten = $fatten;
                this.$geomHelper = $geomHelper;
                super(1, Intrinsics.Kotlin.class, "factory", "clientRectByDataPoint$factory(DLorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return PointRangeGeom.access$clientRectByDataPoint$factory(this.$fatten, this.$geomHelper, p0);
            }
        };
    }

    private static final DoubleRectangle clientRectByDataPoint$factory(double $fatten, GeomHelper $geomHelper, DataPointAesthetics p) {
        Double d = p.finiteOrNull(Aes.Companion.getX());
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(Aes.Companion.getY());
        if (d2 == null) {
            return null;
        }
        double y2 = d2;
        PointShape pointShape = p.shape();
        if (pointShape == null) {
            return null;
        }
        PointShape shape = pointShape;
        DoubleRectangle it = new DoubleRectangle(new DoubleVector(x2, y2), DoubleVector.Companion.getZERO());
        boolean bl = false;
        DoubleRectangle doubleRectangle = $geomHelper.toClient(it, p);
        Intrinsics.checkNotNull((Object)doubleRectangle);
        DoubleRectangle rect2 = doubleRectangle;
        double shapeSize = shape.size(p, $fatten);
        double strokeWidth = shape.strokeWidth(p);
        double width2 = shapeSize + strokeWidth;
        return GeomUtil.INSTANCE.extendWidth$plot_base(rect2, width2, $geomHelper.getCtx$plot_base().getFlipped());
    }

    public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(double $fatten, GeomHelper $geomHelper, DataPointAesthetics p) {
        return PointRangeGeom.clientRectByDataPoint$factory($fatten, $geomHelper, p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PointRangeGeom$Companion;", "", "()V", "DEF_FATTEN", "", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

