/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.unreal.actions.templates;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.AddUnrealClassInfo;
import com.jetbrains.rd.ide.model.AddUnrealInfoResult;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rider.cpp.actions.RiderCppActionsBundle;
import com.jetbrains.rider.cpp.fileType.json.unrealEngine.UnrealProjectModelFilesSniffer;
import com.jetbrains.rider.cpp.unreal.UnrealHost;
import com.jetbrains.rider.cpp.unreal.actions.templates.NewUnrealActionBase;
import com.jetbrains.rider.cpp.unreal.actions.templates.NewUnrealClassActionDialog;
import com.jetbrains.rider.document.RiderReloadVetoer;
import com.jetbrains.rider.model.RdFileTemplate;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.actions.newFile.RiderNewFileCustomAction;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0001.B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$JN\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00192\u000e\u0010'\u001a\n\u0018\u00010(j\u0004\u0018\u0001`)2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/cpp/unreal/actions/templates/NewUnrealClassAction;", "Lcom/jetbrains/rider/cpp/unreal/actions/templates/NewUnrealActionBase;", "Lcom/jetbrains/rider/projectView/actions/newFile/RiderNewFileCustomAction;", "<init>", "()V", "isEnabledInRegistry", "", "templates", "", "Lcom/jetbrains/rider/model/RdFileTemplate;", "getTemplates", "()Ljava/util/List;", "isEnabled", "()Z", "allowInvokeOnProjectFiles", "getAllowInvokeOnProjectFiles", "prepareTemplates", "", "", "execute", "Ljava/io/File;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "template", "itemName", "", "checkEntity", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "project", "Lcom/intellij/openapi/project/Project;", "actionPerformedInternal", "getLocationData", "Lcom/jetbrains/rider/cpp/unreal/actions/templates/NewUnrealClassAction$UnrealClassLocationData;", "className", "path", "Ljava/nio/file/Path;", "moduleRoot", "baseClass", "guid", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "headerPath", "sourcePath", "isCommon", "showError", "UnrealClassLocationData", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nNewUnrealClassAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewUnrealClassAction.kt\ncom/jetbrains/rider/cpp/unreal/actions/templates/NewUnrealClassAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1563#2:131\n1634#2,3:132\n295#2,2:135\n1761#2,3:137\n*S KotlinDebug\n*F\n+ 1 NewUnrealClassAction.kt\ncom/jetbrains/rider/cpp/unreal/actions/templates/NewUnrealClassAction\n*L\n50#1:131\n50#1:132,3\n51#1:135,2\n78#1:137,3\n*E\n"})
public final class NewUnrealClassAction
extends NewUnrealActionBase
implements RiderNewFileCustomAction {
    private final boolean isEnabledInRegistry = Registry.Companion.is("rider.cpp.enable.new.unreal.class", true);
    @NotNull
    private final List<RdFileTemplate> templates = new ArrayList();
    private final boolean isEnabled = this.isEnabledInRegistry;
    private final boolean allowInvokeOnProjectFiles;

    @NotNull
    public List<RdFileTemplate> getTemplates() {
        return this.templates;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    protected boolean getAllowInvokeOnProjectFiles() {
        return this.allowInvokeOnProjectFiles;
    }

    public void prepareTemplates(@NotNull List<RdFileTemplate> templates) {
        Intrinsics.checkNotNullParameter(templates, (String)"templates");
        this.getTemplates().addAll((Collection<RdFileTemplate>)templates);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public File execute(@NotNull DataContext dataContext, @NotNull RdFileTemplate template, @NotNull String itemName) {
        Object v4;
        Path directoryPath;
        Project project;
        block2: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
            Project project2 = project = DataContextKt.getProject((DataContext)dataContext);
            Intrinsics.checkNotNull((Object)project2);
            ProjectModelEntity projectModelEntity = this.getItem(dataContext, project2, true);
            Intrinsics.checkNotNull((Object)projectModelEntity);
            ProjectModelEntity entity = projectModelEntity;
            VirtualFileUrl virtualFileUrl = entity.getUrl();
            Intrinsics.checkNotNull((Object)virtualFileUrl);
            VirtualFile virtualFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl);
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile entityPath = virtualFile;
            Path path = !entityPath.isDirectory() ? entityPath.getParent().toNioPath() : entityPath.toNioPath();
            Intrinsics.checkNotNull((Object)path);
            directoryPath = path;
            UnrealProjectModelFilesSniffer unrealFilesSniffer = UnrealProjectModelFilesSniffer.Companion.getInstance(project);
            Iterable $this$map$iv = unrealFilesSniffer.getModulesSnapshot();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getParent().toNioPath());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!directoryPath.startsWith(it)) continue;
                v4 = element$iv;
                break block2;
            }
            v4 = null;
        }
        Intrinsics.checkNotNull(v4);
        Path moduleRoot = v4;
        UnrealClassLocationData locationData = this.getLocationData(itemName, directoryPath, moduleRoot);
        return this.execute(project, itemName, template.getName(), null, locationData.getHeaderPath(), locationData.getSourcePath(), true, false);
    }

    @Override
    protected boolean checkEntity(@NotNull ProjectModelEntity entity, @NotNull Project project) {
        boolean bl;
        Path path;
        block9: {
            VirtualFile entityFile;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!this.isEnabledInRegistry) {
                return false;
            }
            VirtualFileUrl virtualFileUrl = entity.getUrl();
            Object object = entityFile = virtualFileUrl != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl) : null;
            if (entityFile == null || ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)entity, (Project)project) == null) {
                return false;
            }
            ProjectModelEntity parentEntity = entity.getParentEntity();
            List unrealNewActionMode = ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)entity) && parentEntity != null ? ProjectModelNodeExtensionKt.getUnrealNewActionMode((RdProjectModelItemDescriptor)parentEntity.getDescriptor()) : ProjectModelNodeExtensionKt.getUnrealNewActionMode((RdProjectModelItemDescriptor)entity.getDescriptor());
            if (NewUnrealActionBase.getLOG().isDebugEnabled()) {
                NewUnrealActionBase.getLOG().debug("Checking " + entity + " UnrealNewActionMode: " + CollectionsKt.joinToString$default((Iterable)unrealNewActionMode, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
            if (!unrealNewActionMode.contains("Class")) {
                return false;
            }
            Path path2 = entityFile.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
            path = path2;
            UnrealProjectModelFilesSniffer unrealFilesSniffer = UnrealProjectModelFilesSniffer.Companion.getInstance(project);
            if (NewUnrealActionBase.getLOG().isDebugEnabled()) {
                NewUnrealActionBase.getLOG().debug("Checking '" + path + "' modulesSnapshot.count: " + ((Collection)unrealFilesSniffer.getModulesSnapshot()).size());
            }
            Iterable $this$any$iv = unrealFilesSniffer.getModulesSnapshot();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!path.startsWith(it.getParent().toNioPath())) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean hasModule = bl;
        if (NewUnrealActionBase.getLOG().isDebugEnabled()) {
            NewUnrealActionBase.getLOG().debug("HasModule " + hasModule + " for " + path);
        }
        return hasModule;
    }

    @Override
    protected void actionPerformedInternal(@NotNull Project project, @NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NewUnrealClassActionDialog.Companion.show(project, entity, this);
    }

    @NotNull
    public final UnrealClassLocationData getLocationData(@NotNull String className, @NotNull Path path, @NotNull Path moduleRoot) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)moduleRoot, (String)"moduleRoot");
        Path publicFolder = moduleRoot.resolve("Public");
        Path privateFolder = moduleRoot.resolve("Private");
        Path headerPath = path.resolve(className + ".h");
        if (!path.startsWith(publicFolder)) {
            path2 = path.resolve(className + ".cpp");
        } else {
            Intrinsics.checkNotNull((Object)publicFolder);
            Path innerFolder = PathsKt.relativeTo((Path)path, (Path)publicFolder);
            path2 = privateFolder.resolve(innerFolder).resolve(className + ".cpp");
        }
        Path sourcePath = path2;
        Intrinsics.checkNotNull((Object)publicFolder);
        Intrinsics.checkNotNull((Object)privateFolder);
        Intrinsics.checkNotNull((Object)headerPath);
        Intrinsics.checkNotNull((Object)sourcePath);
        return new UnrealClassLocationData(publicFolder, privateFolder, headerPath, sourcePath);
    }

    @NotNull
    public final File execute(@NotNull Project project, @NotNull String className, @NotNull String baseClass, @Nullable UUID guid, @NotNull Path headerPath, @NotNull Path sourcePath, boolean isCommon, boolean showError) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)baseClass, (String)"baseClass");
        Intrinsics.checkNotNullParameter((Object)headerPath, (String)"headerPath");
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        AddUnrealClassInfo addClassInfo = new AddUnrealClassInfo(className, baseClass, guid, isCommon, ((Object)headerPath).toString(), ((Object)sourcePath).toString());
        RiderReloadVetoer.Companion.runWithReloadSuppress(((Object)headerPath).toString(), () -> NewUnrealClassAction.execute$lambda$2(project, addClassInfo, showError, className));
        File file = headerPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    private static final Unit execute$lambda$2(Project $project, AddUnrealClassInfo $addClassInfo, boolean $showError, String $className) {
        AddUnrealInfoResult addUnrealInfoResult = (AddUnrealInfoResult)ExtensionsKt.runCommandUnderProgress$default((IRdCall)((IRdCall)UnrealHost.Companion.getInstance($project).getModel().getAddClass()), (Object)$addClassInfo, (Project)$project, (String)RiderCppActionsBundle.Companion.message("action.NewUnrealClassAction.task.name", new Object[0]), (boolean)false, (boolean)false, (boolean)false, (int)56, null);
        if (addUnrealInfoResult == null) {
            return Unit.INSTANCE;
        }
        AddUnrealInfoResult result2 = addUnrealInfoResult;
        if (!result2.isSucceeded() && $showError) {
            ApplicationKt.getApplication().invokeLater(() -> NewUnrealClassAction.execute$lambda$2$0($project, result2, $className));
        }
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$2$0(Project $project, AddUnrealInfoResult $result, String $className) {
        Object[] objectArray = new Object[]{$className};
        Messages.showErrorDialog((Project)$project, (String)$result.getErrorsDescription()[0], (String)RiderCppActionsBundle.Companion.message("action.NewUnrealClassAction.dialog.classCreationError", objectArray));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/cpp/unreal/actions/templates/NewUnrealClassAction$UnrealClassLocationData;", "", "publicFolder", "Ljava/nio/file/Path;", "privateFolder", "headerPath", "sourcePath", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getPublicFolder", "()Ljava/nio/file/Path;", "getPrivateFolder", "getHeaderPath", "getSourcePath", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rider.plugins.cpp"})
    public static final class UnrealClassLocationData {
        @NotNull
        private final Path publicFolder;
        @NotNull
        private final Path privateFolder;
        @NotNull
        private final Path headerPath;
        @NotNull
        private final Path sourcePath;

        public UnrealClassLocationData(@NotNull Path publicFolder, @NotNull Path privateFolder, @NotNull Path headerPath, @NotNull Path sourcePath) {
            Intrinsics.checkNotNullParameter((Object)publicFolder, (String)"publicFolder");
            Intrinsics.checkNotNullParameter((Object)privateFolder, (String)"privateFolder");
            Intrinsics.checkNotNullParameter((Object)headerPath, (String)"headerPath");
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            this.publicFolder = publicFolder;
            this.privateFolder = privateFolder;
            this.headerPath = headerPath;
            this.sourcePath = sourcePath;
        }

        @NotNull
        public final Path getPublicFolder() {
            return this.publicFolder;
        }

        @NotNull
        public final Path getPrivateFolder() {
            return this.privateFolder;
        }

        @NotNull
        public final Path getHeaderPath() {
            return this.headerPath;
        }

        @NotNull
        public final Path getSourcePath() {
            return this.sourcePath;
        }

        @NotNull
        public final Path component1() {
            return this.publicFolder;
        }

        @NotNull
        public final Path component2() {
            return this.privateFolder;
        }

        @NotNull
        public final Path component3() {
            return this.headerPath;
        }

        @NotNull
        public final Path component4() {
            return this.sourcePath;
        }

        @NotNull
        public final UnrealClassLocationData copy(@NotNull Path publicFolder, @NotNull Path privateFolder, @NotNull Path headerPath, @NotNull Path sourcePath) {
            Intrinsics.checkNotNullParameter((Object)publicFolder, (String)"publicFolder");
            Intrinsics.checkNotNullParameter((Object)privateFolder, (String)"privateFolder");
            Intrinsics.checkNotNullParameter((Object)headerPath, (String)"headerPath");
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            return new UnrealClassLocationData(publicFolder, privateFolder, headerPath, sourcePath);
        }

        public static /* synthetic */ UnrealClassLocationData copy$default(UnrealClassLocationData unrealClassLocationData, Path path, Path path2, Path path3, Path path4, int n, Object object) {
            if ((n & 1) != 0) {
                path = unrealClassLocationData.publicFolder;
            }
            if ((n & 2) != 0) {
                path2 = unrealClassLocationData.privateFolder;
            }
            if ((n & 4) != 0) {
                path3 = unrealClassLocationData.headerPath;
            }
            if ((n & 8) != 0) {
                path4 = unrealClassLocationData.sourcePath;
            }
            return unrealClassLocationData.copy(path, path2, path3, path4);
        }

        @NotNull
        public String toString() {
            return "UnrealClassLocationData(publicFolder=" + this.publicFolder + ", privateFolder=" + this.privateFolder + ", headerPath=" + this.headerPath + ", sourcePath=" + this.sourcePath + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.publicFolder).hashCode();
            result2 = result2 * 31 + ((Object)this.privateFolder).hashCode();
            result2 = result2 * 31 + ((Object)this.headerPath).hashCode();
            result2 = result2 * 31 + ((Object)this.sourcePath).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnrealClassLocationData)) {
                return false;
            }
            UnrealClassLocationData unrealClassLocationData = (UnrealClassLocationData)other;
            if (!Intrinsics.areEqual((Object)this.publicFolder, (Object)unrealClassLocationData.publicFolder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.privateFolder, (Object)unrealClassLocationData.privateFolder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headerPath, (Object)unrealClassLocationData.headerPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sourcePath, (Object)unrealClassLocationData.sourcePath);
        }
    }
}

