/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.unreal.access;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.UnrealModel;
import com.jetbrains.rider.cpp.RiderCppBundle;
import com.jetbrains.rider.cpp.unreal.UnrealHost;
import com.jetbrains.rider.editorActions.RiderWritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/cpp/unreal/access/UnrealEngineWritingAccessManager;", "Lcom/jetbrains/rider/editorActions/RiderWritingAccessProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "doIsPotentiallyWritable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doRequestWriting", "", "files", "getReadOnlyMessage", "", "notifyAboutEngineSettings", "", "isReadonlyModeDisabled", "createAllowTypingDialog", "Lcom/intellij/openapi/ui/MessageDialogBuilder$YesNo;", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nUnrealEngineWritingAccessManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealEngineWritingAccessManager.kt\ncom/jetbrains/rider/cpp/unreal/access/UnrealEngineWritingAccessManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n774#2:104\n865#2,2:105\n*S KotlinDebug\n*F\n+ 1 UnrealEngineWritingAccessManager.kt\ncom/jetbrains/rider/cpp/unreal/access/UnrealEngineWritingAccessManager\n*L\n30#1:104\n30#1:105,2\n*E\n"})
public final class UnrealEngineWritingAccessManager
extends RiderWritingAccessProvider {
    @NotNull
    private final Project project;

    public UnrealEngineWritingAccessManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected boolean doIsPotentiallyWritable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Collection<VirtualFile> doRequestWriting(@NotNull Collection<? extends VirtualFile> files2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        UnrealHost unrealHost = UnrealHost.Companion.getInstance(this.project);
        if (!unrealHost.isUnrealProjectOrSolution()) {
            return CollectionsKt.emptyList();
        }
        boolean areEngineFilesLocked = AdvancedSettings.Companion.getBoolean("unreal.engine.read.only");
        if (!areEngineFilesLocked) {
            return CollectionsKt.emptyList();
        }
        UnrealModel model = unrealHost.getModel();
        String string = (String)model.getUnrealEngineLocation().getValueOrNull();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String engineRoot = string;
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            String string2 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            if (!StringsKt.startsWith((String)string2, (String)engineRoot, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List engineFiles = (List)destination$iv$iv;
        if (engineFiles.isEmpty()) {
            return engineFiles;
        }
        boolean isDoNotAsk = AdvancedSettings.Companion.getBoolean("unreal.engine.read.only.do.not.ask");
        if (isDoNotAsk) {
            return engineFiles;
        }
        boolean result2 = this.createAllowTypingDialog().ask(this.project);
        if (result2 || AdvancedSettings.Companion.getBoolean("unreal.engine.read.only.do.not.ask")) {
            this.notifyAboutEngineSettings(result2);
        }
        if (result2) {
            AdvancedSettings.Companion.setBoolean("unreal.engine.read.only", false);
            return CollectionsKt.emptyList();
        }
        return engineFiles;
    }

    @NotNull
    public String getReadOnlyMessage() {
        return RiderCppBundle.Companion.message("UnrealEngineWritingAccessManager.file.locked", new Object[0]);
    }

    private final void notifyAboutEngineSettings(boolean isReadonlyModeDisabled) {
        Notification notification2;
        Notification it = notification2 = new Notification("Unreal Engine read-only mode", RiderCppBundle.Companion.message("UnrealEngineWritingAccessManager.notification.readonly.mode.title", new Object[0]), isReadonlyModeDisabled ? RiderCppBundle.Companion.message("UnrealEngineWritingAccessManager.notification.readonly.mode.disabled.content", new Object[0]) : RiderCppBundle.Companion.message("UnrealEngineWritingAccessManager.notification.readonly.mode.dont.ask.content", new Object[0]), NotificationType.INFORMATION);
        boolean bl = false;
        Notification notification3 = isReadonlyModeDisabled ? it.addAction((AnAction)NotificationAction.create((String)RiderCppBundle.Companion.message("UnrealEngineWritingAccessManager.enable.readonly.mode", new Object[0]), (arg_0, arg_1) -> UnrealEngineWritingAccessManager.notifyAboutEngineSettings$lambda$0$1(UnrealEngineWritingAccessManager::notifyAboutEngineSettings$lambda$0$0, arg_0, arg_1))) : it.addAction((AnAction)NotificationAction.create((String)RiderCppBundle.Companion.message("UnrealEngineWritingAccessManager.show.readonly.mode.settings", new Object[0]), (arg_0, arg_1) -> UnrealEngineWritingAccessManager.notifyAboutEngineSettings$lambda$0$3((arg_0, arg_1) -> UnrealEngineWritingAccessManager.notifyAboutEngineSettings$lambda$0$2(this, arg_0, arg_1), arg_0, arg_1)));
        Notification notification4 = notification2;
        notification4.notify(this.project);
    }

    private final MessageDialogBuilder.YesNo createAllowTypingDialog() {
        return (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(RiderCppBundle.Companion.message("UnrealEngineWritingAccessManager.allow.typing.dialog.title", new Object[0]), RiderCppBundle.Companion.message("UnrealEngineWritingAccessManager.allow.typing.dialog.description", new Object[0])).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

            public boolean isSelectedByDefault() {
                return false;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                AdvancedSettings.Companion.setBoolean("unreal.engine.read.only.do.not.ask", isSelected);
            }
        });
    }

    private static final Unit notifyAboutEngineSettings$lambda$0$0(AnActionEvent anActionEvent, Notification notif) {
        AdvancedSettings.Companion.setBoolean("unreal.engine.read.only", true);
        notif.expire();
        return Unit.INSTANCE;
    }

    private static final void notifyAboutEngineSettings$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit notifyAboutEngineSettings$lambda$0$2(UnrealEngineWritingAccessManager this$0, AnActionEvent anActionEvent, Notification notification2) {
        ShowSettingsUtilImpl.Companion.showSettingsDialog(this$0.project, "advanced.settings", RiderCppBundle.Companion.message("advanced.setting.unreal.engine.read.only", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final void notifyAboutEngineSettings$lambda$0$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

