/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.scopes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.cpp.scopes.UnrealFindPopupProjectScopeProvider;
import com.jetbrains.rider.cpp.unreal.UnrealHost;
import com.jetbrains.rider.ideaInterop.find.FindPopupProjectScopeProvider;
import com.jetbrains.rider.ideaInterop.find.ProjectScopeModel;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import icons.ReSharperIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u001a\u001b\u001c\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002J:\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u000b\u0010\u0006\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\r\u0010\u0017\u001a\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u0016H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider;", "Lcom/jetbrains/rider/ideaInterop/find/FindPopupProjectScopeProvider;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "createModel", "", "Lcom/jetbrains/rider/ideaInterop/find/ProjectScopeModel;", "collectPluginsAndModules", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "container", "Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$Container;", "collectProjects", "result", "", "createModels", "", "Lcom/intellij/openapi/util/NlsSafe;", "plugin", "createRenderer", "Ljavax/swing/ListCellRenderer;", "UnrealEntityProjectScopeModel", "Container", "ProjectContainer", "PluginContainer", "ModuleContainer", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nUnrealFindPopupProjectScopeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealFindPopupProjectScopeProvider.kt\ncom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n13#2:170\n1056#3:171\n1056#3:172\n1056#3:173\n1056#3:174\n1#4:175\n*S KotlinDebug\n*F\n+ 1 UnrealFindPopupProjectScopeProvider.kt\ncom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider\n*L\n50#1:170\n57#1:171\n63#1:172\n69#1:173\n72#1:174\n*E\n"})
public final class UnrealFindPopupProjectScopeProvider
implements FindPopupProjectScopeProvider {
    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return UnrealHost.Companion.isUnrealProject(project);
    }

    @NotNull
    public List<ProjectScopeModel> createModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!UnrealHost.Companion.isUnrealProject(project)) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(project));
        if (projectModelEntity == null) {
            return CollectionsKt.emptyList();
        }
        ProjectModelEntity solutionEntity = projectModelEntity;
        List gameContainers = new ArrayList();
        List engineContainers = new ArrayList();
        List programFolders = new ArrayList();
        for (ProjectModelEntity entity : solutionEntity.getChildrenEntities()) {
            String string = ProjectModelNodeExtensionKt.getUnrealProjectMark((RdProjectModelItemDescriptor)entity.getDescriptor());
            if (Intrinsics.areEqual((Object)string, (Object)"UnrealGameProjectMark")) {
                ProjectContainer container = new ProjectContainer(entity);
                gameContainers.add(container);
                this.collectPluginsAndModules(entity, container);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"UnrealEngineProjectMark")) {
                ProjectContainer container = new ProjectContainer(entity);
                engineContainers.add(container);
                this.collectPluginsAndModules(entity, container);
                continue;
            }
            if (ProjectModelEntityExtensionsKt.isSolutionFolder((ProjectModelEntity)entity)) {
                programFolders.add(entity);
                continue;
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(UnrealFindPopupProjectScopeProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unknown project on top level: " + entity.getName());
        }
        Iterable $this$sortedBy$iv = gameContainers;
        boolean $i$f$sortedBy = false;
        for (ProjectContainer gameContainer : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProjectContainer it = (ProjectContainer)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getEntity().getName());
                it = (ProjectContainer)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getEntity().getName())));
            }
        })) {
            result2.add(new UnrealEntityProjectScopeModel(gameContainer.getEntity(), null, 2, null));
            this.createModels(gameContainer, result2, gameContainer.getEntity().getName(), null);
        }
        $this$sortedBy$iv = engineContainers;
        $i$f$sortedBy = false;
        for (ProjectContainer engineContainer : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProjectContainer it = (ProjectContainer)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getEntity().getName());
                it = (ProjectContainer)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getEntity().getName())));
            }
        })) {
            result2.add(new UnrealEntityProjectScopeModel(engineContainer.getEntity(), null, 2, null));
            this.createModels(engineContainer, result2, engineContainer.getEntity().getName(), null);
        }
        $this$sortedBy$iv = programFolders;
        $i$f$sortedBy = false;
        for (ProjectModelEntity programFolder : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProjectModelEntity it = (ProjectModelEntity)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ProjectModelEntity)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })) {
            List projects = new ArrayList();
            this.collectProjects(programFolder, projects);
            Iterable $this$sortedBy$iv2 = projects;
            boolean $i$f$sortedBy2 = false;
            for (ProjectModelEntity projectEntity : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ProjectModelEntity it = (ProjectModelEntity)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ProjectModelEntity)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            })) {
                result2.add(new UnrealEntityProjectScopeModel(projectEntity, programFolder.getName() + " / "));
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void collectPluginsAndModules(ProjectModelEntity entity, Container container) {
        for (ProjectModelEntity childEntity : entity.getChildrenEntities()) {
            Unit unit;
            Container $this$collectPluginsAndModules_u24lambda_u240;
            UnrealFindPopupProjectScopeProvider unrealFindPopupProjectScopeProvider;
            ProjectModelEntity projectModelEntity;
            Container container2;
            if (!ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)childEntity) && !ProjectModelEntityExtensionsKt.isSolutionFolder((ProjectModelEntity)childEntity)) continue;
            String string = ProjectModelNodeExtensionKt.getUnrealProjectMark((RdProjectModelItemDescriptor)childEntity.getDescriptor());
            if (Intrinsics.areEqual((Object)string, (Object)"UnrealPluginProjectMark")) {
                PluginContainer pluginContainer = container2 = new PluginContainer(childEntity);
                projectModelEntity = childEntity;
                unrealFindPopupProjectScopeProvider = this;
                boolean bl = false;
                container.getChildren().add($this$collectPluginsAndModules_u24lambda_u240);
                unit = Unit.INSTANCE;
                unrealFindPopupProjectScopeProvider.collectPluginsAndModules(projectModelEntity, container2);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"UnrealModuleProjectMark")) {
                void $this$collectPluginsAndModules_u24lambda_u241;
                $this$collectPluginsAndModules_u24lambda_u240 = container2 = new ModuleContainer(childEntity);
                projectModelEntity = childEntity;
                unrealFindPopupProjectScopeProvider = this;
                boolean bl = false;
                container.getChildren().add((Container)$this$collectPluginsAndModules_u24lambda_u241);
                unit = Unit.INSTANCE;
                unrealFindPopupProjectScopeProvider.collectPluginsAndModules(projectModelEntity, container2);
                continue;
            }
            this.collectPluginsAndModules(childEntity, container);
        }
    }

    private final void collectProjects(ProjectModelEntity entity, List<ProjectModelEntity> result2) {
        if (ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)entity)) {
            result2.add(entity);
        }
        if (ProjectModelEntityExtensionsKt.isSolutionFolder((ProjectModelEntity)entity)) {
            for (ProjectModelEntity child : entity.getChildrenEntities()) {
                this.collectProjects(child, result2);
            }
        }
    }

    private final void createModels(Container container, List<ProjectScopeModel> result2, String project, String plugin) {
        Function1[] function1Array = new Function1[]{UnrealFindPopupProjectScopeProvider::createModels$lambda$0, UnrealFindPopupProjectScopeProvider::createModels$lambda$1};
        for (Container child : CollectionsKt.sortedWith((Iterable)container.getChildren(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array))) {
            String description;
            if (child instanceof PluginContainer) {
                description = project + " / ";
                result2.add(new UnrealEntityProjectScopeModel(child.getEntity(), description));
                this.createModels(child, result2, project, child.getEntity().getName());
            }
            if (!(child instanceof ModuleContainer)) continue;
            String string = plugin;
            description = string != null ? project + " / " + string + " / " : project + " / ";
            result2.add(new UnrealEntityProjectScopeModel(child.getEntity(), description));
            this.createModels(child, result2, project, plugin);
        }
    }

    @NotNull
    public ListCellRenderer<ProjectScopeModel> createRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ListCellRenderer<ProjectScopeModel>(project){
            private final JLabel emptyLabel;
            private final JLabel iconLabel;
            private final JLabel pathLabel;
            private final JLabel nameLabel;
            private final JPanel panel;
            final /* synthetic */ Project $project;
            {
                void $this$panel_u24lambda_u242;
                JComponent $this$pathLabel_u24lambda_u241;
                JLabel $this$iconLabel_u24lambda_u240;
                JComponent jComponent;
                this.$project = $project;
                this.emptyLabel = new JLabel(RiderBundle.message((String)"label.none", (Object[])new Object[0]), ReSharperIcons.ProjectModel.UnloadedProject, 2);
                JLabel jLabel = jComponent = new JLabel();
                createRenderer.1 var5_4 = this;
                boolean bl = false;
                $this$iconLabel_u24lambda_u240.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
                var5_4.iconLabel = jComponent;
                $this$iconLabel_u24lambda_u240 = jComponent = new JLabel();
                var5_4 = this;
                boolean bl2 = false;
                $this$pathLabel_u24lambda_u241.setForeground(JBUI.CurrentTheme.Label.disabledForeground());
                var5_4.pathLabel = jComponent;
                this.nameLabel = new JLabel();
                $this$pathLabel_u24lambda_u241 = jComponent = new JPanel((LayoutManager)new HorizontalLayout(0, 0, 2, null));
                var5_4 = this;
                boolean bl3 = false;
                $this$panel_u24lambda_u242.setOpaque(false);
                $this$panel_u24lambda_u242.add(this.iconLabel);
                $this$panel_u24lambda_u242.add(this.pathLabel);
                $this$panel_u24lambda_u242.add(this.nameLabel);
                var5_4.panel = jComponent;
            }

            public Component getListCellRendererComponent(JList<? extends ProjectScopeModel> list, ProjectScopeModel value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return this.emptyLabel;
                }
                UnrealEntityProjectScopeModel model = (UnrealEntityProjectScopeModel)value;
                ProjectModelEntityReference projectModelEntityReference = model.getReference();
                this.iconLabel.setIcon(projectModelEntityReference != null && (projectModelEntityReference = projectModelEntityReference.getEntity(this.$project)) != null ? ProjectModelIconsKt.calculateIcon((ProjectModelEntity)projectModelEntityReference, (Project)this.$project) : null);
                this.nameLabel.setText(model.getName());
                this.pathLabel.setText(model.getDescription());
                return this.panel;
            }
        };
    }

    private static final Comparable createModels$lambda$0(Container it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.valueOf(it instanceof PluginContainer);
    }

    private static final Comparable createModels$lambda$1(Container it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getEntity().getName());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$Container;", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "<init>", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "getEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "children", "", "getChildren", "()Ljava/util/List;", "intellij.rider.plugins.cpp"})
    private static abstract class Container {
        @NotNull
        private final ProjectModelEntity entity;
        @NotNull
        private final List<Container> children;

        public Container(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            this.entity = entity;
            this.children = new ArrayList();
        }

        @NotNull
        public final ProjectModelEntity getEntity() {
            return this.entity;
        }

        @NotNull
        public final List<Container> getChildren() {
            return this.children;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$ModuleContainer;", "Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$Container;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "<init>", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "intellij.rider.plugins.cpp"})
    private static final class ModuleContainer
    extends Container {
        public ModuleContainer(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super(entity);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$PluginContainer;", "Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$Container;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "<init>", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "intellij.rider.plugins.cpp"})
    private static final class PluginContainer
    extends Container {
        public PluginContainer(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super(entity);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$ProjectContainer;", "Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$Container;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "<init>", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "intellij.rider.plugins.cpp"})
    private static final class ProjectContainer
    extends Container {
        public ProjectContainer(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super(entity);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B&\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tB\"\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000f\b\u0002\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\fR\u0016\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/cpp/scopes/UnrealFindPopupProjectScopeProvider$UnrealEntityProjectScopeModel;", "Lcom/jetbrains/rider/ideaInterop/find/ProjectScopeModel;", "name", "", "pointer", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "description", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;Ljava/lang/String;)V", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "intellij.rider.plugins.cpp"})
    public static final class UnrealEntityProjectScopeModel
    extends ProjectScopeModel {
        @NotNull
        private final String description;

        private UnrealEntityProjectScopeModel(String name, ProjectModelEntityReference pointer, String description) {
            super(name, pointer);
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public UnrealEntityProjectScopeModel(@NotNull ProjectModelEntity entity, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            String string = entity.getName();
            ProjectModelEntityReference projectModelEntityReference = ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)entity);
            String string2 = description;
            if (string2 == null) {
                string2 = "";
            }
            this(string, projectModelEntityReference, string2);
        }

        public /* synthetic */ UnrealEntityProjectScopeModel(ProjectModelEntity projectModelEntity, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            this(projectModelEntity, string);
        }
    }
}

