/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.run.configurations.rdjson;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfiguration;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfigurationParameters;
import com.jetbrains.rider.cpp.run.configurations.rdjson.RdJsonConfigurationParameters;
import com.jetbrains.rider.cpp.run.configurations.rdjson.RdJsonConfigurationType;
import com.jetbrains.rider.cpp.run.configurations.rdjson.RdJsonSettingsEditorGroup;
import com.jetbrains.rider.cpp.run.configurations.rdjson.TerminalInteractionBehavior;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectKind;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.run.configurations.DotNetConfigurationFactoryBase;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\"\u0010\u0016\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J$\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/cpp/run/configurations/rdjson/RdJsonConfigurationFactory;", "Lcom/jetbrains/rider/run/configurations/DotNetConfigurationFactoryBase;", "Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfiguration;", "type", "Lcom/intellij/execution/configurations/ConfigurationType;", "defaultConfigName", "", "defaultProjectKind", "Lcom/jetbrains/rider/model/RunnableProjectKind;", "runConfigId", "defaultTerminalInteractionBehavior", "Lcom/jetbrains/rider/cpp/run/configurations/rdjson/TerminalInteractionBehavior;", "<init>", "(Lcom/intellij/execution/configurations/ConfigurationType;Ljava/lang/String;Lcom/jetbrains/rider/model/RunnableProjectKind;Ljava/lang/String;Lcom/jetbrains/rider/cpp/run/configurations/rdjson/TerminalInteractionBehavior;)V", "getSingletonPolicy", "Lcom/intellij/execution/configurations/RunConfigurationSingletonPolicy;", "createParameters", "Lcom/jetbrains/rider/cpp/run/configurations/rdjson/RdJsonConfigurationParameters;", "createConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "name", "template", "setup", "", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "getRunnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "runnableProjectsModel", "Lcom/jetbrains/rider/model/RunnableProjectsModel;", "projectFilePath", "createTemplateConfiguration", "setupDefault", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nRdJsonConfigurationFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdJsonConfigurationFactory.kt\ncom/jetbrains/rider/cpp/run/configurations/rdjson/RdJsonConfigurationFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1#2:82\n295#3,2:83\n295#3,2:85\n*S KotlinDebug\n*F\n+ 1 RdJsonConfigurationFactory.kt\ncom/jetbrains/rider/cpp/run/configurations/rdjson/RdJsonConfigurationFactory\n*L\n56#1:83,2\n74#1:85,2\n*E\n"})
public abstract class RdJsonConfigurationFactory
extends DotNetConfigurationFactoryBase<CppProjectConfiguration> {
    @NotNull
    private final String defaultConfigName;
    @NotNull
    private final RunnableProjectKind defaultProjectKind;
    @NotNull
    private final String runConfigId;
    @NotNull
    private final TerminalInteractionBehavior defaultTerminalInteractionBehavior;

    public RdJsonConfigurationFactory(@NotNull ConfigurationType type, @NotNull String defaultConfigName, @NotNull RunnableProjectKind defaultProjectKind, @NotNull String runConfigId, @NotNull TerminalInteractionBehavior defaultTerminalInteractionBehavior) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)defaultConfigName, (String)"defaultConfigName");
        Intrinsics.checkNotNullParameter((Object)defaultProjectKind, (String)"defaultProjectKind");
        Intrinsics.checkNotNullParameter((Object)runConfigId, (String)"runConfigId");
        Intrinsics.checkNotNullParameter((Object)((Object)defaultTerminalInteractionBehavior), (String)"defaultTerminalInteractionBehavior");
        super(type);
        this.defaultConfigName = defaultConfigName;
        this.defaultProjectKind = defaultProjectKind;
        this.runConfigId = runConfigId;
        this.defaultTerminalInteractionBehavior = defaultTerminalInteractionBehavior;
    }

    @NotNull
    public RunConfigurationSingletonPolicy getSingletonPolicy() {
        return RunConfigurationSingletonPolicy.SINGLE_INSTANCE;
    }

    private final RdJsonConfigurationParameters createParameters() {
        return new RdJsonConfigurationParameters(this.defaultProjectKind, this.defaultTerminalInteractionBehavior);
    }

    @NotNull
    public RunConfiguration createConfiguration(@Nullable String name, @NotNull RunConfiguration template) {
        String string;
        Object parameters;
        Project project;
        block5: {
            Object object;
            block4: {
                Intrinsics.checkNotNullParameter((Object)template, (String)"template");
                project = template.getProject();
                object = template instanceof CppProjectConfiguration ? (CppProjectConfiguration)template : null;
                if (object == null) break block4;
                CppProjectConfiguration it = object;
                boolean bl = false;
                CppProjectConfigurationParameters cppProjectConfigurationParameters = ((CppProjectConfiguration)template).getParameters().copy();
                object = cppProjectConfigurationParameters;
                if (cppProjectConfigurationParameters != null) break block5;
            }
            object = parameters = (CppProjectConfigurationParameters)this.createParameters();
        }
        if ((string = name) == null) {
            string = this.defaultConfigName;
        }
        Project project2 = template.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        CppProjectConfiguration configuration = new CppProjectConfiguration(string, project2, (ConfigurationFactory)this, (CppProjectConfigurationParameters)((Object)parameters), (Function1<? super Project, ? extends SettingsEditor<? extends RunConfiguration>>)((Function1)arg_0 -> RdJsonConfigurationFactory.createConfiguration$lambda$1((CppProjectConfigurationParameters)((Object)parameters), this, arg_0)));
        Intrinsics.checkNotNull((Object)project);
        this.setup(name, project, configuration);
        return (RunConfiguration)configuration;
    }

    private final void setup(String name, Project project, CppProjectConfiguration configuration) {
        String projectFilePath;
        RunnableProject runnableProject;
        RunnableProjectsModel runnableProjectsModel = ProjectExKt.getRunnableProjectsModelIfAvailable((Project)project);
        if (runnableProjectsModel != null && (runnableProject = this.getRunnableProject(name, runnableProjectsModel, projectFilePath = configuration.getProjectFilePath())) != null) {
            RdJsonConfigurationType.Companion.setupFromProject(configuration, runnableProject);
        }
    }

    private final RunnableProject getRunnableProject(String name, RunnableProjectsModel runnableProjectsModel, String projectFilePath) {
        RunnableProject runnableProject;
        List list = (List)runnableProjectsModel.getProjects().getValueOrNull();
        if (list != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RunnableProject it = (RunnableProject)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getKind(), (Object)this.defaultProjectKind) && (Intrinsics.areEqual((Object)it.getProjectFilePath(), (Object)projectFilePath) || Intrinsics.areEqual((Object)it.getName(), (Object)name)))) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            runnableProject = v1;
        } else {
            runnableProject = null;
        }
        return runnableProject;
    }

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RdJsonConfigurationParameters parameters = this.createParameters();
        CppProjectConfiguration configuration = new CppProjectConfiguration(this.defaultConfigName, project, (ConfigurationFactory)this, parameters, (Function1<? super Project, ? extends SettingsEditor<? extends RunConfiguration>>)((Function1)arg_0 -> RdJsonConfigurationFactory.createTemplateConfiguration$lambda$0(parameters, this, arg_0)));
        this.setupDefault(project, configuration);
        return (RunConfiguration)configuration;
    }

    private final void setupDefault(Project project, CppProjectConfiguration configuration) {
        RunnableProjectsModel runnableProjectsModel = ProjectExKt.getRunnableProjectsModelIfAvailable((Project)project);
        if (runnableProjectsModel != null) {
            String projectFilePath = configuration.getProjectFilePath();
            RunnableProject runnableProject = this.getRunnableProject(this.getName(), runnableProjectsModel, projectFilePath);
            if (runnableProject == null) {
                List list = (List)runnableProjectsModel.getProjects().getValueOrNull();
                if (list != null) {
                    Object v1;
                    block6: {
                        Iterable $this$firstOrNull$iv = list;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            RunnableProject it = (RunnableProject)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)configuration.getParameters().getProjectKind())) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    v2 = v1;
                } else {
                    v2 = runnableProject = null;
                }
            }
            if (runnableProject != null) {
                RdJsonConfigurationType.Companion.setupFromProject(configuration, runnableProject);
            }
        }
    }

    private static final SettingsEditor createConfiguration$lambda$1(CppProjectConfigurationParameters $parameters, RdJsonConfigurationFactory this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (SettingsEditor)new RdJsonSettingsEditorGroup(it, $parameters.getProjectKind(), this$0.runConfigId);
    }

    private static final SettingsEditor createTemplateConfiguration$lambda$0(RdJsonConfigurationParameters $parameters, RdJsonConfigurationFactory this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (SettingsEditor)new RdJsonSettingsEditorGroup(it, $parameters.getProjectKind(), this$0.runConfigId);
    }
}

