/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.lpp;

import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/cpp/lpp/LivePlusPlusDetector;", "", "<init>", "()V", "Companion", "intellij.rider.plugins.cpp"})
public final class LivePlusPlusDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/cpp/lpp/LivePlusPlusDetector$Companion;", "", "<init>", "()V", "isLivePPSupportedOnSystem", "", "isLivePPDetected", "getLivePPLicensesDirectory", "Ljava/nio/file/Path;", "intellij.rider.plugins.cpp"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isLivePPSupportedOnSystem() {
            return SystemInfo.isWindows;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isLivePPDetected() {
            Path livePPDir = this.getLivePPLicensesDirectory();
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(livePPDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(livePPDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
            if (((Collection)PathsKt.listDirectoryEntries$default((Path)livePPDir, null, (int)1, null)).isEmpty()) return false;
            return true;
        }

        private final Path getLivePPLicensesDirectory() {
            String homeDirectory = System.getProperty("user.home");
            if (!SystemInfo.isWindows) {
                throw new NotImplementedError(null, 1, null);
            }
            Path path = Paths.get(homeDirectory + "/AppData/Local/Live++ 2/Licenses/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

