/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.unreal;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.UnrealModel;
import com.jetbrains.rd.ide.model.UnrealModel_PregeneratedKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rider.cpp.debugger.DebuggerScriptsHelper;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/cpp/debugger/unreal/RiderCppUE4LLDBConfigurator;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "loadBlueprintsSupportScripts", "loadPrettyPrinters", "getUE4LLDBFormatterFilePaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.cpp"})
public final class RiderCppUE4LLDBConfigurator
implements CidrDebugProcessConfigurator {
    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        LLDBDriverConfiguration lLDBDriverConfiguration = debuggerDriverConfiguration instanceof LLDBDriverConfiguration ? (LLDBDriverConfiguration)debuggerDriverConfiguration : null;
        if (lLDBDriverConfiguration == null) {
            return;
        }
        LLDBDriverConfiguration driverConfiguration = lLDBDriverConfiguration;
        Project project = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        UnrealModel unrealModel = UnrealModel_PregeneratedKt.getUnrealModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)unrealModel.isUnrealSolution()))) {
            if (driverConfiguration.getHostMachine().getOS() == OS.Windows) {
                this.loadBlueprintsSupportScripts(process);
            } else {
                this.loadPrettyPrinters(process);
            }
        }
    }

    private final void loadBlueprintsSupportScripts(CidrDebugProcess process) {
        String unrealBlueprintMixedStackPythonScriptPath = DebuggerScriptsHelper.INSTANCE.getUnrealBlueprintMixedStackPythonScriptPath();
        CharSequence charSequence = unrealBlueprintMixedStackPythonScriptPath;
        if (!(charSequence == null || charSequence.length() == 0)) {
            process.postCommand(arg_0 -> RiderCppUE4LLDBConfigurator.loadBlueprintsSupportScripts$lambda$0(unrealBlueprintMixedStackPythonScriptPath, arg_0));
        }
    }

    private final void loadPrettyPrinters(CidrDebugProcess process) {
        process.postCommand(arg_0 -> RiderCppUE4LLDBConfigurator.loadPrettyPrinters$lambda$0(this, process, arg_0));
    }

    private final List<String> getUE4LLDBFormatterFilePaths(Project project) {
        return (List)ActionsKt.runReadAction(() -> RiderCppUE4LLDBConfigurator.getUE4LLDBFormatterFilePaths$lambda$0(project));
    }

    private static final void loadBlueprintsSupportScripts$lambda$0(String $unrealBlueprintMixedStackPythonScriptPath, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.executeInterpreterCommand(-1L, -1, "command script import \"" + $unrealBlueprintMixedStackPythonScriptPath + "\"");
    }

    private static final void loadPrettyPrinters$lambda$0(RiderCppUE4LLDBConfigurator this$0, CidrDebugProcess $process, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Project project = $process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        List<String> formatterFilePaths = this$0.getUE4LLDBFormatterFilePaths(project);
        driver.executeInterpreterCommand(-1L, -1, "settings set target.inline-breakpoint-strategy always");
        for (String path : formatterFilePaths) {
            driver.executeInterpreterCommand(-1L, -1, "command script import \"" + path + "\"");
        }
    }

    private static final List getUE4LLDBFormatterFilePaths$lambda$0(Project $project) {
        Object[] objectArray = new String[]{"UE4DataFormatters.py", "UEDataFormatters.py", "UE4DataFormatters_2ByteChars.py", "UEDataFormatters_2ByteChars.py"};
        Set formatterNames = SetsKt.setOf((Object[])objectArray);
        List result2 = new ArrayList();
        FilenameIndex.processFilesByNames((Set)formatterNames, (boolean)true, (GlobalSearchScope)GlobalSearchScope.allScope((Project)$project), null, arg_0 -> RiderCppUE4LLDBConfigurator.getUE4LLDBFormatterFilePaths$lambda$0$1(arg_0 -> RiderCppUE4LLDBConfigurator.getUE4LLDBFormatterFilePaths$lambda$0$0(result2, arg_0), arg_0));
        return result2;
    }

    private static final boolean getUE4LLDBFormatterFilePaths$lambda$0$0(List $result, VirtualFile file) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        $result.add(string);
        return true;
    }

    private static final boolean getUE4LLDBFormatterFilePaths$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

