/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.remote;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.rider.CPUArch;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.debugger.attach.remoting.AdditionalRemoteDebuggerFilesProvider;
import com.jetbrains.rider.debugger.attach.remoting.DebuggerFilesGroup;
import com.jetbrains.rider.util.OSKind;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/cpp/debugger/remote/RiderCppAdditionalRemoteDebuggerFilesProvider;", "Lcom/jetbrains/rider/debugger/attach/remoting/AdditionalRemoteDebuggerFilesProvider;", "<init>", "()V", "ALL_PLATFORM_DIRS", "", "", "name", "getName", "()Ljava/lang/String;", "getAdditionalFiles", "", "Lcom/jetbrains/rider/debugger/attach/remoting/DebuggerFilesGroup;", "project", "Lcom/intellij/openapi/project/Project;", "remoteMachineCpuKind", "Lcom/jetbrains/rider/CPUKind;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/CPUKind;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFilesToCheckInstallation", "(Lcom/jetbrains/rider/CPUKind;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "internalGetAdditionalFiles", "createVersionMarkerGroup", "getLldbFolder", "Ljava/nio/file/Path;", "isWindowsX86orX64", "", "Companion", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nRiderCppAdditionalRemoteDebuggerFilesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppAdditionalRemoteDebuggerFilesProvider.kt\ncom/jetbrains/rider/cpp/debugger/remote/RiderCppAdditionalRemoteDebuggerFilesProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n13#2:136\n*S KotlinDebug\n*F\n+ 1 RiderCppAdditionalRemoteDebuggerFilesProvider.kt\ncom/jetbrains/rider/cpp/debugger/remote/RiderCppAdditionalRemoteDebuggerFilesProvider\n*L\n19#1:136\n*E\n"})
public final class RiderCppAdditionalRemoteDebuggerFilesProvider
implements AdditionalRemoteDebuggerFilesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> ALL_PLATFORM_DIRS;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String PLATFORM_WIN = "win";
    @NotNull
    private static final String PLATFORM_LINUX = "linux";
    @NotNull
    private static final String PLATFORM_MAC = "mac";
    @NotNull
    public static final String PROVIDER_NAME = "RiderCppAdditionalRemoteDebuggerFilesProvider";

    public RiderCppAdditionalRemoteDebuggerFilesProvider() {
        Object[] objectArray = new String[]{PLATFORM_WIN, PLATFORM_LINUX, PLATFORM_MAC};
        this.ALL_PLATFORM_DIRS = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public String getName() {
        return PROVIDER_NAME;
    }

    @Nullable
    public Object getAdditionalFiles(@NotNull Project project, @NotNull CPUKind remoteMachineCpuKind, @NotNull Continuation<? super List<DebuggerFilesGroup>> $completion) {
        List<DebuggerFilesGroup> list;
        try {
            if (!this.isWindowsX86orX64(remoteMachineCpuKind)) {
                return CollectionsKt.emptyList();
            }
            list = this.internalGetAdditionalFiles(project, remoteMachineCpuKind);
        }
        catch (Throwable t) {
            logger.warn("Failed to collect additional debugger files", t);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public Object getFilesToCheckInstallation(@NotNull CPUKind remoteMachineCpuKind, @NotNull Continuation<? super List<String>> $completion) {
        List list;
        try {
            if (!this.isWindowsX86orX64(remoteMachineCpuKind)) {
                return CollectionsKt.emptyList();
            }
            String string = ApplicationInfo.getInstance().getFullVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
            String version = string;
            list = CollectionsKt.listOf((Object)("native/" + version + ".version"));
        }
        catch (Throwable t) {
            logger.warn("Failed to get version marker path", t);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<DebuggerFilesGroup> internalGetAdditionalFiles(Project project, CPUKind remoteMachineCpuKind) {
        Object[] stream;
        if (!this.isWindowsX86orX64(remoteMachineCpuKind)) {
            return CollectionsKt.emptyList();
        }
        Path path = this.getLldbFolder();
        if (path == null) {
            return CollectionsKt.emptyList();
        }
        Path lldbFolder = path;
        AutoCloseable autoCloseable = Files.list(lldbFolder);
        Throwable throwable = null;
        try {
            stream = (Stream)autoCloseable;
            boolean bl = false;
            stream = stream.filter(arg_0 -> RiderCppAdditionalRemoteDebuggerFilesProvider.internalGetAdditionalFiles$lambda$0$1(arg_0 -> RiderCppAdditionalRemoteDebuggerFilesProvider.internalGetAdditionalFiles$lambda$0$0(this, arg_0), arg_0)).toList();
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Object[] topLevelFilesAndDirs = stream;
        Path winPlatformDir = lldbFolder.resolve(PLATFORM_WIN);
        stream = new Path[]{winPlatformDir.resolve("x86"), winPlatformDir.resolve("x64")};
        List winPlatformSubdirs = CollectionsKt.listOf((Object[])stream);
        Path helpersFolder = lldbFolder.getParent().resolve("helpers");
        List<Path> helpersFiles = Files.list(helpersFolder).toList();
        Object[] objectArray = new DebuggerFilesGroup[4];
        String string = ((Object)lldbFolder).toString();
        Intrinsics.checkNotNull((Object)topLevelFilesAndDirs);
        objectArray[0] = new DebuggerFilesGroup(string, (List)topLevelFilesAndDirs, "native/lldb");
        objectArray[1] = new DebuggerFilesGroup(((Object)winPlatformDir).toString(), winPlatformSubdirs, "native/lldb/win");
        String string2 = ((Object)helpersFolder).toString();
        Intrinsics.checkNotNull(helpersFiles);
        objectArray[2] = new DebuggerFilesGroup(string2, helpersFiles, "native/helpers");
        objectArray[3] = this.createVersionMarkerGroup(project);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final DebuggerFilesGroup createVersionMarkerGroup(Project project) {
        String string = ApplicationInfo.getInstance().getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
        String version = string;
        Path tempDir = Files.createTempDirectory("rider-version-marker-", new FileAttribute[0]);
        Path markerFile = tempDir.resolve(version + ".version");
        Files.writeString(markerFile, (CharSequence)version, new OpenOption[0]);
        UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).onTermination(() -> RiderCppAdditionalRemoteDebuggerFilesProvider.createVersionMarkerGroup$lambda$0(tempDir));
        return new DebuggerFilesGroup(((Object)tempDir).toString(), CollectionsKt.listOf((Object)markerFile), "native");
    }

    private final Path getLldbFolder() {
        Path lldbFolder = CidrDebuggerPathManager.getLLDBDirectory().toPath();
        Path path = lldbFolder.getFileName();
        if (!StringUtil.equalsIgnoreCase((CharSequence)(path != null ? ((Object)path).toString() : null), (CharSequence)"lldb")) {
            logger.warn("Unexpected directory structure: Expected 'lldb' folder but got '" + lldbFolder.getFileName() + "'. Returning null.");
            return null;
        }
        return lldbFolder;
    }

    private final boolean isWindowsX86orX64(CPUKind $this$isWindowsX86orX64) {
        return $this$isWindowsX86orX64.getOsKind() == OSKind.Windows && ($this$isWindowsX86orX64.getCpuArch() == CPUArch.X86 || $this$isWindowsX86orX64.getCpuArch() == CPUArch.X64);
    }

    private static final boolean internalGetAdditionalFiles$lambda$0$0(RiderCppAdditionalRemoteDebuggerFilesProvider this$0, Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return true;
        }
        return !this$0.ALL_PLATFORM_DIRS.contains(((Object)path.getFileName()).toString());
    }

    private static final boolean internalGetAdditionalFiles$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createVersionMarkerGroup$lambda$0(Path $tempDir) {
        try {
            Files.walk($tempDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(arg_0 -> RiderCppAdditionalRemoteDebuggerFilesProvider.createVersionMarkerGroup$lambda$0$1(RiderCppAdditionalRemoteDebuggerFilesProvider::createVersionMarkerGroup$lambda$0$0, arg_0));
        }
        catch (Exception e) {
            logger.warn("Failed to delete temporary version marker directory: " + $tempDir, (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createVersionMarkerGroup$lambda$0$0(Path it) {
        Files.deleteIfExists(it);
        return Unit.INSTANCE;
    }

    private static final void createVersionMarkerGroup$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderCppAdditionalRemoteDebuggerFilesProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderCppAdditionalRemoteDebuggerFilesProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/cpp/debugger/remote/RiderCppAdditionalRemoteDebuggerFilesProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "PLATFORM_WIN", "", "PLATFORM_LINUX", "PLATFORM_MAC", "PROVIDER_NAME", "intellij.rider.plugins.cpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

