/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.modulesView;

import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.xdebugger.impl.modulesView.DebuggerModule;
import com.intellij.xdebugger.impl.modulesView.ModuleListener;
import com.jetbrains.cidr.execution.debugger.modules.CidrDebuggerModuleData;
import com.jetbrains.rider.cpp.debugger.modulesView.CidrFileSymbolsSource;
import com.jetbrains.rider.cpp.debugger.modulesView.CidrSymbolsSource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000f\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/cpp/debugger/modulesView/CidrDebuggerModule;", "Lcom/intellij/xdebugger/impl/modulesView/DebuggerModule;", "data", "Lcom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModuleData;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/modules/CidrDebuggerModuleData;)V", "loadedSymbols", "", "Lcom/jetbrains/rider/cpp/debugger/modulesView/CidrSymbolsSource;", "getLoadedSymbols", "()Ljava/util/List;", "addSymbolFile", "", "symbolFilePath", "", "name", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "location", "Ljava/nio/file/Path;", "getLocation", "()Ljava/nio/file/Path;", "loadOrder", "", "getLoadOrder", "()I", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "addListener", "listener", "Lcom/intellij/xdebugger/impl/modulesView/ModuleListener;", "removeListener", "intellij.rider.plugins.cpp"})
public final class CidrDebuggerModule
implements DebuggerModule {
    @NotNull
    private final List<CidrSymbolsSource> loadedSymbols;
    @NotNull
    private final String name;
    @Nullable
    private final Path location;
    private final int loadOrder;
    @NotNull
    private final UUID id;

    public CidrDebuggerModule(@NotNull CidrDebuggerModuleData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.loadedSymbols = new ArrayList();
        this.name = data2.getName();
        this.location = NioPathUtil.toNioPathOrNull((String)data2.getPath());
        this.loadOrder = data2.getLoadOrder();
        this.id = data2.getId();
    }

    @NotNull
    public final List<CidrSymbolsSource> getLoadedSymbols() {
        return this.loadedSymbols;
    }

    public final void addSymbolFile(@NotNull String symbolFilePath) {
        Intrinsics.checkNotNullParameter((Object)symbolFilePath, (String)"symbolFilePath");
        this.loadedSymbols.add(new CidrFileSymbolsSource(symbolFilePath));
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Path getLocation() {
        return this.location;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    public void addListener(@NotNull ModuleListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void removeListener(@NotNull ModuleListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }
}

