/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver;

import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.LLDBDriverValuesRefresherKt;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MonoMixedMonoLLDBDriver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0007BCDEFGHB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\t*\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u00020\u0011*\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001bH\u0002J&\u0010\u001c\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0$H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010'\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ$\u0010(\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dJ$\u0010*\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dJ&\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u001bJ\u000e\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001bJ\u0018\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u001bH\u0002J\u001e\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u001c\u0010:\u001a\u00020&2\u0006\u00108\u001a\u00020\u001b2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001b0<J\u0006\u0010=\u001a\u00020&J\u0006\u0010>\u001a\u00020&J\u0006\u0010?\u001a\u00020&J\u0010\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore;", "", "driver", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;", "<init>", "(Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;)V", "getDriver", "()Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;", "findThread", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ThreadNode;", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$RootNode;", "id", "", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "findThreadOrThrow", "findFrame", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$FrameNode;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "findFrameOrThrow", "lldbFrontendSuspendCount", "", "root", "findValuePath", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ValuePath;", "value", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "findValueRecursively", "", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ValueNode;", "parent", "valueToFind", "", "current", "result", "", "saveThread", "", "saveFrame", "saveFrameVariablesAndLoadData", "variables", "saveRegistersAndLoadData", "values", "saveEvaluatedValueAndLoadData", "threadId", "expression", "", "frameId", "evaluatedValue", "refreshValue", "llValue", "updateVariableVersion", "variable", "newLLValue", "findNodeByLoading", "parentValue", "membersPath", "saveValueMembers", "members", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ResultList;", "incrementSuspendCount", "resetCache", "resetSavedLLData", "tryGetCachedValueData", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;", "ValueNode", "EvaluatedValueNode", "RegisterNode", "FrameNode", "ThreadNode", "RootNode", "ValuePath", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nLLDBDriverValuesRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLDBDriverValuesRefresher.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n216#2:228\n217#2:233\n216#2:270\n217#2:275\n1869#3:229\n1869#3,2:230\n1870#3:232\n1869#3,2:234\n1563#3:236\n1634#3,3:237\n774#3:240\n865#3,2:241\n1869#3,2:243\n1563#3:245\n1634#3,3:246\n774#3:249\n865#3,2:250\n1869#3,2:252\n230#3,2:254\n230#3,2:256\n230#3,2:259\n1563#3:261\n1634#3,3:262\n774#3:265\n865#3,2:266\n1869#3,2:268\n1869#3:271\n1869#3,2:272\n1870#3:274\n1869#3,2:276\n1#4:258\n*S KotlinDebug\n*F\n+ 1 LLDBDriverValuesRefresher.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore\n*L\n48#1:228\n48#1:233\n200#1:270\n200#1:275\n49#1:229\n50#1:230,2\n49#1:232\n73#1:234,2\n98#1:236\n98#1:237,3\n99#1:240\n99#1:241,2\n101#1:243,2\n110#1:245\n110#1:246,3\n111#1:249\n111#1:250,2\n113#1:252,2\n121#1:254,2\n140#1:256,2\n165#1:259,2\n172#1:261\n172#1:262,3\n173#1:265\n173#1:266,2\n175#1:268,2\n201#1:271\n202#1:272,2\n201#1:274\n197#1:276,2\n*E\n"})
public final class MixedModeLLDBDataStore {
    @NotNull
    private final MonoMixedMonoLLDBDriver driver;
    private int lldbFrontendSuspendCount;
    @NotNull
    private RootNode root;

    public MixedModeLLDBDataStore(@NotNull MonoMixedMonoLLDBDriver driver) {
        Intrinsics.checkNotNullParameter((Object)((Object)driver), (String)"driver");
        this.driver = driver;
        this.root = new RootNode(new LinkedHashMap());
    }

    @NotNull
    public final MonoMixedMonoLLDBDriver getDriver() {
        return this.driver;
    }

    private final ThreadNode findThread(RootNode $this$findThread, long id) {
        return $this$findThread.getThreads().get(id);
    }

    private final ThreadNode findThread(RootNode $this$findThread, LLThread thread) {
        return this.findThread($this$findThread, thread.getId());
    }

    private final ThreadNode findThreadOrThrow(RootNode $this$findThreadOrThrow, LLThread thread) {
        ThreadNode threadNode = this.findThread($this$findThreadOrThrow, thread);
        if (threadNode == null) {
            throw new IllegalStateException(("Thread " + thread + " not added").toString());
        }
        return threadNode;
    }

    private final FrameNode findFrame(RootNode $this$findFrame, LLThread thread, LLFrame frame) {
        Object object = this.findThread($this$findFrame, thread);
        return object != null && (object = ((ThreadNode)object).getFrames()) != null ? (FrameNode)CollectionsKt.getOrNull((List)object, (int)frame.getIndex()) : null;
    }

    private final FrameNode findFrameOrThrow(RootNode $this$findFrameOrThrow, LLThread thread, LLFrame frame) {
        FrameNode frameNode = this.findFrame($this$findFrameOrThrow, thread, frame);
        if (frameNode == null) {
            throw new IllegalStateException(("Frame " + frame + " not added").toString());
        }
        return frameNode;
    }

    private final ValuePath findValuePath(RootNode $this$findValuePath, LLValue value) {
        Map<Long, ThreadNode> $this$forEach$iv = $this$findValuePath.getThreads();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, ThreadNode>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, ThreadNode> element$iv;
            Map.Entry<Long, ThreadNode> threadNode = element$iv = iterator.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = threadNode.getValue().getFrames();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FrameNode frameNode = (FrameNode)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = frameNode.getTopNodes();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    ValueNode valueNode = (ValueNode)element$iv3;
                    boolean bl3 = false;
                    List<ValueNode> result2 = this.findValueRecursively(valueNode, value);
                    if (!(!((Collection)result2).isEmpty())) continue;
                    return new ValuePath(threadNode.getValue(), frameNode, result2);
                }
            }
        }
        return null;
    }

    private final List<ValueNode> findValueRecursively(ValueNode parent, LLValue valueToFind) {
        List result2 = new ArrayList();
        this.findValueRecursively(parent, valueToFind, result2);
        return CollectionsKt.reversed((Iterable)result2);
    }

    private final boolean findValueRecursively(ValueNode current, LLValue valueToFind, List<ValueNode> result2) {
        if (LLDBDriverValuesRefresherKt.access$equalsIgnoringIsValidAndFullExpressionField(current.getValue(), valueToFind)) {
            result2.add(current);
            return true;
        }
        Iterable $this$forEach$iv = current.getMembers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueNode it = (ValueNode)element$iv;
            boolean bl = false;
            if (!this.findValueRecursively(it, valueToFind, result2)) continue;
            result2.add(current);
            return true;
        }
        return false;
    }

    public final void saveThread(@NotNull LLThread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        if (this.findThread(this.root, thread) != null) {
            return;
        }
        this.root.getThreads().put(thread.getId(), new ThreadNode(this.lldbFrontendSuspendCount, thread, new ArrayList()));
    }

    public final void saveFrame(@NotNull LLFrame frame, @NotNull LLThread thread) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        if (this.findFrame(this.root, thread, frame) != null) {
            return;
        }
        this.saveThread(thread);
        this.findThreadOrThrow(this.root, thread).getFrames().add(new FrameNode(this.lldbFrontendSuspendCount, frame, new LinkedHashSet()));
    }

    /*
     * WARNING - void declaration
     */
    public final void saveFrameVariablesAndLoadData(@NotNull LLThread thread, @NotNull LLFrame frame, @NotNull List<? extends LLValue> variables) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.saveFrame(frame, thread);
        FrameNode frame2 = this.findFrameOrThrow(this.root, thread, frame);
        Iterable $this$map$iv = frame2.getTopNodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueNode valueNode = (ValueNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue().getName());
        }
        Set alreadyAddedValues = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = variables;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LLValue it = (LLValue)element$iv$iv;
            boolean bl = false;
            if (!(!alreadyAddedValues.contains(it.getName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newValues = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = newValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLValue it = (LLValue)element$iv;
            boolean bl = false;
            LLValueData data2 = this.driver.getDataNoSuspendAndRefresh$intellij_rider_plugins_cpp(it);
            frame2.getTopNodes().add(new ValueNode(this.lldbFrontendSuspendCount, it, data2, new LinkedHashSet()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveRegistersAndLoadData(@NotNull LLThread thread, @NotNull LLFrame frame, @NotNull List<? extends LLValue> values) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.saveFrame(frame, thread);
        FrameNode frame2 = this.findFrameOrThrow(this.root, thread, frame);
        Iterable $this$map$iv = frame2.getTopNodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueNode valueNode = (ValueNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue().getName());
        }
        Set alreadyAddedValues = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = values;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LLValue it = (LLValue)element$iv$iv;
            boolean bl = false;
            if (!(!alreadyAddedValues.contains(it.getName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newValues = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = newValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLValue it = (LLValue)element$iv;
            boolean bl = false;
            LLValueData data2 = this.driver.getDataNoSuspendAndRefresh$intellij_rider_plugins_cpp(it);
            frame2.getTopNodes().add(new RegisterNode(this.lldbFrontendSuspendCount, it, data2));
        }
    }

    public final void saveEvaluatedValueAndLoadData(long threadId, @NotNull String expression, int frameId, @NotNull LLValue evaluatedValue) {
        Object element$iv2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)evaluatedValue, (String)"evaluatedValue");
            ThreadNode threadNode = this.findThread(this.root, threadId);
            if (threadNode == null) {
                throw new IllegalStateException(("Thread " + threadId + " not found").toString());
            }
            ThreadNode threadNode2 = threadNode;
            Iterable $this$first$iv = threadNode2.getFrames();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                FrameNode it = (FrameNode)element$iv2;
                boolean bl = false;
                if (!(it.getFrame().getIndex() == frameId)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        FrameNode frameNode = (FrameNode)element$iv2;
        LLValueData data2 = this.driver.getDataNoSuspendAndRefresh$intellij_rider_plugins_cpp(evaluatedValue);
        frameNode.getTopNodes().add(new EvaluatedValueNode(this.lldbFrontendSuspendCount, expression, evaluatedValue, data2, new LinkedHashSet()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LLValue refreshValue(@NotNull LLValue llValue) {
        void it;
        LLValue refreshedTopValue;
        LLValue lLValue;
        Intrinsics.checkNotNullParameter((Object)llValue, (String)"llValue");
        ValuePath valuePath = this.findValuePath(this.root, llValue);
        if (valuePath == null) {
            throw new IllegalStateException("Can't find this value".toString());
        }
        ValuePath path = valuePath;
        List pathExceptFrameVariable = CollectionsKt.drop((Iterable)path.getValuesPath(), (int)1);
        Object object = CollectionsKt.last(path.getValuesPath());
        ValueNode it2 = (ValueNode)object;
        boolean bl = false;
        if (it2.getVersion() == this.lldbFrontendSuspendCount) {
            return it2.getValue();
        }
        ValueNode topValue = (ValueNode)CollectionsKt.first(path.getValuesPath());
        ValueNode valueNode = topValue;
        if (valueNode instanceof EvaluatedValueNode) {
            lLValue = this.driver.evaluate(path.getThreadNode().getThread(), path.getFrameNode().getFrame(), ((EvaluatedValueNode)topValue).getExpression());
        } else if (valueNode instanceof RegisterNode) {
            Object element$iv2;
            block10: {
                String[] stringArray = new String[]{((RegisterNode)topValue).getRegisterName()};
                List regs = CollectionsKt.filterNotNull((Iterable)this.driver.getRegisters(path.getThreadNode().getThread(), path.getFrameNode().getFrame(), SetsKt.mutableSetOf((Object[])stringArray)));
                Iterable $this$first$iv = regs;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    LLValue it3 = (LLValue)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it3.getName(), (Object)((RegisterNode)topValue).getRegisterName())) continue;
                    break block10;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            lLValue = (LLValue)element$iv2;
        } else {
            LLValue lLValue2;
            block11: {
                List list = this.driver.getFrameVariables(path.getThreadNode().getThread(), path.getFrameNode().getFrame()).getVariables();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVariables(...)");
                for (LLValue it4 : (Iterable)list) {
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it4);
                    if ((LLDBDriverValuesRefresherKt.access$equalsIgnoringIsValidAndFullExpressionField(it4, llValue) ? it4 : (lLValue2 = !LLDBDriverValuesRefresherKt.access$equalsIgnoringIsValidAndFullExpressionField(it4, topValue.getValue()) ? null : it4)) == null) {
                        continue;
                    }
                    break block11;
                }
                lLValue2 = lLValue = null;
            }
            if (lLValue2 == null) {
                throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
            }
        }
        LLValue lLValue3 = lLValue;
        Intrinsics.checkNotNull((Object)lLValue3);
        lLValue3 = refreshedTopValue = lLValue3;
        valueNode = lLValue3;
        MixedModeLLDBDataStore mixedModeLLDBDataStore = this;
        boolean bl4 = false;
        this.updateVariableVersion(topValue, (LLValue)it);
        return mixedModeLLDBDataStore.findNodeByLoading(lLValue3, pathExceptFrameVariable);
    }

    private final void updateVariableVersion(ValueNode variable, LLValue newLLValue) {
        variable.setVersion(this.lldbFrontendSuspendCount);
        variable.setValue(newLLValue);
    }

    private final LLValue findNodeByLoading(LLValue parentValue, List<? extends ValueNode> membersPath) {
        Object element$iv2;
        List otherPaths;
        block2: {
            if (membersPath.isEmpty()) {
                return parentValue;
            }
            List list = this.driver.getVariableChildren((LLValue)parentValue, (int)0, (int)this.driver.getChildrenCount((LLValue)parentValue).intValue()).list;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
            List children = list;
            ValueNode currentPath = (ValueNode)CollectionsKt.first(membersPath);
            otherPaths = CollectionsKt.drop((Iterable)membersPath, (int)1);
            Iterable $this$first$iv = children;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                LLValue it = (LLValue)element$iv2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!LLDBDriverValuesRefresherKt.access$equalsIgnoringIsValidAndFullExpressionField(it, currentPath.getValue())) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        LLValue currentChild = (LLValue)element$iv2;
        Intrinsics.checkNotNull((Object)currentChild);
        return this.findNodeByLoading(currentChild, otherPaths);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveValueMembers(@NotNull LLValue parentValue, @NotNull DebuggerDriver.ResultList<LLValue> members) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parentValue, (String)"parentValue");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        ValuePath valuePath = this.findValuePath(this.root, parentValue);
        if (valuePath == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        ValueNode parentNode = (ValueNode)CollectionsKt.last(valuePath.getValuesPath());
        Iterable $this$map$iv = parentNode.getMembers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void member;
            ValueNode valueNode = (ValueNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(member.getValue().getName());
        }
        List alreadyAddedValues = (List)destination$iv$iv;
        List list = members.list;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LLValue it = (LLValue)element$iv$iv;
            boolean bl = false;
            if (!(!alreadyAddedValues.contains(it.getName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newMembers = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = newMembers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLValue it = (LLValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LLValueData data2 = this.driver.getDataNoSuspendAndRefresh$intellij_rider_plugins_cpp(it);
            parentNode.getMembers().add(new ValueNode(this.lldbFrontendSuspendCount, it, data2, new LinkedHashSet()));
        }
    }

    public final void incrementSuspendCount() {
        int n = this.lldbFrontendSuspendCount;
        this.lldbFrontendSuspendCount = n + 1;
    }

    public final void resetCache() {
        this.root = new RootNode(new LinkedHashMap());
        this.lldbFrontendSuspendCount = 0;
    }

    public final void resetSavedLLData() {
        Map<Long, ThreadNode> $this$forEach$iv = this.root.getThreads();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, ThreadNode>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, ThreadNode> element$iv;
            Map.Entry<Long, ThreadNode> threadNode = element$iv = iterator.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = threadNode.getValue().getFrames();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FrameNode frameNode = (FrameNode)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = frameNode.getTopNodes();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    ValueNode valueNode = (ValueNode)element$iv3;
                    boolean bl3 = false;
                    MixedModeLLDBDataStore.resetSavedLLData$resetSavedLLData(valueNode);
                }
            }
        }
    }

    @Nullable
    public final LLValueData tryGetCachedValueData(@NotNull LLValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ValuePath value2 = this.findValuePath(this.root, value);
        Object object = value2;
        return object != null && (object = ((ValuePath)object).getValuesPath()) != null && (object = (ValueNode)CollectionsKt.last((List)object)) != null ? ((ValueNode)object).getData() : null;
    }

    private static final void resetSavedLLData$resetSavedLLData(ValueNode value) {
        value.setData(null);
        Iterable $this$forEach$iv = value.getMembers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueNode it = (ValueNode)element$iv;
            boolean bl = false;
            MixedModeLLDBDataStore.resetSavedLLData$resetSavedLLData(it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$EvaluatedValueNode;", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ValueNode;", "version", "", "expression", "", "value", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "data", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;", "members", "", "<init>", "(ILjava/lang/String;Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;Ljava/util/Set;)V", "getExpression", "()Ljava/lang/String;", "intellij.rider.plugins.cpp"})
    private static final class EvaluatedValueNode
    extends ValueNode {
        @NotNull
        private final String expression;

        public EvaluatedValueNode(int version, @NotNull String expression, @NotNull LLValue value, @NotNull LLValueData data2, @NotNull Set<ValueNode> members) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter(members, (String)"members");
            super(version, value, data2, members);
            this.expression = expression;
        }

        @NotNull
        public final String getExpression() {
            return this.expression;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$FrameNode;", "", "version", "", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "topNodes", "", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ValueNode;", "<init>", "(ILcom/jetbrains/cidr/execution/debugger/backend/LLFrame;Ljava/util/Set;)V", "getVersion", "()I", "getFrame", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "getTopNodes", "()Ljava/util/Set;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.plugins.cpp"})
    private static final class FrameNode {
        private final int version;
        @NotNull
        private final LLFrame frame;
        @NotNull
        private final Set<ValueNode> topNodes;

        public FrameNode(int version, @NotNull LLFrame frame, @NotNull Set<ValueNode> topNodes) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter(topNodes, (String)"topNodes");
            this.version = version;
            this.frame = frame;
            this.topNodes = topNodes;
        }

        public final int getVersion() {
            return this.version;
        }

        @NotNull
        public final LLFrame getFrame() {
            return this.frame;
        }

        @NotNull
        public final Set<ValueNode> getTopNodes() {
            return this.topNodes;
        }

        public final int component1() {
            return this.version;
        }

        @NotNull
        public final LLFrame component2() {
            return this.frame;
        }

        @NotNull
        public final Set<ValueNode> component3() {
            return this.topNodes;
        }

        @NotNull
        public final FrameNode copy(int version, @NotNull LLFrame frame, @NotNull Set<ValueNode> topNodes) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter(topNodes, (String)"topNodes");
            return new FrameNode(version, frame, topNodes);
        }

        public static /* synthetic */ FrameNode copy$default(FrameNode frameNode, int n, LLFrame lLFrame, Set set, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = frameNode.version;
            }
            if ((n2 & 2) != 0) {
                lLFrame = frameNode.frame;
            }
            if ((n2 & 4) != 0) {
                set = frameNode.topNodes;
            }
            return frameNode.copy(n, lLFrame, set);
        }

        @NotNull
        public String toString() {
            return "FrameNode(version=" + this.version + ", frame=" + this.frame + ", topNodes=" + this.topNodes + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.version);
            result2 = result2 * 31 + this.frame.hashCode();
            result2 = result2 * 31 + ((Object)this.topNodes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FrameNode)) {
                return false;
            }
            FrameNode frameNode = (FrameNode)other;
            if (this.version != frameNode.version) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.frame, (Object)frameNode.frame)) {
                return false;
            }
            return Intrinsics.areEqual(this.topNodes, frameNode.topNodes);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$RegisterNode;", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ValueNode;", "version", "", "value", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "data", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;", "<init>", "(ILcom/jetbrains/cidr/execution/debugger/backend/LLValue;Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;)V", "registerName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getRegisterName", "()Ljava/lang/String;", "intellij.rider.plugins.cpp"})
    private static class RegisterNode
    extends ValueNode {
        public RegisterNode(int version, @NotNull LLValue value, @NotNull LLValueData data2) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            super(version, value, data2, new LinkedHashSet());
        }

        @NotNull
        public final String getRegisterName() {
            String string = this.getValue().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$RootNode;", "", "threads", "", "", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ThreadNode;", "<init>", "(Ljava/util/Map;)V", "getThreads", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rider.plugins.cpp"})
    private static final class RootNode {
        @NotNull
        private final Map<Long, ThreadNode> threads;

        public RootNode(@NotNull Map<Long, ThreadNode> threads) {
            Intrinsics.checkNotNullParameter(threads, (String)"threads");
            this.threads = threads;
        }

        @NotNull
        public final Map<Long, ThreadNode> getThreads() {
            return this.threads;
        }

        @NotNull
        public final Map<Long, ThreadNode> component1() {
            return this.threads;
        }

        @NotNull
        public final RootNode copy(@NotNull Map<Long, ThreadNode> threads) {
            Intrinsics.checkNotNullParameter(threads, (String)"threads");
            return new RootNode(threads);
        }

        public static /* synthetic */ RootNode copy$default(RootNode rootNode, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = rootNode.threads;
            }
            return rootNode.copy(map);
        }

        @NotNull
        public String toString() {
            return "RootNode(threads=" + this.threads + ")";
        }

        public int hashCode() {
            return ((Object)this.threads).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootNode)) {
                return false;
            }
            RootNode rootNode = (RootNode)other;
            return Intrinsics.areEqual(this.threads, rootNode.threads);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ThreadNode;", "", "version", "", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frames", "", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$FrameNode;", "<init>", "(ILcom/jetbrains/cidr/execution/debugger/backend/LLThread;Ljava/util/List;)V", "getVersion", "()I", "getThread", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "getFrames", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.plugins.cpp"})
    private static final class ThreadNode {
        private final int version;
        @NotNull
        private final LLThread thread;
        @NotNull
        private final List<FrameNode> frames;

        public ThreadNode(int version, @NotNull LLThread thread, @NotNull List<FrameNode> frames2) {
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter(frames2, (String)"frames");
            this.version = version;
            this.thread = thread;
            this.frames = frames2;
        }

        public final int getVersion() {
            return this.version;
        }

        @NotNull
        public final LLThread getThread() {
            return this.thread;
        }

        @NotNull
        public final List<FrameNode> getFrames() {
            return this.frames;
        }

        public final int component1() {
            return this.version;
        }

        @NotNull
        public final LLThread component2() {
            return this.thread;
        }

        @NotNull
        public final List<FrameNode> component3() {
            return this.frames;
        }

        @NotNull
        public final ThreadNode copy(int version, @NotNull LLThread thread, @NotNull List<FrameNode> frames2) {
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter(frames2, (String)"frames");
            return new ThreadNode(version, thread, frames2);
        }

        public static /* synthetic */ ThreadNode copy$default(ThreadNode threadNode, int n, LLThread lLThread, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = threadNode.version;
            }
            if ((n2 & 2) != 0) {
                lLThread = threadNode.thread;
            }
            if ((n2 & 4) != 0) {
                list = threadNode.frames;
            }
            return threadNode.copy(n, lLThread, list);
        }

        @NotNull
        public String toString() {
            return "ThreadNode(version=" + this.version + ", thread=" + this.thread + ", frames=" + this.frames + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.version);
            result2 = result2 * 31 + this.thread.hashCode();
            result2 = result2 * 31 + ((Object)this.frames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThreadNode)) {
                return false;
            }
            ThreadNode threadNode = (ThreadNode)other;
            if (this.version != threadNode.version) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.thread, (Object)threadNode.thread)) {
                return false;
            }
            return Intrinsics.areEqual(this.frames, threadNode.frames);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0011\b\u0012\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ValueNode;", "", "version", "", "value", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "data", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;", "members", "", "<init>", "(ILcom/jetbrains/cidr/execution/debugger/backend/LLValue;Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;Ljava/util/Set;)V", "getVersion", "()I", "setVersion", "(I)V", "getValue", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "setValue", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;)V", "getData", "()Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;", "setData", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;)V", "getMembers", "()Ljava/util/Set;", "intellij.rider.plugins.cpp"})
    private static class ValueNode {
        private int version;
        @NotNull
        private LLValue value;
        @Nullable
        private LLValueData data;
        @NotNull
        private final Set<ValueNode> members;

        public ValueNode(int version, @NotNull LLValue value, @Nullable LLValueData data2, @NotNull Set<ValueNode> members) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(members, (String)"members");
            this.version = version;
            this.value = value;
            this.data = data2;
            this.members = members;
        }

        public final int getVersion() {
            return this.version;
        }

        public final void setVersion(int n) {
            this.version = n;
        }

        @NotNull
        public final LLValue getValue() {
            return this.value;
        }

        public final void setValue(@NotNull LLValue lLValue) {
            Intrinsics.checkNotNullParameter((Object)lLValue, (String)"<set-?>");
            this.value = lLValue;
        }

        @Nullable
        public final LLValueData getData() {
            return this.data;
        }

        public final void setData(@Nullable LLValueData lLValueData) {
            this.data = lLValueData;
        }

        @NotNull
        public final Set<ValueNode> getMembers() {
            return this.members;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ValuePath;", "", "threadNode", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ThreadNode;", "frameNode", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$FrameNode;", "valuesPath", "", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ValueNode;", "<init>", "(Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ThreadNode;Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$FrameNode;Ljava/util/List;)V", "getThreadNode", "()Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$ThreadNode;", "getFrameNode", "()Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore$FrameNode;", "getValuesPath", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rider.plugins.cpp"})
    private static final class ValuePath {
        @NotNull
        private final ThreadNode threadNode;
        @NotNull
        private final FrameNode frameNode;
        @NotNull
        private final List<ValueNode> valuesPath;

        public ValuePath(@NotNull ThreadNode threadNode, @NotNull FrameNode frameNode, @NotNull List<? extends ValueNode> valuesPath) {
            Intrinsics.checkNotNullParameter((Object)threadNode, (String)"threadNode");
            Intrinsics.checkNotNullParameter((Object)frameNode, (String)"frameNode");
            Intrinsics.checkNotNullParameter(valuesPath, (String)"valuesPath");
            this.threadNode = threadNode;
            this.frameNode = frameNode;
            this.valuesPath = valuesPath;
        }

        @NotNull
        public final ThreadNode getThreadNode() {
            return this.threadNode;
        }

        @NotNull
        public final FrameNode getFrameNode() {
            return this.frameNode;
        }

        @NotNull
        public final List<ValueNode> getValuesPath() {
            return this.valuesPath;
        }

        @NotNull
        public final ThreadNode component1() {
            return this.threadNode;
        }

        @NotNull
        public final FrameNode component2() {
            return this.frameNode;
        }

        @NotNull
        public final List<ValueNode> component3() {
            return this.valuesPath;
        }

        @NotNull
        public final ValuePath copy(@NotNull ThreadNode threadNode, @NotNull FrameNode frameNode, @NotNull List<? extends ValueNode> valuesPath) {
            Intrinsics.checkNotNullParameter((Object)threadNode, (String)"threadNode");
            Intrinsics.checkNotNullParameter((Object)frameNode, (String)"frameNode");
            Intrinsics.checkNotNullParameter(valuesPath, (String)"valuesPath");
            return new ValuePath(threadNode, frameNode, valuesPath);
        }

        public static /* synthetic */ ValuePath copy$default(ValuePath valuePath, ThreadNode threadNode, FrameNode frameNode, List list, int n, Object object) {
            if ((n & 1) != 0) {
                threadNode = valuePath.threadNode;
            }
            if ((n & 2) != 0) {
                frameNode = valuePath.frameNode;
            }
            if ((n & 4) != 0) {
                list = valuePath.valuesPath;
            }
            return valuePath.copy(threadNode, frameNode, list);
        }

        @NotNull
        public String toString() {
            return "ValuePath(threadNode=" + this.threadNode + ", frameNode=" + this.frameNode + ", valuesPath=" + this.valuesPath + ")";
        }

        public int hashCode() {
            int result2 = this.threadNode.hashCode();
            result2 = result2 * 31 + this.frameNode.hashCode();
            result2 = result2 * 31 + ((Object)this.valuesPath).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValuePath)) {
                return false;
            }
            ValuePath valuePath = (ValuePath)other;
            if (!Intrinsics.areEqual((Object)this.threadNode, (Object)valuePath.threadNode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.frameNode, (Object)valuePath.frameNode)) {
                return false;
            }
            return Intrinsics.areEqual(this.valuesPath, valuePath.valuesPath);
        }
    }
}

