/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.mixedMode.mono;

import com.intellij.util.io.CoroutinesKt;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeExecutionStack;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeSuspendContext;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeUtilsKt;
import com.intellij.xdebugger.mixedMode.XExecutionStackWithNativeThreadIdKt;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoNativeDebugProcess;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoTransitionedStepOutHandler;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoTransitionedStepOutHandlerKt;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MonoMixedModeLLDBDriverCommand;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MonoMixedMonoLLDBDriver;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MonoMixedMonoLLDBDriverExtKt;
import com.jetbrains.rider.debugger.util.StackFramesUtilsKt;
import com.jetbrains.rider.debugger.util.XDebugSessionUtilKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u000234B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0086@\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\"\u001a\u00020\u0013J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u000eH\u0002J \u0010&\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u000eH\u0002J.\u0010(\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020*2\u0006\u0010$\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u001e\u0010/\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020*2\f\u00100\u001a\b\u0012\u0004\u0012\u00020)01H\u0002J\u0018\u00102\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0082@\u00a2\u0006\u0002\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoTransitionedStepOutHandler;", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "nativeDebugProcess", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoNativeDebugProcess;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoNativeDebugProcess;)V", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getNativeDebugProcess", "()Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoNativeDebugProcess;", "activeSteppingThreads", "", "", "mixedStepsMap", "", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoTransitionedStepOutHandler$MixedStepData;", "mixedModeInterruptActive", "", "prepareToFutureNativeToManagedTransitionIfNeeded", "", "transitionData", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoTransitionedStepOutHandler$ManagedToNativeTransitionData;", "driver", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;", "tryHandle", "stopPlace", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "registerActiveSteppingIfNeeded", "suspendContext", "Lcom/intellij/xdebugger/impl/mixedmode/XMixedModeSuspendContext;", "(Lcom/intellij/xdebugger/impl/mixedmode/XMixedModeSuspendContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unregisterActiveSteppingIfNeeded", "mixedModeInterruptSuccessfullyFinished", "isSteppingActive", "nativeThreadId", "unregisterSteppingOnThread", "cleanUpOnStepFinish", "mixedStepData", "setBreakpoint", "", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "functionName", "", "removeBreakpoints", "ids", "", "tryFindManagedToNativeWrapperAndHighestManagedFrame", "MixedStepData", "ManagedToNativeTransitionData", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nMixedModeMonoTransitionedStepOutHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MixedModeMonoTransitionedStepOutHandler.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoTransitionedStepOutHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1563#2:295\n1634#2,3:296\n1056#2:300\n1563#2:301\n1634#2,3:302\n1563#2:305\n1634#2,3:306\n360#2,7:309\n1#3:299\n*S KotlinDebug\n*F\n+ 1 MixedModeMonoTransitionedStepOutHandler.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoTransitionedStepOutHandler\n*L\n102#1:295\n102#1:296,3\n282#1:300\n282#1:301\n282#1:302,3\n284#1:305\n284#1:306,3\n287#1:309,7\n*E\n"})
public final class MixedModeMonoTransitionedStepOutHandler {
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final MixedModeMonoNativeDebugProcess nativeDebugProcess;
    @NotNull
    private final Set<Long> activeSteppingThreads;
    @NotNull
    private final Map<Long, MixedStepData> mixedStepsMap;
    private boolean mixedModeInterruptActive;

    public MixedModeMonoTransitionedStepOutHandler(@NotNull XDebugSession session2, @NotNull MixedModeMonoNativeDebugProcess nativeDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)nativeDebugProcess), (String)"nativeDebugProcess");
        this.session = session2;
        this.nativeDebugProcess = nativeDebugProcess;
        this.activeSteppingThreads = new LinkedHashSet();
        this.mixedStepsMap = new LinkedHashMap();
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final MixedModeMonoNativeDebugProcess getNativeDebugProcess() {
        return this.nativeDebugProcess;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareToFutureNativeToManagedTransitionIfNeeded(ManagedToNativeTransitionData transitionData, MonoMixedMonoLLDBDriver driver) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        boolean bl2 = XMixedModeUtilsKt.isMixedModeHighProcessReady((XDebugSession)this.session);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = transitionData.getWrapperFrame().getThread().getTid();
        if (string == null) {
            return;
        }
        long nativeThreadId = Long.parseLong(string);
        boolean bl3 = bl = !this.mixedStepsMap.containsKey(nativeThreadId);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl4 = bl = driver.getState() == DebuggerDriver.TargetState.SUSPENDED;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        String string4 = driver.executeInterpreterCommand("jb_find_next_break_location " + nativeThreadId + " " + (transitionData.getWrapperFrame().getFrame().getIndex() + 1));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"executeInterpreterCommand(...)");
        Object object = new char[]{'\n'};
        String locations = (String)StringsKt.split$default((CharSequence)string4, (char[])object, (boolean)false, (int)0, (int)6, null).get(0);
        if (Intrinsics.areEqual((Object)locations, (Object)"NOT_FOUND")) {
            MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().error("We can't find a sequence of instruction to start to process the stepping out");
            return;
        }
        Object object2 = new char[]{' '};
        object2 = StringsKt.split$default((CharSequence)locations, (char[])object2, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        void var9_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string5 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(Address.Companion.parseHexString((String)it));
        }
        object = (List)destination$iv$iv;
        Address mov = (Address)object.get(0);
        Address test = (Address)object.get(1);
        Address call = (Address)object.get(2);
        Address address = transitionData.getWrapperFrame().getFrame().getProgramCounter();
        Intrinsics.checkNotNullExpressionValue((Object)address, (String)"getProgramCounter(...)");
        Address wrapperBreakpointAddress = address;
        int wrapperBreakpointId = MixedModeMonoTransitionedStepOutHandler.setBreakpoint$default(this, driver, nativeThreadId, wrapperBreakpointAddress, null, 8, null);
        MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Breakpoint at " + wrapperBreakpointAddress + " was set for the stepping out from native to managed code");
        Address managedFrameNextAddress = mov;
        int managedFrameNextAddressBreakpointId = MixedModeMonoTransitionedStepOutHandler.setBreakpoint$default(this, driver, nativeThreadId, managedFrameNextAddress, null, 8, null);
        MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Breakpoint at " + managedFrameNextAddress + " was set for the stepping out from native to managed code");
        Address managedFrameTestInstructionAddress = test;
        int managedFrameTestInstructionBreakpointId = MixedModeMonoTransitionedStepOutHandler.setBreakpoint$default(this, driver, nativeThreadId, managedFrameTestInstructionAddress, null, 8, null);
        MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Breakpoint at " + managedFrameTestInstructionAddress + " was set for the stepping out from native to managed code");
        Address managedFrameTrampolineCallInstructionAddress = call;
        int managedFrameTrampolineCallBreakpointId = MixedModeMonoTransitionedStepOutHandler.setBreakpoint$default(this, driver, nativeThreadId, managedFrameTrampolineCallInstructionAddress, null, 8, null);
        MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Breakpoint at " + managedFrameTrampolineCallInstructionAddress + " was set for the stepping out from native to managed code");
        this.mixedStepsMap.put(nativeThreadId, new MixedStepData(wrapperBreakpointId, wrapperBreakpointAddress, managedFrameNextAddressBreakpointId, managedFrameNextAddress, managedFrameTestInstructionBreakpointId, managedFrameTestInstructionAddress, managedFrameTrampolineCallBreakpointId, managedFrameTrampolineCallInstructionAddress, null, null, 768, null));
    }

    /*
     * Unable to fully structure code
     */
    public final boolean tryHandle(@NotNull MonoMixedMonoLLDBDriver driver, @NotNull DebuggerDriver.StopPlace stopPlace) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Trying to handle mixed mode stepping out of the frame");
        if (!XMixedModeUtilsKt.isMixedModeHighProcessReady((XDebugSession)this.session)) {
            return false;
        }
        v0 = stopPlace.thread.getTid();
        if (v0 == null) {
            return false;
        }
        eventNativeThreadId = Long.parseLong(v0);
        v1 = this.mixedStepsMap.get(eventNativeThreadId);
        if (v1 == null) {
            return false;
        }
        mixedStepData = v1;
        stage1 = Intrinsics.areEqual((Object)mixedStepData.getWrapperBreakpointAddress(), (Object)stopPlace.frame.getProgramCounter());
        stage2 = Intrinsics.areEqual((Object)mixedStepData.getManagedFrameNextAddress(), (Object)stopPlace.frame.getProgramCounter());
        stage3 = Intrinsics.areEqual((Object)mixedStepData.getManagedFrameTestInstructionAddress(), (Object)stopPlace.frame.getProgramCounter());
        stage4 = Intrinsics.areEqual((Object)mixedStepData.getManagedFrameTrampolineCallInstructionAddress(), (Object)stopPlace.frame.getProgramCounter());
        if (mixedStepData.getSuspendCurrentBreakpointId() == null) ** GOTO lbl-1000
        v2 = stopPlace.frame.getFunction();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getFunction(...)");
        if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"suspend_current", (boolean)false, (int)2, null)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = stage5 = false;
        }
        if (!(stage1 || stage2 || stage3 || stage4 || stage5)) {
            return false;
        }
        MonoMixedMonoLLDBDriverExtKt.suspendProcessIfNeeded(driver);
        if (stage1) {
            MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Stage 1");
            v4 = trapNotNeeded = this.isSteppingActive(eventNativeThreadId) == false;
            if (trapNotNeeded) {
                this.cleanUpOnStepFinish(driver, mixedStepData, eventNativeThreadId);
                MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Stage 1: Trap not needed");
                v5 = driver.executeInterpreterCommand("br list");
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"executeInterpreterCommand(...)");
                allBreakpointsOutput = v5;
                hasOtherBreakpointAtThisAddress = StringsKt.contains$default((CharSequence)allBreakpointsOutput, (CharSequence)mixedStepData.getWrapperBreakpointAddress().toString(), (boolean)false, (int)2, null);
                if (hasOtherBreakpointAtThisAddress) {
                    return false;
                }
                MonoMixedMonoLLDBDriverExtKt.resumeAndWaitSilent(driver);
                return true;
            }
            dll_name = this.nativeDebugProcess.getMonoModuleName(driver);
            v6 = driver.executeInterpreterCommand("expression {,," + dll_name + "}&ss_trampoline");
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"executeInterpreterCommand(...)");
            result = v6;
            mixedStepData.setStepTrampolineAddress(Address.Companion.parseHexString(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)result, (String)"= \u00feC", null, (int)2, null), (String)"\u00feE", null, (int)2, null)));
            driver.executeInterpreterCommand("expression {,," + dll_name + "}mono_arch_stop_single_stepping()");
            MonoMixedMonoLLDBDriverExtKt.resumeOnlyOneThread(driver, eventNativeThreadId);
        } else if (stage2) {
            MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Stage 2");
            MonoMixedMonoLLDBDriverExtKt.resumeOnlyOneThread(driver, eventNativeThreadId);
        } else if (stage3) {
            MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Stage 3");
            driver.executeInterpreterCommand("reg write r11 1");
            MonoMixedMonoLLDBDriverExtKt.resumeOnlyOneThread(driver, eventNativeThreadId);
        } else if (stage4) {
            MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Stage 4");
            driver.executeInterpreterCommand("reg write r11 " + mixedStepData.getStepTrampolineAddress());
            dll_name = this.nativeDebugProcess.getMonoModuleName(driver);
            driver.executeInterpreterCommand("expression {,," + dll_name + "}mono_arch_start_single_stepping()");
            mixedStepData.setSuspendCurrentBreakpointId(this.setBreakpoint(driver, eventNativeThreadId, null, "suspend_current"));
            MonoMixedMonoLLDBDriverExtKt.resumeOnlyOneThread(driver, eventNativeThreadId);
        } else {
            MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Stage 5");
            if (_Assertions.ENABLED && !stage5) {
                var11_12 = "Assertion failed";
                throw new AssertionError((Object)var11_12);
            }
            this.cleanUpOnStepFinish(driver, mixedStepData, eventNativeThreadId);
            MonoMixedMonoLLDBDriverExtKt.resumeOnlyOneThread(driver, eventNativeThreadId);
            Thread.sleep(100L);
            driver.mixedModePause();
            this.mixedModeInterruptActive = true;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object registerActiveSteppingIfNeeded(@NotNull XMixedModeSuspendContext suspendContext, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof registerActiveSteppingIfNeeded.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ MixedModeMonoTransitionedStepOutHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.registerActiveSteppingIfNeeded(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = suspendContext.getLowLevelDebugSuspendContext().getActiveExecutionStack();
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                nativeThreadId = XExecutionStackWithNativeThreadIdKt.getNativeThreadId((XExecutionStack)v0);
                this.activeSteppingThreads.add(Boxing.boxLong((long)nativeThreadId));
                if (this.mixedStepsMap.containsKey(Boxing.boxLong((long)nativeThreadId))) {
                    return Unit.INSTANCE;
                }
                MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Registering stepping for native thread " + nativeThreadId);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)suspendContext);
                $continuation.J$0 = nativeThreadId;
                $continuation.label = 1;
                v1 = this.tryFindManagedToNativeWrapperAndHighestManagedFrame(suspendContext, (Continuation<? super ManagedToNativeTransitionData>)$continuation);
                if (v1 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl33
            }
            case 1: {
                nativeThreadId = $continuation.J$0;
                suspendContext = (XMixedModeSuspendContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                v2 = (ManagedToNativeTransitionData)v1;
                if (v2 == null) {
                    $this$registerActiveSteppingIfNeeded_u24lambda_u240 = this;
                    $i$a$-run-MixedModeMonoTransitionedStepOutHandler$registerActiveSteppingIfNeeded$transitionData$1 = false;
                    MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Couldn't get the transition data");
                    return Unit.INSTANCE;
                }
                transitionData = v2;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)suspendContext);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)transitionData);
                $continuation.J$0 = nativeThreadId;
                $continuation.label = 2;
                v3 = this.nativeDebugProcess.postMixedModeCommand((MonoMixedModeLLDBDriverCommand<Unit>)LambdaMetafactory.metafactory(null, null, null, (Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;)Ljava/lang/Object;, registerActiveSteppingIfNeeded$lambda$1(com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoTransitionedStepOutHandler com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoTransitionedStepOutHandler$ManagedToNativeTransitionData long com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MonoMixedMonoLLDBDriver ), (Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;)Lkotlin/Unit;)((MixedModeMonoTransitionedStepOutHandler)this, (ManagedToNativeTransitionData)transitionData, (long)nativeThreadId), $continuation);
                if (v3 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl54
            }
            case 2: {
                nativeThreadId = $continuation.J$0;
                transitionData = (ManagedToNativeTransitionData)$continuation.L$1;
                suspendContext = (XMixedModeSuspendContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl54:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void unregisterActiveSteppingIfNeeded(@NotNull DebuggerDriver.StopPlace stopPlace) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        String string = stopPlace.thread.getTid();
        if (string == null) {
            return;
        }
        boolean it = bl = this.unregisterSteppingOnThread(Long.parseLong(string));
        boolean bl2 = false;
        MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info("Remove active stepping for native thread " + it);
    }

    public final boolean mixedModeInterruptSuccessfullyFinished() {
        boolean bl;
        boolean it = bl = this.mixedModeInterruptActive;
        boolean bl2 = false;
        this.mixedModeInterruptActive = false;
        return bl;
    }

    private final boolean isSteppingActive(long nativeThreadId) {
        return this.activeSteppingThreads.contains(nativeThreadId);
    }

    private final boolean unregisterSteppingOnThread(long nativeThreadId) {
        return this.activeSteppingThreads.remove(nativeThreadId);
    }

    private final void cleanUpOnStepFinish(MonoMixedMonoLLDBDriver driver, MixedStepData mixedStepData, long nativeThreadId) {
        Object[] objectArray = new Integer[]{mixedStepData.getWrapperBreakpointId(), mixedStepData.getManagedFrameNextAddressBreakpointId(), mixedStepData.getManagedFrameTestInstructionBreakpointId(), mixedStepData.getManagedFrameTrampolineCallBreakpointId()};
        List brsToDelete = CollectionsKt.mutableListOf((Object[])objectArray);
        Integer n = mixedStepData.getSuspendCurrentBreakpointId();
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            brsToDelete.add(it);
        }
        this.removeBreakpoints(driver, brsToDelete);
        this.mixedStepsMap.remove(nativeThreadId);
        this.unregisterSteppingOnThread(nativeThreadId);
    }

    private final int setBreakpoint(LLDBDriver driver, long nativeThreadId, Address address, String functionName) {
        Address address2 = address;
        String str = "br set -t " + nativeThreadId + " " + (address2 != null ? "-a " + address2 : "-n " + functionName);
        String string = driver.executeInterpreterCommand(str);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
        String output = string;
        int id = Integer.parseInt(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)output, (String)"Breakpoint ", null, (int)2, null), (String)":", null, (int)2, null));
        return id;
    }

    static /* synthetic */ int setBreakpoint$default(MixedModeMonoTransitionedStepOutHandler mixedModeMonoTransitionedStepOutHandler, LLDBDriver lLDBDriver, long l, Address address, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return mixedModeMonoTransitionedStepOutHandler.setBreakpoint(lLDBDriver, l, address, string);
    }

    private final void removeBreakpoints(LLDBDriver driver, List<Integer> ids) {
        driver.executeInterpreterCommand("br delete " + CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
    }

    /*
     * Unable to fully structure code
     */
    private final Object tryFindManagedToNativeWrapperAndHighestManagedFrame(XMixedModeSuspendContext suspendContext, Continuation<? super ManagedToNativeTransitionData> $completion) {
        if (!($completion instanceof tryFindManagedToNativeWrapperAndHighestManagedFrame.1)) ** GOTO lbl-1000
        var16_3 = $completion;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MixedModeMonoTransitionedStepOutHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MixedModeMonoTransitionedStepOutHandler.access$tryFindManagedToNativeWrapperAndHighestManagedFrame(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!XMixedModeUtilsKt.isMixedModeHighProcessReady((XDebugSession)this.session)) {
                    return null;
                }
                v0 = suspendContext.getActiveExecutionStack();
                if (v0 == null) {
                    return null;
                }
                stack = (XMixedModeExecutionStack)v0;
                if (!stack.getComputedFramesMap().isCompleted()) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)suspendContext);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)stack);
                $continuation.label = 1;
                v1 = stack.getComputedFramesMap().await((Continuation)$continuation);
                if (v1 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                stack = (XMixedModeExecutionStack)$continuation.L$1;
                suspendContext = (XMixedModeSuspendContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                $this$sortedBy$iv = ((Map)v1).entrySet();
                $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        K k = it.getKey();
                        Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.CidrStackFrame");
                        it = (Map.Entry)b;
                        Comparable comparable = Integer.valueOf(((CidrStackFrame)k).getFrame().getIndex());
                        bl = false;
                        K k2 = it.getKey();
                        Intrinsics.checkNotNull(k2, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.CidrStackFrame");
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(((CidrStackFrame)k2).getFrame().getIndex()));
                    }
                });
                $i$f$map = false;
                var7_13 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var12_21 = (Map.Entry)item$iv$iv;
                    var14_24 = destination$iv$iv;
                    $i$a$-map-MixedModeMonoTransitionedStepOutHandler$tryFindManagedToNativeWrapperAndHighestManagedFrame$sortedFrames$2 = false;
                    v2 = it.getKey();
                    Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.CidrStackFrame");
                    var14_24.add((CidrStackFrame)v2);
                }
                v3 = (List)destination$iv$iv;
                ** GOTO lbl81
            }
        }
        v4 = stack.getLowLevelExecutionStack();
        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.CidrExecutionStack");
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)suspendContext);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)stack);
        $continuation.label = 2;
        v5 = CoroutinesKt.await((Future)((Future)StackFramesUtilsKt.getStackFramesAsync((XExecutionStack)((XExecutionStack)((CidrExecutionStack)v4)), (Lifetime)XDebugSessionUtilKt.createLifetime$default((XDebugSession)this.session, null, (int)1, null))), (Continuation)$continuation);
        if (v5 == var17_5) {
            return var17_5;
        }
        ** GOTO lbl65
        {
            case 2: {
                stack = (XMixedModeExecutionStack)$continuation.L$1;
                suspendContext = (XMixedModeSuspendContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl65:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"await(...)");
                $this$map$iv = (Iterable)v5;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (XStackFrame)item$iv$iv;
                    var14_24 = destination$iv$iv;
                    $i$a$-map-MixedModeMonoTransitionedStepOutHandler$tryFindManagedToNativeWrapperAndHighestManagedFrame$sortedFrames$3 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.CidrStackFrame");
                    var14_24.add((CidrStackFrame)it);
                }
                v3 = (List)destination$iv$iv;
lbl81:
                // 2 sources

                $i$f$map = sortedFrames = v3;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (E item$iv : $this$indexOfFirst$iv) {
                    it = (CidrStackFrame)item$iv;
                    $i$a$-indexOfFirst-MixedModeMonoTransitionedStepOutHandler$tryFindManagedToNativeWrapperAndHighestManagedFrame$managedToNativeWrapperIndex$1 = false;
                    v6 = this.nativeDebugProcess.getNativeFrameDescriptionProvider();
                    v7 = it.getFrame();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getFrame(...)");
                    v8 = v6.getAvailableDescription(v7);
                    v9 = v8 != null ? v8.isTransitionWrapper() : false;
                    if (!v9) ** GOTO lbl96
                    v10 = index$iv;
                    ** GOTO lbl99
lbl96:
                    // 1 sources

                    ++index$iv;
                }
                v10 = -1;
lbl99:
                // 2 sources

                it = $this$indexOfFirst$iv = v10;
                $i$a$-also-MixedModeMonoTransitionedStepOutHandler$tryFindManagedToNativeWrapperAndHighestManagedFrame$managedToNativeWrapperIndex$2 = false;
                if (it == -1) {
                    return null;
                }
                managedToNativeWrapperIndex = $this$indexOfFirst$iv;
                if (managedToNativeWrapperIndex == 0) {
                    return null;
                }
                v11 = (CidrStackFrame)CollectionsKt.getOrNull((List)sortedFrames, (int)managedToNativeWrapperIndex);
                if (v11 == null) {
                    return null;
                }
                wrapperFrame = v11;
                return new ManagedToNativeTransitionData(wrapperFrame);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit registerActiveSteppingIfNeeded$lambda$1(MixedModeMonoTransitionedStepOutHandler this$0, ManagedToNativeTransitionData $transitionData, long $nativeThreadId, MonoMixedMonoLLDBDriver driver) {
        Intrinsics.checkNotNullParameter((Object)((Object)driver), (String)"driver");
        MonoMixedMonoLLDBDriverExtKt.withSuspendedProcess$default(driver, false, () -> MixedModeMonoTransitionedStepOutHandler.registerActiveSteppingIfNeeded$lambda$1$0(this$0, $transitionData, driver, $nativeThreadId), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerActiveSteppingIfNeeded$lambda$1$0(MixedModeMonoTransitionedStepOutHandler this$0, ManagedToNativeTransitionData $transitionData, MonoMixedMonoLLDBDriver $driver, long $nativeThreadId) {
        Intrinsics.checkNotNull((Object)((Object)$driver));
        this$0.prepareToFutureNativeToManagedTransitionIfNeeded($transitionData, $driver);
        MixedModeMonoTransitionedStepOutHandlerKt.access$getLOG$p().info($nativeThreadId + " is prepared for stepping out from native to managed code");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$tryFindManagedToNativeWrapperAndHighestManagedFrame(MixedModeMonoTransitionedStepOutHandler $this, XMixedModeSuspendContext suspendContext, Continuation $completion) {
        return $this.tryFindManagedToNativeWrapperAndHighestManagedFrame(suspendContext, (Continuation<? super ManagedToNativeTransitionData>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoTransitionedStepOutHandler$ManagedToNativeTransitionData;", "", "wrapperFrame", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;)V", "getWrapperFrame", "()Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rider.plugins.cpp"})
    public static final class ManagedToNativeTransitionData {
        @NotNull
        private final CidrStackFrame wrapperFrame;

        public ManagedToNativeTransitionData(@NotNull CidrStackFrame wrapperFrame) {
            Intrinsics.checkNotNullParameter((Object)wrapperFrame, (String)"wrapperFrame");
            this.wrapperFrame = wrapperFrame;
        }

        @NotNull
        public final CidrStackFrame getWrapperFrame() {
            return this.wrapperFrame;
        }

        @NotNull
        public final CidrStackFrame component1() {
            return this.wrapperFrame;
        }

        @NotNull
        public final ManagedToNativeTransitionData copy(@NotNull CidrStackFrame wrapperFrame) {
            Intrinsics.checkNotNullParameter((Object)wrapperFrame, (String)"wrapperFrame");
            return new ManagedToNativeTransitionData(wrapperFrame);
        }

        public static /* synthetic */ ManagedToNativeTransitionData copy$default(ManagedToNativeTransitionData managedToNativeTransitionData, CidrStackFrame cidrStackFrame, int n, Object object) {
            if ((n & 1) != 0) {
                cidrStackFrame = managedToNativeTransitionData.wrapperFrame;
            }
            return managedToNativeTransitionData.copy(cidrStackFrame);
        }

        @NotNull
        public String toString() {
            return "ManagedToNativeTransitionData(wrapperFrame=" + this.wrapperFrame + ")";
        }

        public int hashCode() {
            return this.wrapperFrame.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ManagedToNativeTransitionData)) {
                return false;
            }
            ManagedToNativeTransitionData managedToNativeTransitionData = (ManagedToNativeTransitionData)other;
            return Intrinsics.areEqual((Object)this.wrapperFrame, (Object)managedToNativeTransitionData.wrapperFrame);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010+\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJv\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\u0003H\u00d6\u0001J\t\u00102\u001a\u000203H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00064"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoTransitionedStepOutHandler$MixedStepData;", "", "wrapperBreakpointId", "", "wrapperBreakpointAddress", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "managedFrameNextAddressBreakpointId", "managedFrameNextAddress", "managedFrameTestInstructionBreakpointId", "managedFrameTestInstructionAddress", "managedFrameTrampolineCallBreakpointId", "managedFrameTrampolineCallInstructionAddress", "stepTrampolineAddress", "suspendCurrentBreakpointId", "<init>", "(ILcom/jetbrains/cidr/execution/debugger/memory/Address;ILcom/jetbrains/cidr/execution/debugger/memory/Address;ILcom/jetbrains/cidr/execution/debugger/memory/Address;ILcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/lang/Integer;)V", "getWrapperBreakpointId", "()I", "getWrapperBreakpointAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getManagedFrameNextAddressBreakpointId", "getManagedFrameNextAddress", "getManagedFrameTestInstructionBreakpointId", "getManagedFrameTestInstructionAddress", "getManagedFrameTrampolineCallBreakpointId", "getManagedFrameTrampolineCallInstructionAddress", "getStepTrampolineAddress", "setStepTrampolineAddress", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;)V", "getSuspendCurrentBreakpointId", "()Ljava/lang/Integer;", "setSuspendCurrentBreakpointId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "(ILcom/jetbrains/cidr/execution/debugger/memory/Address;ILcom/jetbrains/cidr/execution/debugger/memory/Address;ILcom/jetbrains/cidr/execution/debugger/memory/Address;ILcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/lang/Integer;)Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoTransitionedStepOutHandler$MixedStepData;", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.plugins.cpp"})
    private static final class MixedStepData {
        private final int wrapperBreakpointId;
        @NotNull
        private final Address wrapperBreakpointAddress;
        private final int managedFrameNextAddressBreakpointId;
        @NotNull
        private final Address managedFrameNextAddress;
        private final int managedFrameTestInstructionBreakpointId;
        @NotNull
        private final Address managedFrameTestInstructionAddress;
        private final int managedFrameTrampolineCallBreakpointId;
        @NotNull
        private final Address managedFrameTrampolineCallInstructionAddress;
        @Nullable
        private Address stepTrampolineAddress;
        @Nullable
        private Integer suspendCurrentBreakpointId;

        public MixedStepData(int wrapperBreakpointId, @NotNull Address wrapperBreakpointAddress, int managedFrameNextAddressBreakpointId, @NotNull Address managedFrameNextAddress, int managedFrameTestInstructionBreakpointId, @NotNull Address managedFrameTestInstructionAddress, int managedFrameTrampolineCallBreakpointId, @NotNull Address managedFrameTrampolineCallInstructionAddress, @Nullable Address stepTrampolineAddress, @Nullable Integer suspendCurrentBreakpointId) {
            Intrinsics.checkNotNullParameter((Object)wrapperBreakpointAddress, (String)"wrapperBreakpointAddress");
            Intrinsics.checkNotNullParameter((Object)managedFrameNextAddress, (String)"managedFrameNextAddress");
            Intrinsics.checkNotNullParameter((Object)managedFrameTestInstructionAddress, (String)"managedFrameTestInstructionAddress");
            Intrinsics.checkNotNullParameter((Object)managedFrameTrampolineCallInstructionAddress, (String)"managedFrameTrampolineCallInstructionAddress");
            this.wrapperBreakpointId = wrapperBreakpointId;
            this.wrapperBreakpointAddress = wrapperBreakpointAddress;
            this.managedFrameNextAddressBreakpointId = managedFrameNextAddressBreakpointId;
            this.managedFrameNextAddress = managedFrameNextAddress;
            this.managedFrameTestInstructionBreakpointId = managedFrameTestInstructionBreakpointId;
            this.managedFrameTestInstructionAddress = managedFrameTestInstructionAddress;
            this.managedFrameTrampolineCallBreakpointId = managedFrameTrampolineCallBreakpointId;
            this.managedFrameTrampolineCallInstructionAddress = managedFrameTrampolineCallInstructionAddress;
            this.stepTrampolineAddress = stepTrampolineAddress;
            this.suspendCurrentBreakpointId = suspendCurrentBreakpointId;
        }

        public /* synthetic */ MixedStepData(int n, Address address, int n2, Address address2, int n3, Address address3, int n4, Address address4, Address address5, Integer n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 0x100) != 0) {
                address5 = null;
            }
            if ((n6 & 0x200) != 0) {
                n5 = null;
            }
            this(n, address, n2, address2, n3, address3, n4, address4, address5, n5);
        }

        public final int getWrapperBreakpointId() {
            return this.wrapperBreakpointId;
        }

        @NotNull
        public final Address getWrapperBreakpointAddress() {
            return this.wrapperBreakpointAddress;
        }

        public final int getManagedFrameNextAddressBreakpointId() {
            return this.managedFrameNextAddressBreakpointId;
        }

        @NotNull
        public final Address getManagedFrameNextAddress() {
            return this.managedFrameNextAddress;
        }

        public final int getManagedFrameTestInstructionBreakpointId() {
            return this.managedFrameTestInstructionBreakpointId;
        }

        @NotNull
        public final Address getManagedFrameTestInstructionAddress() {
            return this.managedFrameTestInstructionAddress;
        }

        public final int getManagedFrameTrampolineCallBreakpointId() {
            return this.managedFrameTrampolineCallBreakpointId;
        }

        @NotNull
        public final Address getManagedFrameTrampolineCallInstructionAddress() {
            return this.managedFrameTrampolineCallInstructionAddress;
        }

        @Nullable
        public final Address getStepTrampolineAddress() {
            return this.stepTrampolineAddress;
        }

        public final void setStepTrampolineAddress(@Nullable Address address) {
            this.stepTrampolineAddress = address;
        }

        @Nullable
        public final Integer getSuspendCurrentBreakpointId() {
            return this.suspendCurrentBreakpointId;
        }

        public final void setSuspendCurrentBreakpointId(@Nullable Integer n) {
            this.suspendCurrentBreakpointId = n;
        }

        public final int component1() {
            return this.wrapperBreakpointId;
        }

        @NotNull
        public final Address component2() {
            return this.wrapperBreakpointAddress;
        }

        public final int component3() {
            return this.managedFrameNextAddressBreakpointId;
        }

        @NotNull
        public final Address component4() {
            return this.managedFrameNextAddress;
        }

        public final int component5() {
            return this.managedFrameTestInstructionBreakpointId;
        }

        @NotNull
        public final Address component6() {
            return this.managedFrameTestInstructionAddress;
        }

        public final int component7() {
            return this.managedFrameTrampolineCallBreakpointId;
        }

        @NotNull
        public final Address component8() {
            return this.managedFrameTrampolineCallInstructionAddress;
        }

        @Nullable
        public final Address component9() {
            return this.stepTrampolineAddress;
        }

        @Nullable
        public final Integer component10() {
            return this.suspendCurrentBreakpointId;
        }

        @NotNull
        public final MixedStepData copy(int wrapperBreakpointId, @NotNull Address wrapperBreakpointAddress, int managedFrameNextAddressBreakpointId, @NotNull Address managedFrameNextAddress, int managedFrameTestInstructionBreakpointId, @NotNull Address managedFrameTestInstructionAddress, int managedFrameTrampolineCallBreakpointId, @NotNull Address managedFrameTrampolineCallInstructionAddress, @Nullable Address stepTrampolineAddress, @Nullable Integer suspendCurrentBreakpointId) {
            Intrinsics.checkNotNullParameter((Object)wrapperBreakpointAddress, (String)"wrapperBreakpointAddress");
            Intrinsics.checkNotNullParameter((Object)managedFrameNextAddress, (String)"managedFrameNextAddress");
            Intrinsics.checkNotNullParameter((Object)managedFrameTestInstructionAddress, (String)"managedFrameTestInstructionAddress");
            Intrinsics.checkNotNullParameter((Object)managedFrameTrampolineCallInstructionAddress, (String)"managedFrameTrampolineCallInstructionAddress");
            return new MixedStepData(wrapperBreakpointId, wrapperBreakpointAddress, managedFrameNextAddressBreakpointId, managedFrameNextAddress, managedFrameTestInstructionBreakpointId, managedFrameTestInstructionAddress, managedFrameTrampolineCallBreakpointId, managedFrameTrampolineCallInstructionAddress, stepTrampolineAddress, suspendCurrentBreakpointId);
        }

        public static /* synthetic */ MixedStepData copy$default(MixedStepData mixedStepData, int n, Address address, int n2, Address address2, int n3, Address address3, int n4, Address address4, Address address5, Integer n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = mixedStepData.wrapperBreakpointId;
            }
            if ((n6 & 2) != 0) {
                address = mixedStepData.wrapperBreakpointAddress;
            }
            if ((n6 & 4) != 0) {
                n2 = mixedStepData.managedFrameNextAddressBreakpointId;
            }
            if ((n6 & 8) != 0) {
                address2 = mixedStepData.managedFrameNextAddress;
            }
            if ((n6 & 0x10) != 0) {
                n3 = mixedStepData.managedFrameTestInstructionBreakpointId;
            }
            if ((n6 & 0x20) != 0) {
                address3 = mixedStepData.managedFrameTestInstructionAddress;
            }
            if ((n6 & 0x40) != 0) {
                n4 = mixedStepData.managedFrameTrampolineCallBreakpointId;
            }
            if ((n6 & 0x80) != 0) {
                address4 = mixedStepData.managedFrameTrampolineCallInstructionAddress;
            }
            if ((n6 & 0x100) != 0) {
                address5 = mixedStepData.stepTrampolineAddress;
            }
            if ((n6 & 0x200) != 0) {
                n5 = mixedStepData.suspendCurrentBreakpointId;
            }
            return mixedStepData.copy(n, address, n2, address2, n3, address3, n4, address4, address5, n5);
        }

        @NotNull
        public String toString() {
            return "MixedStepData(wrapperBreakpointId=" + this.wrapperBreakpointId + ", wrapperBreakpointAddress=" + this.wrapperBreakpointAddress + ", managedFrameNextAddressBreakpointId=" + this.managedFrameNextAddressBreakpointId + ", managedFrameNextAddress=" + this.managedFrameNextAddress + ", managedFrameTestInstructionBreakpointId=" + this.managedFrameTestInstructionBreakpointId + ", managedFrameTestInstructionAddress=" + this.managedFrameTestInstructionAddress + ", managedFrameTrampolineCallBreakpointId=" + this.managedFrameTrampolineCallBreakpointId + ", managedFrameTrampolineCallInstructionAddress=" + this.managedFrameTrampolineCallInstructionAddress + ", stepTrampolineAddress=" + this.stepTrampolineAddress + ", suspendCurrentBreakpointId=" + this.suspendCurrentBreakpointId + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.wrapperBreakpointId);
            result2 = result2 * 31 + this.wrapperBreakpointAddress.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.managedFrameNextAddressBreakpointId);
            result2 = result2 * 31 + this.managedFrameNextAddress.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.managedFrameTestInstructionBreakpointId);
            result2 = result2 * 31 + this.managedFrameTestInstructionAddress.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.managedFrameTrampolineCallBreakpointId);
            result2 = result2 * 31 + this.managedFrameTrampolineCallInstructionAddress.hashCode();
            result2 = result2 * 31 + (this.stepTrampolineAddress == null ? 0 : this.stepTrampolineAddress.hashCode());
            result2 = result2 * 31 + (this.suspendCurrentBreakpointId == null ? 0 : ((Object)this.suspendCurrentBreakpointId).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MixedStepData)) {
                return false;
            }
            MixedStepData mixedStepData = (MixedStepData)other;
            if (this.wrapperBreakpointId != mixedStepData.wrapperBreakpointId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wrapperBreakpointAddress, (Object)mixedStepData.wrapperBreakpointAddress)) {
                return false;
            }
            if (this.managedFrameNextAddressBreakpointId != mixedStepData.managedFrameNextAddressBreakpointId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.managedFrameNextAddress, (Object)mixedStepData.managedFrameNextAddress)) {
                return false;
            }
            if (this.managedFrameTestInstructionBreakpointId != mixedStepData.managedFrameTestInstructionBreakpointId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.managedFrameTestInstructionAddress, (Object)mixedStepData.managedFrameTestInstructionAddress)) {
                return false;
            }
            if (this.managedFrameTrampolineCallBreakpointId != mixedStepData.managedFrameTrampolineCallBreakpointId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.managedFrameTrampolineCallInstructionAddress, (Object)mixedStepData.managedFrameTrampolineCallInstructionAddress)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stepTrampolineAddress, (Object)mixedStepData.stepTrampolineAddress)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.suspendCurrentBreakpointId, (Object)mixedStepData.suspendCurrentBreakpointId);
        }
    }
}

