/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.mixedMode.mono;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.mixedmode.MixedModeStateMachineBase;
import com.intellij.xdebugger.mixedMode.XMixedModeHighLevelDebugProcessExtension;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.cpp.debugger.MixedModeMonoLLDBDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.RiderCppDebugProcessStarter;
import com.jetbrains.rider.cpp.debugger.mixedMode.dotnet.win.MixedModeDotnetLLDBDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.mixedMode.dotnet.win.MixedModeDotnetOnWinNativeDebugProcess;
import com.jetbrains.rider.cpp.debugger.mixedMode.dotnet.win.MixedModeDotnetOnWinStateMachine;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoNativeDebugProcess;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoStateMachine;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.debugger.IMixedModeDebugAwareRunProfile;
import com.jetbrains.rider.debugger.attach.RiderAttachConfiguration;
import com.jetbrains.rider.debugger.mixed.mode.MixedModeDebugProcessStarter;
import com.jetbrains.rider.debugger.mixed.mode.MixedModeDotnetOnWinExtension;
import com.jetbrains.rider.debugger.mixed.mode.MixedModeMonoExtension;
import com.jetbrains.rider.debugger.targets.BundledAssemblyLauncherKt;
import com.jetbrains.rider.debugger.util.DebuggerWorkerProcessHandlerUtilKt;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfiguration;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfiguration;
import com.jetbrains.rider.run.configurations.remote.MonoAttachConfiguration;
import com.jetbrains.rider.run.configurations.unity.UnityAttachRunConfiguration;
import com.jetbrains.rider.run.msNet.MsNetAttachRunProfile;
import com.jetbrains.rider.runtime.mono.MonoRuntimeType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoDebugProcessStarter;", "Lcom/jetbrains/rider/debugger/mixed/mode/MixedModeDebugProcessStarter;", "<init>", "()V", "startNativeDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "runProfile", "Lcom/jetbrains/rider/debugger/IMixedModeDebugAwareRunProfile;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "sessionId", "", "createManagedDebugProcessExtension", "Lcom/intellij/xdebugger/mixedMode/XMixedModeHighLevelDebugProcessExtension;", "createMixedModeDebugStateMachine", "Lcom/intellij/xdebugger/impl/mixedmode/MixedModeStateMachineBase;", "lowDebugProcess", "highDebugProcess", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "tryGetDebuggeePid", "", "debuggerWorkerProcessHandler", "(Lcom/jetbrains/rider/debugger/IMixedModeDebugAwareRunProfile;Lcom/intellij/execution/process/ProcessHandler;)Ljava/lang/Integer;", "isMonoMixedMode", "", "intellij.rider.plugins.cpp"})
public final class MixedModeMonoDebugProcessStarter
implements MixedModeDebugProcessStarter {
    @NotNull
    public XDebugProcess startNativeDebugProcess(@NotNull IMixedModeDebugAwareRunProfile runProfile, @NotNull ProcessHandler processHandler, @NotNull XDebugSession session2, @NotNull TextConsoleBuilder consoleBuilder, long sessionId) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        if (!this.isMonoMixedMode(runProfile)) {
            ArchitectureType architecture = StringsKt.contains$default((CharSequence)((DebuggerWorkerProcessHandler)processHandler).getPresentableCommandLine(), (CharSequence)BundledAssemblyLauncherKt.getDEBUGGER_WORKER_LAUNCHER().getLauncher(CPUKind.Win32).getAssemblyName(), (boolean)false, (int)2, null) ? ArchitectureType.I386 : ArchitectureType.X86_64;
            MixedModeDotnetOnWinNativeDebugProcess process = new MixedModeDotnetOnWinNativeDebugProcess((DebuggerDriverConfiguration)new MixedModeDotnetLLDBDriverConfiguration(architecture), session2, consoleBuilder, sessionId);
            return (XDebugProcess)process;
        }
        Integer n = this.tryGetDebuggeePid(runProfile, processHandler);
        if (n == null) {
            throw new IllegalStateException("Not Supported".toString());
        }
        int pid = n;
        MixedModeMonoNativeDebugProcess process = new MixedModeMonoNativeDebugProcess((DebuggerDriverConfiguration)new MixedModeMonoLLDBDriverConfiguration(pid), pid, session2, consoleBuilder, sessionId);
        RiderCppDebugProcessStarter.Companion.startProcess(process);
        process.loadScripts();
        return (XDebugProcess)process;
    }

    @NotNull
    public XMixedModeHighLevelDebugProcessExtension createManagedDebugProcessExtension(@NotNull IMixedModeDebugAwareRunProfile runProfile, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        if (!this.isMonoMixedMode(runProfile)) {
            return (XMixedModeHighLevelDebugProcessExtension)new MixedModeDotnetOnWinExtension();
        }
        if (this.tryGetDebuggeePid(runProfile, processHandler) == null) {
            throw new IllegalStateException("Mono mixed mode debug is not supported for this configuration".toString());
        }
        return (XMixedModeHighLevelDebugProcessExtension)new MixedModeMonoExtension();
    }

    @NotNull
    public MixedModeStateMachineBase createMixedModeDebugStateMachine(@NotNull IMixedModeDebugAwareRunProfile runProfile, @NotNull XDebugProcess lowDebugProcess, @NotNull XDebugProcess highDebugProcess, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)lowDebugProcess, (String)"lowDebugProcess");
        Intrinsics.checkNotNullParameter((Object)highDebugProcess, (String)"highDebugProcess");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        return this.isMonoMixedMode(runProfile) ? (MixedModeStateMachineBase)new MixedModeMonoStateMachine(lowDebugProcess, highDebugProcess, coroutineScope) : (MixedModeStateMachineBase)new MixedModeDotnetOnWinStateMachine(lowDebugProcess, highDebugProcess, coroutineScope);
    }

    private final Integer tryGetDebuggeePid(IMixedModeDebugAwareRunProfile runProfile, ProcessHandler debuggerWorkerProcessHandler) {
        Integer n;
        IMixedModeDebugAwareRunProfile iMixedModeDebugAwareRunProfile = runProfile;
        if (iMixedModeDebugAwareRunProfile instanceof MonoAttachConfiguration) {
            n = ((MonoAttachConfiguration)runProfile).getProcessInfo().getPid();
        } else if (iMixedModeDebugAwareRunProfile instanceof UnityAttachRunConfiguration) {
            n = ((UnityAttachRunConfiguration)runProfile).getUnityEditorPid();
            if (n == null) {
                n = DebuggerWorkerProcessHandlerUtilKt.tryGetTargetProcessId((ProcessHandler)debuggerWorkerProcessHandler);
            }
        } else {
            n = DebuggerWorkerProcessHandlerUtilKt.tryGetTargetProcessId((ProcessHandler)debuggerWorkerProcessHandler);
        }
        return n;
    }

    private final boolean isMonoMixedMode(IMixedModeDebugAwareRunProfile runProfile) {
        IMixedModeDebugAwareRunProfile iMixedModeDebugAwareRunProfile = runProfile;
        return iMixedModeDebugAwareRunProfile instanceof DotNetExeConfiguration ? Intrinsics.areEqual((Object)((DotNetExeConfiguration)runProfile).getParameters().getRuntimeType(), (Object)MonoRuntimeType.INSTANCE) : (iMixedModeDebugAwareRunProfile instanceof DotNetProjectConfiguration ? Intrinsics.areEqual((Object)((DotNetProjectConfiguration)runProfile).getParameters().getRuntimeType(), (Object)MonoRuntimeType.INSTANCE) : (iMixedModeDebugAwareRunProfile instanceof LaunchSettingsConfiguration ? Intrinsics.areEqual((Object)((LaunchSettingsConfiguration)runProfile).getParameters().getRuntimeType(), (Object)MonoRuntimeType.INSTANCE) : (iMixedModeDebugAwareRunProfile instanceof RiderAttachConfiguration ? false : !(iMixedModeDebugAwareRunProfile instanceof MsNetAttachRunProfile))));
    }
}

