/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.mixedMode;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeSuspendContextKt;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeUtilsKt;
import com.intellij.xdebugger.mixedMode.XMixedModeDebugProcessExtension;
import com.intellij.xdebugger.mixedMode.XMixedModeLowLevelDebugProcessExtension;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrAlternativeSourceHandler;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspendContext;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.RiderCppLocalAttachedDebugProcess;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeAlternativeSourceHandler;
import com.jetbrains.rider.debugger.mixed.mode.NativeDebugProcessInMixedModeDebuggingPair;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\r\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b H\u0014J\b\u0010!\u001a\u00020\u001fH\u0007J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020%H\u0014R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/MixedModeNativeDebugProcessBase;", "Lcom/jetbrains/rider/cpp/debugger/RiderCppLocalAttachedDebugProcess;", "Lcom/intellij/xdebugger/mixedMode/XMixedModeLowLevelDebugProcessExtension;", "Lcom/jetbrains/rider/debugger/mixed/mode/NativeDebugProcessInMixedModeDebuggingPair;", "driverConfiguration", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "sessionId", "", "pid", "", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/execution/filters/TextConsoleBuilder;JI)V", "firstResumeHappened", "", "getStoppedThreadId", "context", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "belongsToMe", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCurrentThreadId", "getCurrentFrameIndex", "createAlternativeSourceHandler", "Lcom/jetbrains/cidr/execution/debugger/CidrAlternativeSourceHandler;", "getMemoryViewTabName", "", "Lorg/jetbrains/annotations/Nls;", "getTabPostfix", "getMixedModeDebugProcessExtension", "Lcom/intellij/xdebugger/mixedMode/XMixedModeDebugProcessExtension;", "sessionResumed", "", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nMixedModeNativeDebugProcessBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MixedModeNativeDebugProcessBase.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/MixedModeNativeDebugProcessBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public abstract class MixedModeNativeDebugProcessBase
extends RiderCppLocalAttachedDebugProcess
implements XMixedModeLowLevelDebugProcessExtension,
NativeDebugProcessInMixedModeDebuggingPair {
    private boolean firstResumeHappened;

    public MixedModeNativeDebugProcessBase(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull XDebugSession session2, @NotNull TextConsoleBuilder consoleBuilder, long sessionId, int pid) {
        Intrinsics.checkNotNullParameter((Object)driverConfiguration, (String)"driverConfiguration");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        super(driverConfiguration, pid, session2, consoleBuilder, sessionId);
    }

    public long getStoppedThreadId(@NotNull XSuspendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = ((CidrSuspendContext)context).getCurrentExecutionStack().getThread().getTid();
        if (string == null) {
            boolean bl = false;
            String string2 = "Couldn't find tid of action thread";
            throw new IllegalStateException(string2.toString());
        }
        String tid = string;
        return Long.parseLong(tid);
    }

    public boolean belongsToMe(@NotNull XStackFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return frame instanceof CidrStackFrame;
    }

    public boolean belongsToMe(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        return !XMixedModeUtilsKt.getHighLevelMixedModeExtension((XDebugSession)xDebugSession).belongsToMe(file);
    }

    public long getCurrentThreadId() {
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        if (!XMixedModeUtilsKt.isMixedModeHighProcessReady((XDebugSession)xDebugSession)) {
            return super.getCurrentThreadId();
        }
        XSuspendContext xSuspendContext = this.getSession().getSuspendContext();
        if (xSuspendContext != null) {
            XSuspendContext it = xSuspendContext;
            boolean bl = false;
            XExecutionStack xExecutionStack = XMixedModeSuspendContextKt.mixedActiveStack((XSuspendContext)it).getLowLevelExecutionStack();
            Intrinsics.checkNotNull((Object)xExecutionStack, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.CidrExecutionStack");
            return ((CidrExecutionStack)xExecutionStack).getThread().getId();
        }
        return -1L;
    }

    public int getCurrentFrameIndex() {
        int n;
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        if (!XMixedModeUtilsKt.isMixedModeHighProcessReady((XDebugSession)xDebugSession)) {
            return super.getCurrentFrameIndex();
        }
        XStackFrame xStackFrame = this.getSession().getCurrentStackFrame();
        if (xStackFrame == null) {
            return -1;
        }
        XStackFrame currentFrame = xStackFrame;
        XSuspendContext xSuspendContext = this.getSession().getSuspendContext();
        if (xSuspendContext == null || (xSuspendContext = XMixedModeSuspendContextKt.mixedActiveStack((XSuspendContext)xSuspendContext)) == null || (xSuspendContext = xSuspendContext.getComputedFramesMap()) == null) {
            throw new IllegalStateException("We expect mixed frames map to be computed at this point".toString());
        }
        XSuspendContext framesMapDeferred = xSuspendContext;
        if (!framesMapDeferred.isCompleted()) {
            return -1;
        }
        Map framesMap = (Map)framesMapDeferred.getCompleted();
        Integer n2 = CollectionsKt.indexOf((Iterable)framesMap.keySet(), (Object)currentFrame);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it >= 0 ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            Integer n4 = CollectionsKt.indexOf((Iterable)framesMap.values(), (Object)currentFrame);
            int it2 = ((Number)n4).intValue();
            boolean bl2 = false;
            Integer n5 = it2 >= 0 ? n4 : null;
            if (n5 != null) {
                n = n5;
            } else {
                throw new IllegalStateException("Couldn't find frame".toString());
            }
        }
        return n;
    }

    @NotNull
    protected CidrAlternativeSourceHandler createAlternativeSourceHandler(@NotNull XDebugSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        CoroutineScope coroutineScope = this.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        return new MixedModeAlternativeSourceHandler(session2, coroutineScope);
    }

    public boolean belongsToMe(@NotNull XSuspendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context instanceof CidrSuspendContext;
    }

    @NotNull
    protected String getMemoryViewTabName() {
        return CidrDebuggerBundle.message((String)"debug.memory.view.process", (Object[])new Object[0]) + this.getTabPostfix();
    }

    @NlsSafe
    @NotNull
    public final String getTabPostfix() {
        return " (LLDB)";
    }

    @Nullable
    public XMixedModeDebugProcessExtension getMixedModeDebugProcessExtension() {
        return (XMixedModeDebugProcessExtension)this;
    }

    protected void sessionResumed() {
        if (this.firstResumeHappened) {
            XDebugSession xDebugSession = this.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
            XMixedModeUtilsKt.mixedModeSessionResumed((XDebugSession)xDebugSession, (boolean)true);
            return;
        }
        this.getSession().sessionResumed();
        this.firstResumeHappened = true;
    }
}

