/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.editorNotifiers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.cpp.RiderCppBundle;
import com.jetbrains.rider.cpp.debugger.CppDebugSessionData;
import com.jetbrains.rider.cpp.debugger.editorNotifiers.RiderCppMacSymbolsNotifierKt;
import com.jetbrains.rider.ui.RiderEditorNotifier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/cpp/debugger/editorNotifiers/UseMacDebugSymbolsPromoter;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "tryPromoteUseMacDebugSymbols", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "showMacDebugSymbolsPromotionNotification", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getNotifier", "Lcom/jetbrains/rider/ui/RiderEditorNotifier;", "shouldPromoteDebugSymbols", "", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nRiderCppMacSymbolsNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppMacSymbolsNotifier.kt\ncom/jetbrains/rider/cpp/debugger/editorNotifiers/UseMacDebugSymbolsPromoter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n1#2:156\n23#3:157\n*S KotlinDebug\n*F\n+ 1 RiderCppMacSymbolsNotifier.kt\ncom/jetbrains/rider/cpp/debugger/editorNotifiers/UseMacDebugSymbolsPromoter\n*L\n30#1:157\n*E\n"})
public final class UseMacDebugSymbolsPromoter {
    @NotNull
    public static final UseMacDebugSymbolsPromoter INSTANCE;
    @NotNull
    private static final Logger logger;

    private UseMacDebugSymbolsPromoter() {
    }

    public final void tryPromoteUseMacDebugSymbols(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        if (!this.shouldPromoteDebugSymbols()) {
            return;
        }
        XDebugSession xDebugSession = process.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession session2 = xDebugSession;
        session2.addSessionListener(new XDebugSessionListener(process, session2){
            final /* synthetic */ CidrDebugProcess $process;
            final /* synthetic */ XDebugSession $session;
            {
                this.$process = $process;
                this.$session = $session;
            }

            public void sessionPaused() {
                UseMacDebugSymbolsPromoter.access$getLogger$p().trace("Session paused");
                if (!RiderCppMacSymbolsNotifierKt.access$getOneOfModulesHasSymbolFile(this.$process)) {
                    return;
                }
                if (!UseMacDebugSymbolsPromoter.access$shouldPromoteDebugSymbols(UseMacDebugSymbolsPromoter.INSTANCE)) {
                    return;
                }
                Lifetime lifetime = CppDebugSessionData.Companion.getSessionLifetime(this.$process);
                Project project = this.$process.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
                UseMacDebugSymbolsPromoter.access$showMacDebugSymbolsPromotionNotification(UseMacDebugSymbolsPromoter.INSTANCE, lifetime, project, this.$session);
            }
        });
    }

    private final void showMacDebugSymbolsPromotionNotification(Lifetime lifetime, Project project, XDebugSession session2) {
        Object v1;
        block3: {
            XSourcePosition xSourcePosition = session2.getCurrentPosition();
            if (xSourcePosition == null) {
                return;
            }
            XSourcePosition pos = xSourcePosition;
            FrontendTextControlHost textControlHost = FrontendTextControlHost.Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession((Project)project).getAppSession());
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)textControlHost.getEditors()), arg_0 -> UseMacDebugSymbolsPromoter.showMacDebugSymbolsPromotionNotification$lambda$0(project, arg_0));
            for (Object e : sequence) {
                Editor editor = (Editor)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)editor.getVirtualFile(), (Object)pos.getFile())) continue;
                v1 = e;
                break block3;
            }
            v1 = null;
        }
        Editor editor = v1;
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        TextEditor textEditor = TextEditorProvider.Companion.getInstance().getTextEditor(editor2);
        this.getNotifier(lifetime, project).showNotification(textEditor);
    }

    private final RiderEditorNotifier getNotifier(Lifetime lifetime, Project project) {
        RiderEditorNotifier riderEditorNotifier;
        RiderEditorNotifier $this$getNotifier_u24lambda_u240 = riderEditorNotifier = new RiderEditorNotifier(project, lifetime);
        boolean bl = false;
        $this$getNotifier_u24lambda_u240.setPanelText(RiderCppBundle.Companion.message("cpp.debugger.promote.dsym.loading.message", new Object[0]));
        $this$getNotifier_u24lambda_u240.setKeyName("PromoteDSymLoad");
        String string = CidrDebuggerBundle.message((String)"debug.settings.macOS.load.dsym.near.binaries", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        RiderEditorNotifier.defineSettingsAction$default((RiderEditorNotifier)$this$getNotifier_u24lambda_u240, null, (String)"Debugger.C.SymbolServers", (String)string, (boolean)true, null, (int)17, null);
        RiderEditorNotifier.defineDontShowAgainAction$default((RiderEditorNotifier)$this$getNotifier_u24lambda_u240, null, UseMacDebugSymbolsPromoter::getNotifier$lambda$0$0, (int)1, null);
        RiderEditorNotifier.defineHideAction$default((RiderEditorNotifier)$this$getNotifier_u24lambda_u240, null, null, (int)3, null);
        return riderEditorNotifier;
    }

    private final boolean shouldPromoteDebugSymbols() {
        boolean bl;
        CidrDebuggerSettings cidrDebuggerSettings = CidrDebuggerSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebuggerSettings, (String)"getInstance(...)");
        CidrDebuggerSettings settings = cidrDebuggerSettings;
        if (!SystemInfo.isMac) {
            logger.trace("Don't promote 'loadDSymNearBinaries' on non-macOS");
            bl = false;
        } else if (settings.getMacOSSymbolSettings().getLoadDSymNearBinaries()) {
            logger.trace("Setting 'loadDSymNearBinaries' already enabled");
            bl = false;
        } else if (!settings.getMacOSSymbolSettings().getPromoteLoadDSymNearBinaries()) {
            logger.trace("Setting 'promoteLoadDSymNearBinaries' disabled");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean showMacDebugSymbolsPromotionNotification$lambda$0(Project $project, Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return Intrinsics.areEqual((Object)editor.getProject(), (Object)$project);
    }

    private static final Unit getNotifier$lambda$0$0(DataContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CidrDebuggerSettings.getInstance().getMacOSSymbolSettings().setPromoteLoadDSymNearBinaries(false);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ boolean access$shouldPromoteDebugSymbols(UseMacDebugSymbolsPromoter $this) {
        return $this.shouldPromoteDebugSymbols();
    }

    public static final /* synthetic */ void access$showMacDebugSymbolsPromotionNotification(UseMacDebugSymbolsPromoter $this, Lifetime lifetime, Project project, XDebugSession session2) {
        $this.showMacDebugSymbolsPromotionNotification(lifetime, project, session2);
    }

    static {
        UseMacDebugSymbolsPromoter $this$thisLogger$iv = INSTANCE = new UseMacDebugSymbolsPromoter();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(UseMacDebugSymbolsPromoter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UseMacDebugSymbolsPromoter.logger = logger;
    }
}

