/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.editorNotifiers;

import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModulesHandler;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.rider.cpp.debugger.editorNotifiers.RiderCppMacSymbolsNotifierKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/cpp/debugger/editorNotifiers/RiderCppDsymDetector;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerModulesHandler;", "<init>", "()V", "handleModulesLoaded", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "modules", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLModule;", "isDsymExists", "", "module", "doesSymbolFileExist", "dsymPath", "Ljava/nio/file/Path;", "isModuleInsideAppBundle", "modulePath", "", "moduleFileName", "getAppBundlePath", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nRiderCppMacSymbolsNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppMacSymbolsNotifier.kt\ncom/jetbrains/rider/cpp/debugger/editorNotifiers/RiderCppDsymDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1869#2,2:156\n*S KotlinDebug\n*F\n+ 1 RiderCppMacSymbolsNotifier.kt\ncom/jetbrains/rider/cpp/debugger/editorNotifiers/RiderCppDsymDetector\n*L\n98#1:156,2\n*E\n"})
public final class RiderCppDsymDetector
implements CidrDebuggerModulesHandler {
    public void handleModulesLoaded(@NotNull CidrDebugProcess process, @NotNull List<LLModule> modules) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        if (modules.isEmpty()) {
            return;
        }
        if (RiderCppMacSymbolsNotifierKt.access$getOneOfModulesHasSymbolFile(process)) {
            return;
        }
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLModule module = (LLModule)element$iv;
            boolean bl = false;
            CidrDebuggerLog.LOG.trace("Module " + module.getName() + " loading");
            boolean isSymbolFileExistsForModule = this.isDsymExists(module);
            if (!isSymbolFileExistsForModule) continue;
            RiderCppMacSymbolsNotifierKt.access$setOneOfModulesHasSymbolFile(process);
            return;
        }
    }

    private final boolean isDsymExists(LLModule module) {
        CidrDebuggerLog.LOG.trace("Checking if symbol file exists for module " + module.getName());
        Path modulePath = Path.of(module.getPath(), new String[0]);
        Intrinsics.checkNotNull((Object)modulePath);
        String moduleFileNameWithoutExt = PathsKt.getNameWithoutExtension((Path)modulePath);
        String dsymFileName = moduleFileNameWithoutExt + ".dSYM";
        Path dsymPath = modulePath.resolveSibling(dsymFileName);
        Intrinsics.checkNotNull((Object)dsymPath);
        if (this.doesSymbolFileExist(dsymPath)) {
            CidrDebuggerLog.LOG.trace("Symbol file for module " + module.getName() + " found at " + dsymPath);
            return true;
        }
        if (this.isModuleInsideAppBundle(module.getPath(), moduleFileNameWithoutExt)) {
            Path appBundlePath = this.getAppBundlePath(modulePath);
            Path dsymNearAppBundlePath = appBundlePath.resolveSibling(dsymFileName);
            Intrinsics.checkNotNull((Object)dsymNearAppBundlePath);
            if (this.doesSymbolFileExist(dsymNearAppBundlePath)) {
                CidrDebuggerLog.LOG.trace("Symbol file for module " + module.getName() + " found at " + dsymPath);
                return true;
            }
        }
        return false;
    }

    private final boolean doesSymbolFileExist(Path dsymPath) {
        return dsymPath.toFile().exists();
    }

    private final boolean isModuleInsideAppBundle(String modulePath, String moduleFileName) {
        return StringsKt.contains$default((CharSequence)modulePath, (CharSequence)(moduleFileName + ".app/Contents/MacOS/" + moduleFileName), (boolean)false, (int)2, null);
    }

    private final Path getAppBundlePath(Path modulePath) {
        Path path = modulePath.getParent().getParent().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        return path;
    }
}

