/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrVisualStudioLocator;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppVisualStudioLocator;", "Lcom/jetbrains/cidr/execution/debugger/CidrVisualStudioLocator;", "<init>", "()V", "getVisualStudioRoot", "Ljava/nio/file/Path;", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "Impl", "intellij.rider.plugins.cpp"})
public final class RiderCppVisualStudioLocator
implements CidrVisualStudioLocator {
    @Nullable
    public Path getVisualStudioRoot(@NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        return Impl.INSTANCE.getVisualStudioRoot(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppVisualStudioLocator$Impl;", "", "<init>", "()V", "getVisualStudioRoot", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.cpp"})
    public static final class Impl {
        @NotNull
        public static final Impl INSTANCE = new Impl();

        private Impl() {
        }

        @Nullable
        public final Path getVisualStudioRoot(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = (String)SolutionHostExtensionsKt.getSolution((Project)project).getActiveMsBuildPath().getValue();
            if (string == null) {
                return null;
            }
            String msBuildStr = string;
            Path path = Paths.get(msBuildStr, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path msBuildPath = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(msBuildPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            String string2 = PathsKt.getName((Path)msBuildPath).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string2, (Object)"msbuild.exe")) {
                Path msBuildBinPath;
                String string3;
                Object object = msBuildPath.getParent();
                if (object != null && (object = PathsKt.getName((Path)object)) != null) {
                    String string4 = ((String)object).toLowerCase(Locale.ROOT);
                    string3 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                } else {
                    string3 = null;
                }
                if (Intrinsics.areEqual(string3, (Object)"bin")) {
                    v7 = msBuildPath.getParent();
                } else {
                    String string5;
                    Object object2 = msBuildPath.getParent();
                    if (object2 != null && (object2 = object2.getParent()) != null && (object2 = PathsKt.getName((Path)object2)) != null) {
                        String string6 = ((String)object2).toLowerCase(Locale.ROOT);
                        string5 = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                    } else {
                        string5 = null;
                    }
                    if (Intrinsics.areEqual(string5, (Object)"bin")) {
                        Path path2 = msBuildPath.getParent();
                        v7 = path2 != null ? path2.getParent() : null;
                    } else {
                        v7 = msBuildBinPath = null;
                    }
                }
                if (msBuildBinPath != null) {
                    Path vsRoot;
                    Path path3 = msBuildBinPath.getParent();
                    Path path4 = path3 != null && (path3 = path3.getParent()) != null ? path3.getParent() : (vsRoot = null);
                    if (vsRoot != null) {
                        Object[] objectArray = new String[]{"Preview", "Community", "Professional", "Enterprise", "Build Tools"};
                        Object[] vsTypes = objectArray;
                        if (!ArraysKt.contains((Object[])vsTypes, (Object)PathsKt.getName((Path)vsRoot))) {
                            CidrDebuggerLog.LOG.warn("RiderCppVisualStudioLocator: '" + vsRoot + "' is detected as suspicious visual studio root directory");
                        }
                        return vsRoot;
                    }
                }
            }
            CidrDebuggerLog.LOG.warn("RiderCppVisualStudioLocator: '" + msBuildPath + "' is not a msbuild bundled with visual studio. Couldn't find vs debugger package with bundled natvis files");
            return null;
        }
    }
}

