/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisContext;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisFileLocationUtilsKt;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisFileProvider;
import com.jetbrains.rider.cpp.debugger.RiderCppVisualStudioLocator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider;", "Lcom/jetbrains/cidr/execution/debugger/formatters/natvis/NatvisFileProvider;", "<init>", "()V", "getNatvisPaths", "", "", "context", "Lcom/jetbrains/cidr/execution/debugger/formatters/natvis/NatvisContext;", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nRiderCppNatvisFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppNatvisFileProvider.kt\ncom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1563#2:48\n1634#2,3:49\n1563#2:52\n1634#2,3:53\n*S KotlinDebug\n*F\n+ 1 RiderCppNatvisFileProvider.kt\ncom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider\n*L\n41#1:48\n41#1:49,3\n44#1:52\n44#1:53,3\n*E\n"})
public final class RiderCppNatvisFileProvider
implements NatvisFileProvider {
    @NotNull
    public List<String> getNatvisPaths(@NotNull NatvisContext context) {
        Path it;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Looking for visual studio debugger package natvis files");
        Path vsRootDir = RiderCppVisualStudioLocator.Impl.INSTANCE.getVisualStudioRoot(context.getProject());
        if (vsRootDir == null) {
            CidrDebuggerLog.LOG.warn("NatvisFileProvider: Visual studio root directory was not found: check the path to the selected msbuild");
            return CollectionsKt.emptyList();
        }
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Detected visual studio root directory: '" + vsRootDir + "'");
        Path vsVisualizersDir = NatvisFileLocationUtilsKt.getVisualStudioSystemVisualizersDir((Path)vsRootDir);
        if (vsVisualizersDir == null) {
            CidrDebuggerLog.LOG.warn("NatvisFileProvider: Folder with visual studio natvis files was not found");
            return CollectionsKt.emptyList();
        }
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Detected folder with packaged natvis: '" + vsVisualizersDir + "'");
        List foundNatvisFiles = CollectionsKt.toMutableList((Collection)NatvisFileProvider.Companion.listNatvisFilesInDirectory(vsVisualizersDir));
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Found " + foundNatvisFiles.size() + " natvis files");
        Path userVisualizersDir = NatvisFileLocationUtilsKt.getVisualStudioUserVisualizersDir((Path)vsRootDir);
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Folder with user natvis: '" + userVisualizersDir + "'");
        if (userVisualizersDir != null) {
            foundNatvisFiles.addAll(NatvisFileProvider.Companion.listNatvisFilesInDirectory(userVisualizersDir));
            CidrDebuggerLog.LOG.debug("NatvisFileProvider: Found " + foundNatvisFiles.size() + " natvis files");
        }
        if (!((Collection)foundNatvisFiles).isEmpty()) {
            Iterable iterable = foundNatvisFiles;
            object = CidrDebuggerLog.LOG;
            $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PathsKt.getName((Path)it));
            }
            object.debug("NatvisFileProvider: Found natvis files: '" + (List)destination$iv$iv + "'");
        }
        $this$map$iv = foundNatvisFiles;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Path)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Object)it.toAbsolutePath()).toString());
        }
        return (List)destination$iv$iv;
    }
}

