/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.PeInfo;
import com.jetbrains.cidr.PeSubsystem;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerConsoleMode;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.RiderCppLLDBEvaluationContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0004J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\b\u0010#\u001a\u00020\bH\u0016J\u0017\u0010$\u001a\u00020\u00152\b\u0010%\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\bH\u0016J\b\u0010(\u001a\u00020\bH\u0016J\b\u0010)\u001a\u00020\bH\u0016R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0006\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppLLDBDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration;", "<init>", "()V", "debugger", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerConsoleMode;", "(Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerConsoleMode;)V", "myIsContinueAfterAttach", "", "Ljava/lang/Boolean;", "myDebuggerConsoleMode", "getMyDebuggerConsoleMode", "()Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerConsoleMode;", "setMyDebuggerConsoleMode", "createDriver", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "handler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "configureDriver", "", "driver", "createEvaluationContext", "Lcom/jetbrains/cidr/execution/debugger/backend/EvaluationContext;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "expirable", "Lcom/intellij/openapi/util/Expirable;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "cacheHolder", "Lcom/intellij/openapi/util/UserDataHolderEx;", "configureMSVCStepping", "canChangeContinueAfterAttach", "setContinueAfterAttachNeeded", "value", "(Ljava/lang/Boolean;)V", "isContinueAfterAttachNeeded", "isDetachSupported", "enableInstructionBreakpointAdjustment", "intellij.rider.plugins.cpp"})
public class RiderCppLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    @Nullable
    private volatile Boolean myIsContinueAfterAttach;
    @NotNull
    private DebuggerConsoleMode myDebuggerConsoleMode;

    public RiderCppLLDBDriverConfiguration() {
        this.myDebuggerConsoleMode = DebuggerConsoleMode.UNSPECIFIED;
    }

    @NotNull
    public final DebuggerConsoleMode getMyDebuggerConsoleMode() {
        return this.myDebuggerConsoleMode;
    }

    public final void setMyDebuggerConsoleMode(@NotNull DebuggerConsoleMode debuggerConsoleMode) {
        Intrinsics.checkNotNullParameter((Object)debuggerConsoleMode, (String)"<set-?>");
        this.myDebuggerConsoleMode = debuggerConsoleMode;
    }

    public RiderCppLLDBDriverConfiguration(@NotNull DebuggerConsoleMode debugger) {
        Intrinsics.checkNotNullParameter((Object)debugger, (String)"debugger");
        this();
        this.myDebuggerConsoleMode = debugger;
    }

    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        LLDBDriver lLDBDriver;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        LLDBDriver lLDBDriver2 = super.createDriver(handler, architectureType);
        Intrinsics.checkNotNullExpressionValue((Object)lLDBDriver2, (String)"createDriver(...)");
        LLDBDriver it = lLDBDriver = lLDBDriver2;
        boolean bl = false;
        this.configureDriver(it);
        return lLDBDriver;
    }

    protected final void configureDriver(@NotNull LLDBDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if (SystemInfo.isWindows) {
            this.configureMSVCStepping(driver);
        }
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull UserDataHolderEx cacheHolder) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)cacheHolder, (String)"cacheHolder");
        return (EvaluationContext)new RiderCppLLDBEvaluationContext(driver, expirable, thread, frame, cacheHolder);
    }

    private final void configureMSVCStepping(LLDBDriver driver) {
        driver.setAutorunScriptName("jb_lldb_init");
        driver.setStepIntoClassName("jb_lldb_stepping.StepIn");
        driver.setStepIntoByInstructionClassName("jb_lldb_stepping.StepThroughInstruction");
        driver.setStepOverClassName("jb_lldb_stepping.StepOver");
        driver.setStepOverByInstructionClassName("jb_lldb_stepping.StepOverInstruction");
        driver.setStepOutClassName(null);
    }

    public boolean canChangeContinueAfterAttach() {
        return true;
    }

    public void setContinueAfterAttachNeeded(@Nullable Boolean value) {
        this.myIsContinueAfterAttach = value;
    }

    public boolean isContinueAfterAttachNeeded() {
        Boolean bl = this.myIsContinueAfterAttach;
        return bl != null ? bl : !AdvancedSettings.Companion.getBoolean("rider.keep.process.suspended.after.attach");
    }

    public boolean isDetachSupported() {
        if (this.isLegacyHandleInheritanceMode) {
            return false;
        }
        if (this.myDebuggerConsoleMode == DebuggerConsoleMode.EXTERNAL) {
            return true;
        }
        return this.getUserData(PeInfo.Companion.getPeSubsystemKey()) == PeSubsystem.GUI;
    }

    public boolean enableInstructionBreakpointAdjustment() {
        return true;
    }
}

