/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.DebuggerScriptsHelper;
import com.jetbrains.rider.cpp.debugger.editorNotifiers.UseMacDebugSymbolsPromoter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppDebugProcessInitialConfigurator;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "configureLLDB", "driverConfiguration", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration;", "intellij.rider.plugins.cpp"})
public final class RiderCppDebugProcessInitialConfigurator
implements CidrDebugProcessConfigurator {
    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerDriverConfiguration, (String)"getDebuggerDriverConfiguration(...)");
        DebuggerDriverConfiguration driverConfiguration = debuggerDriverConfiguration;
        if (!(driverConfiguration instanceof LLDBDriverConfiguration)) {
            return;
        }
        this.configureLLDB(process, (LLDBDriverConfiguration)driverConfiguration);
        UseMacDebugSymbolsPromoter.INSTANCE.tryPromoteUseMacDebugSymbols(process);
    }

    private final void configureLLDB(CidrDebugProcess process, LLDBDriverConfiguration driverConfiguration) {
        String symbolsInfoScriptPath = DebuggerScriptsHelper.INSTANCE.getSymbolsInfoScriptPath();
        CharSequence charSequence = symbolsInfoScriptPath;
        if (!(charSequence == null || charSequence.length() == 0)) {
            process.putUserData(DebuggerScriptsHelper.INSTANCE.getSYMBOL_INFO_EXIST_KEY(), (Object)symbolsInfoScriptPath);
        }
        process.postCommand(arg_0 -> RiderCppDebugProcessInitialConfigurator.configureLLDB$lambda$0(driverConfiguration, symbolsInfoScriptPath, arg_0));
    }

    private static final void configureLLDB$lambda$0(LLDBDriverConfiguration $driverConfiguration, String $symbolsInfoScriptPath, DebuggerDriver driver) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if ($driverConfiguration.getHostMachine().getOS() == OS.Windows) {
            driver.executeInterpreterCommand(-1L, -1, "settings set target.x86-disassembly-flavor intel");
        }
        if (!((charSequence = (CharSequence)$symbolsInfoScriptPath) == null || charSequence.length() == 0)) {
            driver.executeInterpreterCommand(-1L, -1, "command script import \"" + $symbolsInfoScriptPath + "\"");
        }
    }
}

