/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.MixedModeMonoLLDBDriverConfigurationKt;
import com.jetbrains.rider.cpp.debugger.RiderCppLLDBDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MonoMixedMonoLLDBDriver;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/cpp/debugger/MixedModeMonoLLDBDriverConfiguration;", "Lcom/jetbrains/rider/cpp/debugger/RiderCppLLDBDriverConfiguration;", "pid", "", "<init>", "(I)V", "getPid", "()I", "createDriver", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "handler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "createDriverCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "getPathToUnityDir", "Ljava/nio/file/Path;", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nMixedModeMonoLLDBDriverConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MixedModeMonoLLDBDriverConfiguration.kt\ncom/jetbrains/rider/cpp/debugger/MixedModeMonoLLDBDriverConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class MixedModeMonoLLDBDriverConfiguration
extends RiderCppLLDBDriverConfiguration {
    private final int pid;

    public MixedModeMonoLLDBDriverConfiguration(int pid) {
        this.pid = pid;
    }

    public final int getPid() {
        return this.pid;
    }

    @Override
    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        File file = this.getBundledLLDBFrameworkFile(architectureType).getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        File it = object = FilesKt.resolve((File)file, (String)"lldb-injected-thread.dll");
        boolean bl = false;
        boolean bl2 = it.exists();
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Path injectedThreadAssemblyPath = object.toPath();
        LLDBDriverConfiguration lLDBDriverConfiguration = this;
        Intrinsics.checkNotNull((Object)injectedThreadAssemblyPath);
        it = object = new MonoMixedMonoLLDBDriver(handler, lLDBDriverConfiguration, architectureType, injectedThreadAssemblyPath);
        boolean bl3 = false;
        this.configureDriver((LLDBDriver)it);
        return (LLDBDriver)object;
    }

    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        GeneralCommandLine generalCommandLine2 = super.createDriverCommandLine(driver, architectureType);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"createDriverCommandLine(...)");
        GeneralCommandLine it = generalCommandLine = generalCommandLine2;
        boolean bl = false;
        String string = (String)it.getEnvironment().get("_NT_SYMBOL_PATH");
        if (string == null) {
            string = "";
        }
        String prevValue = string;
        Object object = this.getPathToUnityDir();
        Path it2 = object;
        boolean bl2 = false;
        MixedModeMonoLLDBDriverConfigurationKt.access$getLOG$p().info("Unity directory found: " + it2);
        Path unityDir = object;
        Map map = it.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        object = map;
        String string2 = "_NT_SYMBOL_PATH";
        String string3 = prevValue + unityDir + ";";
        object.put(string2, string3);
        return generalCommandLine;
    }

    private final Path getPathToUnityDir() {
        ProcessHandle unityProcessHandle = ProcessHandle.of(this.pid).orElseThrow(() -> MixedModeMonoLLDBDriverConfiguration.getPathToUnityDir$lambda$0(this));
        String unityProcessCommand = unityProcessHandle.info().command().orElseThrow(() -> MixedModeMonoLLDBDriverConfiguration.getPathToUnityDir$lambda$1(this));
        Intrinsics.checkNotNull((Object)unityProcessCommand);
        Path path = Paths.get(unityProcessCommand, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        return path2;
    }

    private static final IllegalStateException getPathToUnityDir$lambda$0(MixedModeMonoLLDBDriverConfiguration this$0) {
        return new IllegalStateException("Cannot find Unity process with pid " + this$0.pid);
    }

    private static final IllegalStateException getPathToUnityDir$lambda$1(MixedModeMonoLLDBDriverConfiguration this$0) {
        return new IllegalStateException("Cannot find command line for Unity process with pid " + this$0.pid);
    }
}

