/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ChildProcessDebuggingDriverConfiguratorKt;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ChildProcessDebuggingTabRuleUtilsKt;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.DebuggingRules;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.TabPresentation;
import com.jetbrains.rider.cpp.debugger.DebuggerTabNamingListener;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/cpp/debugger/DebuggerTabNamingSupport;", "", "<init>", "()V", "DEBUGGER_TAB_ORDER_PRIORITY_KEY", "Lcom/intellij/openapi/util/Key;", "", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "applyTabNamingIfConfigured", "", "project", "Lcom/intellij/openapi/project/Project;", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "defaultSessionName", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "reorderTabs", "applyTabPresentation", "content", "Lcom/intellij/ui/content/Content;", "rules", "Lcom/jetbrains/cidr/execution/debugger/childProcessDebugging/DebuggingRules;", "isDebuggerContent", "", "getRulesFromCurrentSession", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nDebuggerTabNamingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerTabNamingSupport.kt\ncom/jetbrains/rider/cpp/debugger/DebuggerTabNamingSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,91:1\n1056#2:92\n1#3:93\n13#4:94\n13#5:95\n*S KotlinDebug\n*F\n+ 1 DebuggerTabNamingSupport.kt\ncom/jetbrains/rider/cpp/debugger/DebuggerTabNamingSupport\n*L\n57#1:92\n23#1:94\n23#1:95\n*E\n"})
public final class DebuggerTabNamingSupport {
    @NotNull
    public static final DebuggerTabNamingSupport INSTANCE = new DebuggerTabNamingSupport();
    @NotNull
    private static final Key<Integer> DEBUGGER_TAB_ORDER_PRIORITY_KEY;
    @NotNull
    private static final Logger myLogger;

    private DebuggerTabNamingSupport() {
    }

    public final void applyTabNamingIfConfigured(@NotNull Project project, @NotNull ContentManager contentManager, @NotNull ProcessInfo processInfo, @NotNull String defaultSessionName, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contentManager, (String)"contentManager");
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)defaultSessionName, (String)"defaultSessionName");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        if (!(contentManager instanceof ContentManagerImpl)) {
            myLogger.warn("ContentManager is not of type ContentManagerImpl. Skipping tab reordering.");
            return;
        }
        DebuggingRules debuggingRules = this.getRulesFromCurrentSession(project);
        if (debuggingRules == null) {
            return;
        }
        DebuggingRules rules = debuggingRules;
        if (rules.getTabNameRules().isEmpty()) {
            return;
        }
        new DebuggerTabNamingListener(contentManager, parentDisposable, (Function1<? super Content, Boolean>)((Function1)arg_0 -> DebuggerTabNamingSupport.applyTabNamingIfConfigured$lambda$0(defaultSessionName, processInfo, rules, contentManager, arg_0)));
    }

    private final void reorderTabs(ContentManager contentManager) {
        Content selected = contentManager.getSelectedContent();
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        List original = ArraysKt.toList((Object[])contentArray);
        Iterable $this$sortedBy$iv = original;
        boolean $i$f$sortedBy = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Content it = (Content)a;
                boolean bl = false;
                Integer n = (Integer)it.getUserData(DebuggerTabNamingSupport.access$getDEBUGGER_TAB_ORDER_PRIORITY_KEY$p());
                it = (Content)b;
                Comparable comparable = Integer.valueOf(n != null ? n : Integer.MAX_VALUE);
                bl = false;
                Integer n2 = (Integer)it.getUserData(DebuggerTabNamingSupport.access$getDEBUGGER_TAB_ORDER_PRIORITY_KEY$p());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2 != null ? n2 : Integer.MAX_VALUE));
            }
        });
        if (Intrinsics.areEqual((Object)original, (Object)sorted)) {
            return;
        }
        for (Content c : original) {
            Content.TEMPORARY_REMOVED_KEY.set((UserDataHolder)c, (Object)true);
            contentManager.removeContent(c, false);
        }
        for (Content c : sorted) {
            Content.TEMPORARY_REMOVED_KEY.set((UserDataHolder)c, (Object)false);
            contentManager.addContent(c);
        }
        if (selected != null) {
            Content[] contentArray2 = contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray2, (String)"getContents(...)");
            if (ArraysKt.contains((Object[])contentArray2, (Object)selected)) {
                contentManager.setSelectedContent(selected);
            }
        }
    }

    private final void applyTabPresentation(Content content, ProcessInfo processInfo, DebuggingRules rules, String defaultSessionName) {
        String string = processInfo.getExecutableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableName(...)");
        String string2 = processInfo.getCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandLine(...)");
        TabPresentation presentation = ChildProcessDebuggingTabRuleUtilsKt.getTabPresentation((DebuggingRules)rules, (String)string, (String)string2, (int)processInfo.getPid(), (String)defaultSessionName);
        content.setDisplayName(presentation.getName());
        content.putUserData(DEBUGGER_TAB_ORDER_PRIORITY_KEY, (Object)presentation.getOrder());
    }

    private final boolean isDebuggerContent(Content content) {
        Content content2;
        block3: {
            block2: {
                content2 = content;
                if (content2 == null) break block2;
                Content it = content2;
                boolean bl = false;
                Executor executor = RunContentManagerImpl.Companion.getExecutorByContent(it);
                content2 = executor;
                if (executor != null) break block3;
            }
            return false;
        }
        Content executor = content2;
        return Intrinsics.areEqual((Object)executor.getToolWindowId(), (Object)"Debug");
    }

    private final DebuggingRules getRulesFromCurrentSession(Project project) {
        CidrDebugProcess debugProcess;
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        XDebugProcess xDebugProcess = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
        CidrDebugProcess cidrDebugProcess = debugProcess = xDebugProcess instanceof CidrDebugProcess ? (CidrDebugProcess)xDebugProcess : null;
        return cidrDebugProcess != null ? (DebuggingRules)cidrDebugProcess.getUserData(ChildProcessDebuggingDriverConfiguratorKt.getDEBUGGER_CHILD_PROCESS_RULES()) : null;
    }

    private static final boolean applyTabNamingIfConfigured$lambda$0(String $defaultSessionName, ProcessInfo $processInfo, DebuggingRules $rules, ContentManager $contentManager, Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (!Intrinsics.areEqual((Object)content.getDisplayName(), (Object)$defaultSessionName)) {
            return false;
        }
        if (!INSTANCE.isDebuggerContent(content)) {
            return false;
        }
        INSTANCE.applyTabPresentation(content, $processInfo, $rules, $defaultSessionName);
        INSTANCE.reorderTabs($contentManager);
        return true;
    }

    public static final /* synthetic */ Key access$getDEBUGGER_TAB_ORDER_PRIORITY_KEY$p() {
        return DEBUGGER_TAB_ORDER_PRIORITY_KEY;
    }

    static {
        Key key = Key.create((String)"DEBUGGER_TAB_ORDER_PRIORITY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DEBUGGER_TAB_ORDER_PRIORITY_KEY = key;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DebuggerTabNamingSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        myLogger = logger;
    }
}

