/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rider.cpp.debugger.modulesView.LoggerKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u0004\u0018\u00010\u00052\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eR\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\t\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/cpp/debugger/DebuggerScriptsHelper;", "", "<init>", "()V", "basePath", "Ljava/nio/file/Path;", "getBasePath", "()Ljava/nio/file/Path;", "basePath$delegate", "Lkotlin/Lazy;", "resolveBaseFromSourcesJar", "debuggerClass", "Ljava/lang/Class;", "lldbSymbolsInfoHelperPythonScriptPath", "", "getLldbSymbolsInfoHelperPythonScriptPath", "()Ljava/lang/String;", "lldbSymbolsInfoHelperPythonScriptPath$delegate", "lldbUnrealBlueprintMixedStackPythonScriptPath", "getLldbUnrealBlueprintMixedStackPythonScriptPath", "lldbUnrealBlueprintMixedStackPythonScriptPath$delegate", "getFieldValue", "fieldValue", "fieldName", "getUnrealBlueprintMixedStackPythonScriptPath", "getSymbolsInfoScriptPath", "SYMBOL_INFO_EXIST_KEY", "Lcom/intellij/openapi/util/Key;", "getSYMBOL_INFO_EXIST_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nDebuggerScriptsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerScriptsHelper.kt\ncom/jetbrains/rider/cpp/debugger/DebuggerScriptsHelper\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n107#2:110\n98#2,4:111\n107#2:115\n98#2,4:116\n107#2:120\n98#2,4:121\n107#2:125\n98#2,4:126\n107#2:130\n98#2,4:131\n107#2:136\n98#2,4:137\n1#3:135\n*S KotlinDebug\n*F\n+ 1 DebuggerScriptsHelper.kt\ncom/jetbrains/rider/cpp/debugger/DebuggerScriptsHelper\n*L\n54#1:110\n54#1:111,4\n70#1:115\n70#1:116,4\n89#1:120\n89#1:121,4\n93#1:125\n93#1:126,4\n29#1:130\n29#1:131,4\n44#1:136\n44#1:137,4\n*E\n"})
public final class DebuggerScriptsHelper {
    @NotNull
    public static final DebuggerScriptsHelper INSTANCE = new DebuggerScriptsHelper();
    @NotNull
    private static final Lazy basePath$delegate = LazyKt.lazy(DebuggerScriptsHelper::basePath_delegate$lambda$0);
    @NotNull
    private static final Lazy lldbSymbolsInfoHelperPythonScriptPath$delegate = LazyKt.lazy(DebuggerScriptsHelper::lldbSymbolsInfoHelperPythonScriptPath_delegate$lambda$0);
    @NotNull
    private static final Lazy lldbUnrealBlueprintMixedStackPythonScriptPath$delegate = LazyKt.lazy(DebuggerScriptsHelper::lldbUnrealBlueprintMixedStackPythonScriptPath_delegate$lambda$0);
    @NotNull
    private static final Key<String> SYMBOL_INFO_EXIST_KEY;

    private DebuggerScriptsHelper() {
    }

    private final Path getBasePath() {
        Lazy lazy = basePath$delegate;
        return (Path)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Path resolveBaseFromSourcesJar(Class<?> debuggerClass) {
        Path jar = PathManager.getJarForClass(debuggerClass);
        if (jar == null) {
            void $this$log$iv$iv;
            Logger $this$error$iv = LoggerKt.getModulesViewLogger();
            boolean $i$f$error = false;
            Logger logger = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var13_15 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Failed to find jar for " + debuggerClass + ". PathManager.getJarForClass returned null";
                var13_15.log(logLevel, (Object)string, null);
            }
            return null;
        }
        if (!StringsKt.endsWith((String)((Object)jar.getFileName()).toString(), (String)".jar", (boolean)true)) {
            return null;
        }
        Path path = PathManager.getHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getHomeDir(...)");
        Path homeDir = path;
        Path pluginSourcePath = homeDir.resolve("rider/plugins/cpp");
        Path resourcesPath = pluginSourcePath.resolve("resources");
        Path scriptsDir = resourcesPath.resolve("scripts/debugger");
        if (!Files.isDirectory(scriptsDir, new LinkOption[0])) {
            void $this$log$iv$iv;
            Logger $this$error$iv = LoggerKt.getModulesViewLogger();
            boolean $i$f$error = false;
            Logger logger = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var13_16 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Failed to find debugger scripts directory at " + scriptsDir + ". HomeDir=" + homeDir + ", pluginSource=" + pluginSourcePath;
                var13_16.log(logLevel, (Object)string, null);
            }
            return null;
        }
        return resourcesPath;
    }

    private final String getLldbSymbolsInfoHelperPythonScriptPath() {
        Lazy lazy = lldbSymbolsInfoHelperPythonScriptPath$delegate;
        return (String)lazy.getValue();
    }

    private final String getLldbUnrealBlueprintMixedStackPythonScriptPath() {
        Lazy lazy = lldbUnrealBlueprintMixedStackPythonScriptPath$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final String getFieldValue(String fieldValue, String fieldName) {
        if (fieldValue == null) {
            void $this$log$iv$iv;
            Logger $this$error$iv = LoggerKt.getModulesViewLogger();
            boolean $i$f$error = false;
            Logger logger = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var9_15 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Failed to find " + fieldName;
                var9_15.log(logLevel, (Object)string, null);
            }
            return null;
        }
        if (!Files.exists(Paths.get(fieldValue, new String[0]), new LinkOption[0])) {
            Logger $this$error$iv = LoggerKt.getModulesViewLogger();
            boolean $i$f$error = false;
            Logger $this$log$iv$iv = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                Logger logger = $this$log$iv$iv;
                boolean bl = false;
                String string = "File " + fieldValue + " does not exist";
                logger.log(logLevel, (Object)string, null);
            }
            return null;
        }
        return fieldValue;
    }

    @Nullable
    public final String getUnrealBlueprintMixedStackPythonScriptPath() {
        return this.getFieldValue(this.getLldbUnrealBlueprintMixedStackPythonScriptPath(), "lldbUnrealBlueprintMixedStackPythonScriptPath");
    }

    @Nullable
    public final String getSymbolsInfoScriptPath() {
        return this.getFieldValue(this.getLldbSymbolsInfoHelperPythonScriptPath(), "lldbSymbolsInfoHelperPythonScriptPath");
    }

    @NotNull
    public final Key<String> getSYMBOL_INFO_EXIST_KEY() {
        return SYMBOL_INFO_EXIST_KEY;
    }

    /*
     * WARNING - void declaration
     */
    private static final Path basePath_delegate$lambda$0() {
        PluginId pluginId;
        Class<DebuggerScriptsHelper> debuggerClass = DebuggerScriptsHelper.class;
        ClassLoader classLoader = debuggerClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 instanceof PluginAwareClassLoader) {
            PluginId pluginId2 = ((PluginAwareClassLoader)classLoader2).getPluginId();
            Intrinsics.checkNotNull((Object)pluginId2);
            pluginId = pluginId2;
        } else {
            if (!PluginManagerCore.isRunningFromSources()) {
                void $this$log$iv$iv;
                Logger $this$error$iv = LoggerKt.getModulesViewLogger();
                boolean $i$f$error = false;
                Logger logger = $this$error$iv;
                LogLevel level$iv$iv = LogLevel.Error;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var10_16 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = "Unexpected class loader: " + classLoader2 + " (expected PluginAwareClassLoader) when not running from sources";
                    var10_16.log(logLevel, (Object)string, null);
                }
                return null;
            }
            Path $this$error$iv = INSTANCE.resolveBaseFromSourcesJar(debuggerClass);
            if ($this$error$iv != null) {
                Path it = $this$error$iv;
                boolean bl = false;
                return it;
            }
            pluginId = PluginId.Companion.getId("com.jetbrains.rider-cpp");
        }
        PluginId pluginId3 = pluginId;
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId3);
        if (plugin == null) {
            void $this$log$iv$iv;
            Logger $this$error$iv = LoggerKt.getModulesViewLogger();
            boolean $i$f$error = false;
            Logger bl = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var10_17 = $this$log$iv$iv;
                boolean bl2 = false;
                String string = "Failed to find plugin " + pluginId3 + " containing DebuggerScriptsHelper";
                var10_17.log(logLevel, (Object)string, null);
            }
            return null;
        }
        return plugin.getPluginPath();
    }

    private static final String lldbSymbolsInfoHelperPythonScriptPath_delegate$lambda$0() {
        Path path = INSTANCE.getBasePath();
        return path != null && (path = path.resolve("scripts/debugger")) != null && (path = path.resolve("lldb/jb_symbols_info.py")) != null ? ((Object)path).toString() : null;
    }

    private static final String lldbUnrealBlueprintMixedStackPythonScriptPath_delegate$lambda$0() {
        Path path = INSTANCE.getBasePath();
        return path != null && (path = path.resolve("scripts/debugger")) != null && (path = path.resolve("lldb/jb_unreal_blueprint_mixedstack.py")) != null ? ((Object)path).toString() : null;
    }

    static {
        Key key = Key.create((String)"DebuggerScriptsHelper.SYMBOL_INFO_EXIST_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SYMBOL_INFO_EXIST_KEY = key;
    }
}

