/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.toolWindows;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.xaml.preview.toolWindows.WpfPreviewLog;
import com.jetbrains.rider.xaml.preview.toolWindows.WpfPreviewLogTabsManager;
import icons.RiderIcons;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogToolWindowController;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tabManager", "Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogTabsManager;", "getTabManager", "()Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogTabsManager;", "tabManager$delegate", "Lkotlin/Lazy;", "showTab", "", "model", "Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLog;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "updateTabModelIfOpened", "id", "", "newText", "closeTab", "getOrCreateToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "registerToolWindow", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "Companion", "intellij.rider.plugins.xaml.preview"})
public final class WpfPreviewLogToolWindowController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy tabManager$delegate;
    @NotNull
    public static final String TOOL_WINDOW_ID = "WPF Preview";

    public WpfPreviewLogToolWindowController(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.tabManager$delegate = LazyKt.lazy(() -> WpfPreviewLogToolWindowController.tabManager_delegate$lambda$0(project, this));
    }

    private final WpfPreviewLogTabsManager getTabManager() {
        Lazy lazy = this.tabManager$delegate;
        return (WpfPreviewLogTabsManager)((Object)lazy.getValue());
    }

    public final void showTab(@NotNull WpfPreviewLog model, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.getTabManager().openStacktraceTab(model, lifetime);
    }

    public final void updateTabModelIfOpened(@NotNull String id, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.getTabManager().updateTabLogTextIfOpened(id, newText);
    }

    public final void closeTab(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.getTabManager().closeTab(id);
    }

    private final ToolWindow getOrCreateToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            toolWindow = this.registerToolWindow(toolWindowManager, project);
        }
        return toolWindow;
    }

    private final ToolWindow registerToolWindow(ToolWindowManager toolWindowManager, Project project) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(TOOL_WINDOW_ID, true, toolWindowAnchor, (Disposable)project, true, false);
        ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)toolWindow.getContentManager());
        toolWindow.setTitle(TOOL_WINDOW_ID);
        toolWindow.setIcon(RiderIcons.Toolwindows.ToolWindowStacktrace);
        return toolWindow;
    }

    private static final WpfPreviewLogTabsManager tabManager_delegate$lambda$0(Project $project, WpfPreviewLogToolWindowController this$0) {
        return new WpfPreviewLogTabsManager($project, this$0.getOrCreateToolWindow($project));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogToolWindowController$Companion;", "", "<init>", "()V", "TOOL_WINDOW_ID", "", "getInstance", "Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogToolWindowController;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.xaml.preview"})
    @SourceDebugExtension(value={"SMAP\nWpfPreviewLogToolWindowController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WpfPreviewLogToolWindowController.kt\ncom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogToolWindowController$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,58:1\n30#2,2:59\n*S KotlinDebug\n*F\n+ 1 WpfPreviewLogToolWindowController.kt\ncom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogToolWindowController$Companion\n*L\n21#1:59,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WpfPreviewLogToolWindowController getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WpfPreviewLogToolWindowController> serviceClass$iv = WpfPreviewLogToolWindowController.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WpfPreviewLogToolWindowController)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

