/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.previewEditor;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.model.ErrorState;
import com.jetbrains.rider.model.PreviewPoint;
import com.jetbrains.rider.model.WpfPreview;
import com.jetbrains.rider.model.WpfPreviewState;
import com.jetbrains.rider.xaml.preview.fus.WpfPreviewFusLogger;
import com.jetbrains.rider.xaml.preview.previewEditor.WpfPreviewEditor;
import com.jetbrains.rider.xaml.preview.ui.ImagePreview;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/xaml/preview/previewEditor/ZoomPanelMouseListener;", "Ljava/awt/event/MouseListener;", "imagePreviewGetter", "Ljava/util/function/Supplier;", "Lcom/jetbrains/rider/xaml/preview/ui/ImagePreview;", "markupPreviewGetter", "Lcom/jetbrains/rider/model/WpfPreview;", "editor", "Lcom/jetbrains/rider/xaml/preview/previewEditor/WpfPreviewEditor;", "<init>", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Lcom/jetbrains/rider/xaml/preview/previewEditor/WpfPreviewEditor;)V", "attemptToClickWhenHaveMarkupErrors", "Lcom/jetbrains/rd/util/reactive/Signal;", "Lcom/jetbrains/rider/model/ErrorState;", "getAttemptToClickWhenHaveMarkupErrors", "()Lcom/jetbrains/rd/util/reactive/Signal;", "mouseClicked", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "isClickInImage", "", "mouseX", "", "mouseY", "rectangle", "Ljava/awt/Rectangle;", "mousePressed", "mouseReleased", "mouseEntered", "mouseExited", "intellij.rider.plugins.xaml.preview"})
public final class ZoomPanelMouseListener
implements MouseListener {
    @NotNull
    private final Supplier<ImagePreview> imagePreviewGetter;
    @NotNull
    private final Supplier<WpfPreview> markupPreviewGetter;
    @NotNull
    private final WpfPreviewEditor editor;
    @NotNull
    private final Signal<ErrorState> attemptToClickWhenHaveMarkupErrors;

    public ZoomPanelMouseListener(@NotNull Supplier<ImagePreview> imagePreviewGetter, @NotNull Supplier<WpfPreview> markupPreviewGetter, @NotNull WpfPreviewEditor editor) {
        Intrinsics.checkNotNullParameter(imagePreviewGetter, (String)"imagePreviewGetter");
        Intrinsics.checkNotNullParameter(markupPreviewGetter, (String)"markupPreviewGetter");
        Intrinsics.checkNotNullParameter((Object)((Object)editor), (String)"editor");
        this.imagePreviewGetter = imagePreviewGetter;
        this.markupPreviewGetter = markupPreviewGetter;
        this.editor = editor;
        this.attemptToClickWhenHaveMarkupErrors = new Signal();
    }

    @NotNull
    public final Signal<ErrorState> getAttemptToClickWhenHaveMarkupErrors() {
        return this.attemptToClickWhenHaveMarkupErrors;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent mouseEvent) {
        int mouseY;
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        XamlSplitEditor xamlSplitEditor = this.editor.getParentEditor();
        if (xamlSplitEditor != null) {
            xamlSplitEditor.requestFocus();
        }
        WpfPreview markupPreview = this.markupPreviewGetter.get();
        ImagePreview imagePreview = this.imagePreviewGetter.get();
        Intrinsics.checkNotNullExpressionValue((Object)imagePreview, (String)"get(...)");
        ImagePreview imagePreview2 = imagePreview;
        if (markupPreview == null) {
            return;
        }
        WpfPreviewState currStatus = (WpfPreviewState)markupPreview.getStatus().getValueOrNull();
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)markupPreview.getHasMarkupErrors()))) {
            this.attemptToClickWhenHaveMarkupErrors.fire(null);
            return;
        }
        if (currStatus instanceof ErrorState) {
            this.attemptToClickWhenHaveMarkupErrors.fire((Object)currStatus);
            return;
        }
        Rectangle rectangle = imagePreview2.getRectangle();
        double zoomFactor = imagePreview2.getRoot().getImagePanel().getZoomFactor();
        if (rectangle == null) {
            return;
        }
        int mouseX = mouseEvent.getX();
        if (this.isClickInImage(mouseX, mouseY = mouseEvent.getY(), rectangle)) {
            double x = (double)(mouseEvent.getX() - rectangle.x) / zoomFactor;
            double y = (double)(mouseEvent.getY() - rectangle.y) / zoomFactor;
            PreviewPoint point = new PreviewPoint(x, y);
            markupPreview.getClick().fire((Object)point);
            Project project = this.editor.getProject();
            String string = this.editor.getParent().getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            WpfPreviewFusLogger.INSTANCE.logPreviewNavigationEvent(project, string);
        }
    }

    private final boolean isClickInImage(int mouseX, int mouseY, Rectangle rectangle) {
        return mouseX >= rectangle.x && mouseY >= rectangle.y && mouseX <= rectangle.x + rectangle.width && mouseY <= rectangle.y + rectangle.height;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
    }

    @Override
    public void mouseExited(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
    }
}

