/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.xaml.preview.actions.ImagePreviewActionBase;
import com.jetbrains.rider.xaml.preview.actions.PreviewActionsUtils;
import com.jetbrains.rider.xaml.preview.fus.WpfPreviewFusLogger;
import com.jetbrains.rider.xaml.preview.ui.ImagePaneWrapper;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import com.jetbrains.rider.xaml.splitEditor.editorActions.XamlSplitEditorActionsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.editor.ImageZoomModel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/xaml/preview/actions/ZoomInAction;", "Lcom/jetbrains/rider/xaml/preview/actions/ImagePreviewActionBase;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.rider.plugins.xaml.preview"})
public final class ZoomInAction
extends ImagePreviewActionBase {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ImagePaneWrapper wrapper = PreviewActionsUtils.INSTANCE.getImagePaneWrapper(e);
        XamlSplitEditor xamlSplitEditor = XamlSplitEditorActionsUtils.INSTANCE.getSplitEditorFromEvent(e);
        if (xamlSplitEditor == null) {
            return;
        }
        XamlSplitEditor editor = xamlSplitEditor;
        if (wrapper != null && wrapper.canZoomIn()) {
            wrapper.zoomIn();
            Project project = e.getProject();
            String string = editor.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            WpfPreviewFusLogger.INSTANCE.logZoomInEvent(project, string);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XamlSplitEditor splitXamlEditor = XamlSplitEditorActionsUtils.INSTANCE.getSplitEditorFromEvent(e);
        if (this.checkIfShouldBeDisabled(splitXamlEditor)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        ImageZoomModel zoomModel = PreviewActionsUtils.INSTANCE.getImageZoomModel(e);
        if (zoomModel != null && splitXamlEditor != null) {
            e.getPresentation().setEnabled(zoomModel.canZoomIn());
        }
    }
}

