/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.PreviewHighlightingRect;
import com.jetbrains.rider.model.WpfPreview;
import com.jetbrains.rider.model.WpfPreviewImage;
import com.jetbrains.rider.model.WpfPreviewModel;
import com.jetbrains.rider.model.WpfPreviewModel_PregeneratedKt;
import com.jetbrains.rider.model.WpfPreviewState;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.xaml.core.XamlEditorsManager;
import com.jetbrains.rider.xaml.core.XamlPreviewEditor;
import com.jetbrains.rider.xaml.preview.previewEditor.WpfPreviewEditor;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditorSplitLayout;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/xaml/preview/WpfPreviewHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "adviceMarkup", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "markupPreview", "Lcom/jetbrains/rider/model/WpfPreview;", "wpfEditor", "Lcom/jetbrains/rider/xaml/preview/previewEditor/WpfPreviewEditor;", "Lcom/jetbrains/rider/xaml/splitEditor/XamlSplitEditor;", "isEnabledChanged", "enabled", "", "handleWpfPreviewEnabledChange", "editor", "isEnabled", "handlePreviewBecameEnabled", "handlePreviewBecameDisabled", "Companion", "ProtocolListener", "intellij.rider.plugins.xaml.preview"})
@SourceDebugExtension(value={"SMAP\nWpfPreviewHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WpfPreviewHost.kt\ncom/jetbrains/rider/xaml/preview/WpfPreviewHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1869#2,2:95\n1869#2,2:97\n1869#2,2:99\n1869#2,2:101\n*S KotlinDebug\n*F\n+ 1 WpfPreviewHost.kt\ncom/jetbrains/rider/xaml/preview/WpfPreviewHost\n*L\n27#1:95,2\n34#1:97,2\n41#1:99,2\n47#1:101,2\n*E\n"})
public class WpfPreviewHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<XamlSplitEditorSplitLayout> SAVED_LAYOUT_KEY;

    public WpfPreviewHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void adviceMarkup(@NotNull Lifetime lifetime, @NotNull WpfPreview markupPreview) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)markupPreview, (String)"markupPreview");
        markupPreview.getHasMarkupErrors().advise(lifetime, arg_0 -> WpfPreviewHost.adviceMarkup$lambda$0(this, markupPreview, arg_0));
        markupPreview.getPreviewImage().advise(lifetime, arg_0 -> WpfPreviewHost.adviceMarkup$lambda$1(this, markupPreview, arg_0));
        markupPreview.getHighlightingRect().advise(lifetime, arg_0 -> WpfPreviewHost.adviceMarkup$lambda$2(this, markupPreview, arg_0));
        markupPreview.getStatus().advise(lifetime, arg_0 -> WpfPreviewHost.adviceMarkup$lambda$3(this, markupPreview, arg_0));
    }

    private final WpfPreviewEditor wpfEditor(XamlSplitEditor $this$wpfEditor) {
        XamlPreviewEditor xamlPreviewEditor = $this$wpfEditor.getPreviewEditor();
        return xamlPreviewEditor instanceof WpfPreviewEditor ? (WpfPreviewEditor)xamlPreviewEditor : null;
    }

    private final void isEnabledChanged(boolean enabled) {
        for (HashSet editorSet : XamlEditorsManager.Companion.getInstance(this.project).getEditors()) {
            Iterator iterator;
            Intrinsics.checkNotNullExpressionValue(editorSet.iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                XamlSplitEditor editor = (XamlSplitEditor)e;
                this.handleWpfPreviewEnabledChange(editor, enabled);
            }
        }
    }

    private final void handleWpfPreviewEnabledChange(XamlSplitEditor editor, boolean isEnabled) {
        if (isEnabled) {
            this.handlePreviewBecameEnabled(editor);
            return;
        }
        this.handlePreviewBecameDisabled(editor);
    }

    private final void handlePreviewBecameEnabled(XamlSplitEditor editor) {
        XamlSplitEditorSplitLayout xamlSplitEditorSplitLayout = (XamlSplitEditorSplitLayout)editor.getUserData(SAVED_LAYOUT_KEY);
        if (xamlSplitEditorSplitLayout == null) {
            return;
        }
        XamlSplitEditorSplitLayout savedLayout = xamlSplitEditorSplitLayout;
        editor.triggerLayoutChange(savedLayout, true);
    }

    private final void handlePreviewBecameDisabled(XamlSplitEditor editor) {
        editor.putUserData(SAVED_LAYOUT_KEY, (Object)editor.getLayout());
        editor.triggerLayoutChange(XamlSplitEditorSplitLayout.EDITOR_ONLY, true);
    }

    private static final Unit adviceMarkup$lambda$0(WpfPreviewHost this$0, WpfPreview $markupPreview, boolean hasErrors) {
        block1: {
            Set set = XamlEditorsManager.Companion.getInstance(this$0.project).getEditorsForPreview($markupPreview.getId());
            if (set == null) break block1;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XamlSplitEditor it = (XamlSplitEditor)element$iv;
                boolean bl = false;
                WpfPreviewEditor wpfPreviewEditor = this$0.wpfEditor(it);
                if (wpfPreviewEditor == null) continue;
                wpfPreviewEditor.handleErrorsInMarkup(hasErrors);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit adviceMarkup$lambda$1(WpfPreviewHost this$0, WpfPreview $markupPreview, WpfPreviewImage img) {
        block3: {
            if (img == null) break block3;
            Set set = XamlEditorsManager.Companion.getInstance(this$0.project).getEditorsForPreview($markupPreview.getId());
            if (set != null) {
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    XamlSplitEditor it = (XamlSplitEditor)element$iv;
                    boolean bl = false;
                    WpfPreviewEditor wpfPreviewEditor = this$0.wpfEditor(it);
                    if (wpfPreviewEditor != null) {
                        wpfPreviewEditor.updatePreviewImage(img);
                    }
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit adviceMarkup$lambda$2(WpfPreviewHost this$0, WpfPreview $markupPreview, PreviewHighlightingRect rect) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Set set = XamlEditorsManager.Companion.getInstance(this$0.project).getEditorsForPreview($markupPreview.getId());
            if (set == null) break block1;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XamlSplitEditor it = (XamlSplitEditor)element$iv;
                boolean bl = false;
                WpfPreviewEditor wpfPreviewEditor = this$0.wpfEditor(it);
                if (wpfPreviewEditor == null) continue;
                wpfPreviewEditor.drawRect(rect);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit adviceMarkup$lambda$3(WpfPreviewHost this$0, WpfPreview $markupPreview, WpfPreviewState state) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Set set = XamlEditorsManager.Companion.getInstance(this$0.project).getEditorsForPreview($markupPreview.getId());
            if (set == null) break block1;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XamlSplitEditor it = (XamlSplitEditor)element$iv;
                boolean bl = false;
                WpfPreviewEditor wpfPreviewEditor = this$0.wpfEditor(it);
                if (wpfPreviewEditor == null) continue;
                wpfPreviewEditor.updatePreviewStatus(state);
            }
        }
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"SavedXamlSplitEditorSplitLayout");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SAVED_LAYOUT_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/xaml/preview/WpfPreviewHost$Companion;", "", "<init>", "()V", "SAVED_LAYOUT_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/xaml/splitEditor/XamlSplitEditorSplitLayout;", "getInstance", "Lcom/jetbrains/rider/xaml/preview/WpfPreviewHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.xaml.preview"})
    @SourceDebugExtension(value={"SMAP\nWpfPreviewHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WpfPreviewHost.kt\ncom/jetbrains/rider/xaml/preview/WpfPreviewHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,94:1\n30#2,2:95\n*S KotlinDebug\n*F\n+ 1 WpfPreviewHost.kt\ncom/jetbrains/rider/xaml/preview/WpfPreviewHost$Companion\n*L\n22#1:95,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WpfPreviewHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WpfPreviewHost> serviceClass$iv = WpfPreviewHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WpfPreviewHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/xaml/preview/WpfPreviewHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/WpfPreviewModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.xaml.preview"})
    public static final class ProtocolListener
    implements SolutionExtListener<WpfPreviewModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull WpfPreviewModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            model.getAvailablePreviews().view(lifetime, (arg_0, arg_1) -> ProtocolListener.extensionCreated$lambda$0(session, arg_0, arg_1));
            WpfPreviewModel_PregeneratedKt.getWpfPreviewModel((Solution)SolutionHostExtensionsKt.getSolution((Project)session.getProject())).getPreviewIsEnabled().getChange().advise(lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$1(session, arg_0));
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, Lifetime previewLifetime, Map.Entry markupPreviewEntry) {
            Intrinsics.checkNotNullParameter((Object)previewLifetime, (String)"previewLifetime");
            Intrinsics.checkNotNullParameter((Object)markupPreviewEntry, (String)"markupPreviewEntry");
            WpfPreview markupPreview = (WpfPreview)markupPreviewEntry.getValue();
            Companion.getInstance($session.getProject()).adviceMarkup(previewLifetime, markupPreview);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$1(ClientProjectSession $session, boolean isEnabled) {
            Companion.getInstance($session.getProject()).isEnabledChanged(isEnabled);
            return Unit.INSTANCE;
        }
    }
}

