/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.run.configurations.gdscript;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.plugins.godot.GodotProjectDiscoverer;
import com.jetbrains.rider.plugins.godot.run.configurations.DebugSceneRunConfigurationProducerKt;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptConfigurationType;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunConfiguration;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunConfigurationHelper;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunFactory;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptStructuredArguments;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptSceneRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptRunConfiguration;", "<init>", "()V", "getConfigurationFactory", "Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptRunFactory;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGdScriptSceneRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdScriptSceneRunConfigurationProducer.kt\ncom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptSceneRunConfigurationProducer\n+ 2 runConfigurationType.kt\ncom/intellij/execution/configurations/RunConfigurationTypeKt\n*L\n1#1,44:1\n26#2:45\n*S KotlinDebug\n*F\n+ 1 GdScriptSceneRunConfigurationProducer.kt\ncom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptSceneRunConfigurationProducer\n*L\n14#1:45\n*E\n"})
public final class GdScriptSceneRunConfigurationProducer
extends LazyRunConfigurationProducer<GdScriptRunConfiguration> {
    @NotNull
    public GdScriptRunFactory getConfigurationFactory() {
        boolean $i$f$runConfigurationType = false;
        return ((GdScriptConfigurationType)ConfigurationTypeUtil.findConfigurationType(GdScriptConfigurationType.class)).getFactory();
    }

    public boolean isConfigurationFromContext(@NotNull GdScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GodotDescriptor godotDescriptor = (GodotDescriptor)GodotProjectDiscoverer.Companion.getInstance(project).getGodotDescriptor().getValueOrNull();
        if (godotDescriptor == null) {
            return false;
        }
        GodotDescriptor descriptor = godotDescriptor;
        if (!descriptor.isPureGdScriptProject()) {
            return false;
        }
        String basePath = descriptor.getMainProjectBasePath();
        Path path = Path.of(basePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        String string = DebugSceneRunConfigurationProducerKt.extractResPath(path, context);
        if (string == null) {
            return false;
        }
        String resPath = string;
        return Intrinsics.areEqual((Object)configuration.getStructured().getScene(), (Object)resPath);
    }

    protected boolean setupConfigurationFromContext(@NotNull GdScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiFile psiFile = DebugSceneRunConfigurationProducerKt.getContainingFile(context);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GodotDescriptor godotDescriptor = (GodotDescriptor)GodotProjectDiscoverer.Companion.getInstance(project).getGodotDescriptor().getValueOrNull();
        if (godotDescriptor == null) {
            return false;
        }
        GodotDescriptor descriptor = godotDescriptor;
        if (!descriptor.isPureGdScriptProject()) {
            return false;
        }
        String basePath = descriptor.getMainProjectBasePath();
        Path path = Path.of(basePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        String string = DebugSceneRunConfigurationProducerKt.extractResPath(path, context);
        if (string == null) {
            return false;
        }
        String resPath = string;
        GdScriptStructuredArguments structured = new GdScriptStructuredArguments(configuration.getStructured().getRequest(), configuration.getStructured().getDebugServerPort(), configuration.getStructured().getRemainingArguments(), resPath);
        configuration.setJson(GdScriptRunConfigurationHelper.INSTANCE.serialize(structured));
        configuration.setName(file.getName());
        return true;
    }
}

