/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.run.configurations.gdscript;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.dap.DapStartRequest;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunFactory;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptStructuredArguments;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u001c\u0010\b\u001a\u00020\u00062\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptRunConfigurationHelper;", "", "<init>", "()V", "parseArgumentsToMap", "", "", "text", "mapToPrettyJson", "map", "parse", "Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptStructuredArguments;", "serialize", "structured", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGdScriptRunConfigurationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdScriptRunConfigurationHelper.kt\ncom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptRunConfigurationHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,65:1\n23#2:66\n1#3:67\n216#4,2:68\n*S KotlinDebug\n*F\n+ 1 GdScriptRunConfigurationHelper.kt\ncom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptRunConfigurationHelper\n*L\n30#1:66\n61#1:68,2\n*E\n"})
public final class GdScriptRunConfigurationHelper {
    @NotNull
    public static final GdScriptRunConfigurationHelper INSTANCE = new GdScriptRunConfigurationHelper();

    private GdScriptRunConfigurationHelper() {
    }

    @NotNull
    public final Map<String, Object> parseArgumentsToMap(@NotNull String text) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return MapsKt.emptyMap();
        }
        String json = ((Object)StringsKt.trim((CharSequence)text)).toString();
        try {
            Map map2;
            ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true);
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            Object object = mapper.readValue(json, ((Map)new LinkedHashMap()).getClass());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            map = map2 = (Map)object;
        }
        catch (Exception exception) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public final String mapToPrettyJson(@NotNull Map<String, ? extends Object> map) {
        String string;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (map.isEmpty()) {
            return GdScriptRunFactory.Defaults.getDEFAULT_EMPTY_JSON();
        }
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        try {
            string = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            GdScriptRunConfigurationHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GdScriptRunConfigurationHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to serialize map to JSON: " + map, (Throwable)e);
            string = GdScriptRunFactory.Defaults.getDEFAULT_EMPTY_JSON();
        }
        return string;
    }

    @NotNull
    public final GdScriptStructuredArguments parse(@NotNull String text) {
        int n;
        Object v;
        String req;
        Object it;
        Map<String, Object> map;
        block9: {
            String string;
            block8: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                map = this.parseArgumentsToMap(text);
                Object object = map.get("request");
                string = object instanceof String ? (String)object : null;
                if (string == null) break block8;
                it = string;
                boolean bl = false;
                DapStartRequest dapStartRequest = DapStartRequest.valueOf((String)it);
                string = dapStartRequest;
                if (dapStartRequest != null) break block9;
            }
            string = req = DapStartRequest.Launch;
        }
        if ((v = map.get("debugServer")) instanceof Number) {
            n = ((Number)v).intValue();
        } else if (v instanceof String) {
            Integer n2 = StringsKt.toIntOrNull((String)((String)v));
            n = n2 != null ? n2 : 6006;
        } else {
            n = 6006;
        }
        int port = n;
        it = map.get("scene");
        String string = it instanceof String ? (String)it : null;
        if (string == null) {
            string = "main";
        }
        String scene = string;
        Object $this$parse_u24lambda_u241 = it = MapsKt.toMutableMap(map);
        boolean bl = false;
        $this$parse_u24lambda_u241.remove("request");
        $this$parse_u24lambda_u241.remove("debugServer");
        $this$parse_u24lambda_u241.remove("scene");
        Object rest = it;
        String restText = this.mapToPrettyJson((Map<String, ? extends Object>)rest);
        return new GdScriptStructuredArguments((DapStartRequest)req, port, restText, scene);
    }

    @NotNull
    public final String serialize(@NotNull GdScriptStructuredArguments structured) {
        Map<String, Object> rest;
        Intrinsics.checkNotNullParameter((Object)structured, (String)"structured");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"request", (Object)structured.getRequest()), TuplesKt.to((Object)"debugServer", (Object)structured.getDebugServerPort()), TuplesKt.to((Object)"scene", (Object)structured.getScene())};
        Map map = MapsKt.mutableMapOf((Pair[])pairArray);
        Map<String, Object> $this$forEach$iv = rest = this.parseArgumentsToMap(structured.getRemainingArguments());
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> entry = element$iv = iterator.next();
            boolean bl = false;
            String k = entry.getKey();
            Object v = entry.getValue();
            if (map.keySet().contains(k)) continue;
            map.put(k, v);
        }
        return this.mapToPrettyJson(map);
    }
}

