/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.run.configurations.gdscript;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunConfigJacksonObjectMapper;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunConfigurationHelper;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunConfigurationSettingsEditor;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunFactory;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptStructuredArguments;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0010\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&H\u0016R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptRunConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptRunFactory$GdScriptDebugConfigurationOptions;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/intellij/execution/configurations/WithoutOwnBeforeRunSteps;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "json", "getJson", "()Ljava/lang/String;", "setJson", "(Ljava/lang/String;)V", "structured", "Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptStructuredArguments;", "getStructured", "()Lcom/jetbrains/rider/plugins/godot/run/configurations/gdscript/GdScriptStructuredArguments;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getOptions", "writeExternal", "", "element", "Lorg/jdom/Element;", "readExternal", "hasMeaningfulContent", "", "jsonString", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.rider.plugins.godot"})
public final class GdScriptRunConfiguration
extends RunConfigurationBase<GdScriptRunFactory.GdScriptDebugConfigurationOptions>
implements RunConfigurationWithSuppressedDefaultRunAction,
WithoutOwnBeforeRunSteps {
    @NotNull
    private String json;

    public GdScriptRunConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(project, factory, name);
        this.json = GdScriptRunFactory.Defaults.getDEFAULT_FULL_JSON();
    }

    @NotNull
    public final String getJson() {
        return this.json;
    }

    public final void setJson(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.json = string;
    }

    @NotNull
    public final GdScriptStructuredArguments getStructured() {
        return GdScriptRunConfigurationHelper.INSTANCE.parse(this.json);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = EmptyRunProfileState.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)runProfileState, (String)"INSTANCE");
        return runProfileState;
    }

    @NotNull
    protected GdScriptRunFactory.GdScriptDebugConfigurationOptions getOptions() {
        RunConfigurationOptions runConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)runConfigurationOptions, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptRunFactory.GdScriptDebugConfigurationOptions");
        return (GdScriptRunFactory.GdScriptDebugConfigurationOptions)runConfigurationOptions;
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.getOptions().setJson(this.json);
        super.writeExternal(element);
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        String optionsJson = this.getOptions().getJson();
        CharSequence charSequence = optionsJson;
        this.json = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !this.hasMeaningfulContent(optionsJson) ? GdScriptRunFactory.Defaults.getDEFAULT_FULL_JSON() : optionsJson;
    }

    private final boolean hasMeaningfulContent(String jsonString) {
        try {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ObjectMapper mapper = GdScriptRunConfigJacksonObjectMapper.Companion.getService(project).getMapper();
            JsonNode node = mapper.readTree(jsonString);
            if (node == null || node.isNull()) {
                return false;
            }
            if (node.isObject() && node.size() == 0) {
                return false;
            }
            return !node.isArray() || node.size() != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new GdScriptRunConfigurationSettingsEditor(project);
    }
}

