/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.run.configurations;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.plugins.godot.Util;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\b"}, d2={"extractResPath", "", "basePath", "Ljava/nio/file/Path;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "intellij.rider.plugins.godot"})
public final class DebugSceneRunConfigurationProducerKt {
    @Nullable
    public static final String extractResPath(@NotNull Path basePath, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiFile psiFile = DebugSceneRunConfigurationProducerKt.getContainingFile(context);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        Path path = file.getVirtualFile().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        String relPath = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)path, (Path)basePath));
        return "res://" + relPath;
    }

    @Nullable
    public static final PsiFile getContainingFile(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return null;
        }
        PsiElement location = psiElement;
        PsiFile psiFile = location.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        if (!Util.Companion.isTscnFile(file.getVirtualFile())) {
            return null;
        }
        return file;
    }
}

