/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.run;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.godot.run.GodotRunConfigurationGenerator;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/godot/run/RunChickenTestsUtil;", "", "<init>", "()V", "Companion", "intellij.rider.plugins.godot"})
public final class RunChickenTestsUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/godot/run/RunChickenTestsUtil$Companion;", "", "<init>", "()V", "execute", "", "testIdentifier", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.godot"})
    public static final class Companion {
        private Companion() {
        }

        public final void execute(@NotNull String testIdentifier, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            RunManager runManager = RunManager.Companion.getInstance(project);
            DotNetExeConfigurationType configurationType = (DotNetExeConfigurationType)ConfigurationTypeUtil.findConfigurationType(DotNetExeConfigurationType.class);
            RunnerAndConfigurationSettings runConfiguration = runManager.findConfigurationByTypeAndName(configurationType.getId(), "Editor");
            if (runConfiguration == null) {
                throw new Exception("Godot Editor run configuration was not present.");
            }
            RunConfiguration runConfiguration2 = runConfiguration.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration2, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration");
            DotNetExeConfiguration configuration = (DotNetExeConfiguration)runConfiguration2;
            String programParameters = StringsKt.replace$default((String)configuration.getParameters().getProgramParameters(), (String)" --editor", (String)"", (boolean)false, (int)4, null) + " --run-tests=" + testIdentifier + " --quit-on-finish";
            RunnerAndConfigurationSettings testsConfig = GodotRunConfigurationGenerator.ProtocolListener.Companion.createOrUpdateCoreRunConfiguration("Debug test", programParameters, runManager, configuration.getParameters().getExePath(), project);
            RunConfiguration runConfiguration3 = testsConfig.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration3, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration");
            ((DotNetExeConfiguration)runConfiguration3).getParameters().setProgramParameters(programParameters);
            runManager.setSelectedConfiguration(testsConfig);
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)testsConfig, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

