/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.run;

import com.intellij.openapi.project.Project;
import com.jetbrains.rider.debugger.editAndContinue.DotNetEncInfoAutodetect;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.model.debuggerWorker.EncInfo;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.plugins.godot.GodotProjectDiscoverer;
import com.jetbrains.rider.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/godot/run/GodotDotNetEncInfoAutodetect;", "Lcom/jetbrains/rider/debugger/editAndContinue/DotNetEncInfoAutodetect;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "detectEncInfo", "Lcom/jetbrains/rider/model/debuggerWorker/EncInfo;", "dotNetCoreRuntime", "Lcom/jetbrains/rider/runtime/dotNetCore/DotNetCoreRuntime;", "riderDotNetActiveRuntimeHost", "Lcom/jetbrains/rider/runtime/RiderDotNetActiveRuntimeHost;", "exePath", "", "intellij.rider.plugins.godot"})
public final class GodotDotNetEncInfoAutodetect
implements DotNetEncInfoAutodetect {
    @NotNull
    private final Project project;

    public GodotDotNetEncInfoAutodetect(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public EncInfo detectEncInfo(@Nullable DotNetCoreRuntime dotNetCoreRuntime, @NotNull RiderDotNetActiveRuntimeHost riderDotNetActiveRuntimeHost, @NotNull String exePath) {
        Intrinsics.checkNotNullParameter((Object)riderDotNetActiveRuntimeHost, (String)"riderDotNetActiveRuntimeHost");
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        if (dotNetCoreRuntime == null) {
            return null;
        }
        if (GodotProjectDiscoverer.Companion.getInstance(this.project).getGodot4Path().getValue() != null && riderDotNetActiveRuntimeHost.getActiveDotNetSdkVersion() != null) {
            GodotProjectDiscoverer discoverer = GodotProjectDiscoverer.Companion.getInstance(this.project);
            GodotDescriptor godotDescriptor = (GodotDescriptor)discoverer.getGodotDescriptor().getValueOrNull();
            if (godotDescriptor == null || (godotDescriptor = godotDescriptor.getTfm()) == null) {
                return null;
            }
            GodotDescriptor tfm = godotDescriptor;
            return new EncInfo((RdTargetFrameworkId)tfm);
        }
        return null;
    }
}

