/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.lang.service;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.lsp.api.Lsp4jClient;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerNotificationsHandler;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.plugins.godot.GodotProjectDiscoverer;
import com.jetbrains.rider.plugins.godot.lang.service.GodotLspNotification;
import com.jetbrains.rider.plugins.godot.lang.service.GodotLspServerSupportProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLsp4jClient;", "Lcom/intellij/platform/lsp/api/Lsp4jClient;", "handler", "Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;Lcom/intellij/openapi/project/Project;)V", "changeWorkspace", "", "params", "Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLsp4jClient$GodotChangeWorkspaceParams;", "GodotChangeWorkspaceParams", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotLsp4jClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotLsp4jClient.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLsp4jClient\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n23#2:41\n23#2:43\n1#3:42\n*S KotlinDebug\n*F\n+ 1 GodotLsp4jClient.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLsp4jClient\n*L\n26#1:41\n33#1:43\n*E\n"})
public final class GodotLsp4jClient
extends Lsp4jClient {
    @NotNull
    private final Project project;

    public GodotLsp4jClient(@NotNull LspServerNotificationsHandler handler, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(handler);
        this.project = project;
    }

    @JsonNotification(value="gdscript_client/changeWorkspace")
    private final void changeWorkspace(GodotChangeWorkspaceParams params) {
        Path path;
        GodotLsp4jClient $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GodotLsp4jClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Received gdscript_client/changeWorkspace notification with path: " + params.getPath());
        GodotProjectDiscoverer discoverer = GodotProjectDiscoverer.Companion.getInstance(this.project);
        Object object = (GodotDescriptor)discoverer.getGodotDescriptor().getValueOrNull();
        if (object != null && (object = ((GodotDescriptor)object).getMainProjectBasePath()) != null) {
            Object it = object;
            boolean bl = false;
            Path path2 = Paths.get((String)it, new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        } else {
            path = null;
        }
        Path godotBasePath = path;
        Path path3 = Paths.get(params.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        Path workspacePath = path3;
        if (!Intrinsics.areEqual((Object)godotBasePath, (Object)workspacePath)) {
            GodotLsp4jClient $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(GodotLsp4jClient.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Workspace path " + workspacePath + " doesn't match Godot base path " + godotBasePath + ", disconnecting LSP server");
            GodotLspNotification.Companion.getService(this.project).showNonMatchingProjectWarning();
            LspServerManager.Companion.getInstance(this.project).stopServers(GodotLspServerSupportProvider.class);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLsp4jClient$GodotChangeWorkspaceParams;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "intellij.rider.plugins.godot"})
    private static final class GodotChangeWorkspaceParams {
        @NotNull
        private final String path;

        public GodotChangeWorkspaceParams(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }
    }
}

