/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.model.godot.frontendBackend.GodotFrontendBackendModel;
import com.jetbrains.rider.model.godot.frontendBackend.LanguageServerConnectionMode;
import com.jetbrains.rider.plugins.godot.GodotMetadataFileWatcherUtil;
import com.jetbrains.rider.plugins.godot.GodotProjectLifetimeService;
import com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration;
import com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfigurationType;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0019\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0019\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0019\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\nR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010*\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "godotDescriptor", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "Lcom/jetbrains/rider/model/godot/frontendBackend/GodotDescriptor;", "getGodotDescriptor", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "lspConnectionMode", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/rider/model/godot/frontendBackend/LanguageServerConnectionMode;", "getLspConnectionMode", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "remoteHostPort", "", "getRemoteHostPort", "useDynamicPort", "", "getUseDynamicPort", "godot3Path", "", "getGodot3Path", "godot4Path", "getGodot4Path", "godotPath", "getGodotPath", "mainProjectBasePath", "Lkotlinx/coroutines/CompletableDeferred;", "Ljava/nio/file/Path;", "getMainProjectBasePath", "()Lkotlinx/coroutines/CompletableDeferred;", "isGodotProject", "projectMetadataModificationSignal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "", "getProjectMetadataModificationSignal", "()Lcom/jetbrains/rd/util/reactive/ISignal;", "getGodotPathFromCorePlayerRunConfiguration", "getGodotPathFromPlayerRunConfiguration", "port", "getPort", "()I", "Companion", "ProtocolListener", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotProjectDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,136:1\n295#2,2:137\n295#2,2:139\n23#3:141\n*S KotlinDebug\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer\n*L\n73#1:137,2\n86#1:139,2\n57#1:141\n*E\n"})
public final class GodotProjectDiscoverer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IOptProperty<GodotDescriptor> godotDescriptor;
    @NotNull
    private final IProperty<LanguageServerConnectionMode> lspConnectionMode;
    @NotNull
    private final IProperty<Integer> remoteHostPort;
    @NotNull
    private final IProperty<Boolean> useDynamicPort;
    @NotNull
    private final IProperty<String> godot3Path;
    @NotNull
    private final IProperty<String> godot4Path;
    @NotNull
    private final IOptProperty<String> godotPath;
    @NotNull
    private final CompletableDeferred<Path> mainProjectBasePath;
    @NotNull
    private final CompletableDeferred<Boolean> isGodotProject;
    @NotNull
    private final ISignal<Unit> projectMetadataModificationSignal;
    private final int port;

    public GodotProjectDiscoverer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.godotDescriptor = (IOptProperty)new OptProperty();
        this.lspConnectionMode = (IProperty)new Property(null);
        this.remoteHostPort = (IProperty)new Property(null);
        this.useDynamicPort = (IProperty)new Property(null);
        this.godot3Path = (IProperty)new Property(null);
        this.godot4Path = (IProperty)new Property(null);
        this.godotPath = (IOptProperty)new OptProperty();
        this.mainProjectBasePath = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.isGodotProject = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.projectMetadataModificationSignal = (ISignal)new Signal();
        Lifetime lifetime = GodotProjectLifetimeService.Companion.getLifetime(project);
        SourceExKt.adviseNotNull((ISource)((ISource)this.godot3Path), (Lifetime)lifetime, arg_0 -> GodotProjectDiscoverer._init_$lambda$0(this, arg_0));
        SourceExKt.adviseNotNull((ISource)((ISource)this.godot4Path), (Lifetime)lifetime, arg_0 -> GodotProjectDiscoverer._init_$lambda$1(this, arg_0));
        SourceExKt.adviseNotNull((ISource)((ISource)this.godotDescriptor), (Lifetime)lifetime, arg_0 -> GodotProjectDiscoverer._init_$lambda$2(this, lifetime, project, arg_0));
        this.port = 23685;
    }

    @NotNull
    public final IOptProperty<GodotDescriptor> getGodotDescriptor() {
        return this.godotDescriptor;
    }

    @NotNull
    public final IProperty<LanguageServerConnectionMode> getLspConnectionMode() {
        return this.lspConnectionMode;
    }

    @NotNull
    public final IProperty<Integer> getRemoteHostPort() {
        return this.remoteHostPort;
    }

    @NotNull
    public final IProperty<Boolean> getUseDynamicPort() {
        return this.useDynamicPort;
    }

    @NotNull
    public final IProperty<String> getGodot3Path() {
        return this.godot3Path;
    }

    @NotNull
    public final IProperty<String> getGodot4Path() {
        return this.godot4Path;
    }

    @NotNull
    public final IOptProperty<String> getGodotPath() {
        return this.godotPath;
    }

    @NotNull
    public final CompletableDeferred<Path> getMainProjectBasePath() {
        return this.mainProjectBasePath;
    }

    @NotNull
    public final CompletableDeferred<Boolean> isGodotProject() {
        return this.isGodotProject;
    }

    @NotNull
    public final ISignal<Unit> getProjectMetadataModificationSignal() {
        return this.projectMetadataModificationSignal;
    }

    private final String getGodotPathFromCorePlayerRunConfiguration(Project project) {
        Object v0;
        block4: {
            RunManager runManager = RunManager.Companion.getInstance(project);
            Iterable $this$firstOrNull$iv = runManager.getAllSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(it.getType() instanceof DotNetExeConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)"Player"))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        RunnerAndConfigurationSettings playerSettings = v0;
        if (playerSettings != null) {
            RunConfiguration runConfiguration = playerSettings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration");
            DotNetExeConfiguration config = (DotNetExeConfiguration)runConfiguration;
            String path = config.getParameters().getExePath();
            if (((CharSequence)path).length() > 0) {
                Path path2 = Paths.get(path, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return path;
                }
            }
        }
        return null;
    }

    private final String getGodotPathFromPlayerRunConfiguration(Project project) {
        Object v0;
        block4: {
            RunManager runManager = RunManager.Companion.getInstance(project);
            Iterable $this$firstOrNull$iv = runManager.getAllSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(it.getType() instanceof GodotDebugRunConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)"Player"))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        RunnerAndConfigurationSettings playerSettings = v0;
        if (playerSettings != null) {
            RunConfiguration runConfiguration = playerSettings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration");
            GodotDebugRunConfiguration config = (GodotDebugRunConfiguration)runConfiguration;
            String path = config.getParameters().getExePath();
            if (((CharSequence)path).length() > 0) {
                Path path2 = Paths.get(path, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return path;
                }
            }
        }
        return null;
    }

    public final int getPort() {
        return this.port;
    }

    private static final Unit _init_$lambda$0(GodotProjectDiscoverer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.godotPath.set((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GodotProjectDiscoverer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.godotPath.set((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(GodotProjectDiscoverer this$0, Lifetime $lifetime, Project $project, GodotDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GodotProjectDiscoverer $this$thisLogger$iv = this$0;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GodotProjectDiscoverer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Godot godotDescriptor: " + it);
        Path path = Paths.get(it.getMainProjectBasePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path basePath = path;
        LifetimeCoroutineUtilKt.launch$default((Lifetime)$lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(basePath, this$0, $project, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ Path $basePath;
            final /* synthetic */ GodotProjectDiscoverer this$0;
            final /* synthetic */ Project $project;
            {
                this.$basePath = $basePath;
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        String g3path;
                        ResultKt.throwOnFailure((Object)$result);
                        String string2 = GodotMetadataFileWatcherUtil.INSTANCE.getFromMonoMetadataPath(this.$basePath);
                        if (string2 == null && (string2 = GodotMetadataFileWatcherUtil.INSTANCE.getGodot3Path(this.$basePath)) == null) {
                            string2 = g3path = GodotProjectDiscoverer.access$getGodotPathFromPlayerRunConfiguration(this.this$0, this.$project);
                        }
                        if ((string = GodotMetadataFileWatcherUtil.INSTANCE.getGodot4Path(this.$basePath)) == null) {
                            string = GodotProjectDiscoverer.access$getGodotPathFromCorePlayerRunConfiguration(this.this$0, this.$project);
                        }
                        String g4path = string;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)g3path);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)g4path);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, g3path, g4path, null){
                            int label;
                            final /* synthetic */ GodotProjectDiscoverer this$0;
                            final /* synthetic */ String $g3path;
                            final /* synthetic */ String $g4path;
                            {
                                this.this$0 = $receiver;
                                this.$g3path = $g3path;
                                this.$g4path = $g4path;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.this$0.getGodot3Path().set((Object)this.$g3path);
                                        this.this$0.getGodot4Path().set((Object)this.$g4path);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        String g4path = (String)this.L$1;
                        String g3path = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getGodotPathFromPlayerRunConfiguration(GodotProjectDiscoverer $this, Project project) {
        return $this.getGodotPathFromPlayerRunConfiguration(project);
    }

    public static final /* synthetic */ String access$getGodotPathFromCorePlayerRunConfiguration(GodotProjectDiscoverer $this, Project project) {
        return $this.getGodotPathFromCorePlayerRunConfiguration(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotProjectDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,136:1\n17#2,2:137\n*S KotlinDebug\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion\n*L\n100#1:137,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GodotProjectDiscoverer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$getService$iv = (ComponentManager)project;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(GodotProjectDiscoverer.class);
            if (object == null) {
                throw new IllegalStateException("Service " + GodotProjectDiscoverer.class + " not found in container " + $this$getService$iv);
            }
            return (GodotProjectDiscoverer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/godot/frontendBackend/GodotFrontendBackendModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.godot"})
    public static final class ProtocolListener
    implements SolutionExtListener<GodotFrontendBackendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull GodotFrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            model.isGodotProject().advise(lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$0(session, arg_0));
            model.getGodotDescriptor().advise(lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$1(session, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getLspConnectionMode()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$2(session, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getRemoteHostPort()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$3(session, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getUseDynamicPort()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$4(session, arg_0));
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, boolean it) {
            Companion.getInstance($session.getProject()).isGodotProject().complete((Object)it);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$1(ClientProjectSession $session, GodotDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.getInstance($session.getProject()).getGodotDescriptor().set((Object)it);
            CompletableDeferred<Path> completableDeferred = Companion.getInstance($session.getProject()).getMainProjectBasePath();
            Path path = Paths.get(it.getMainProjectBasePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            completableDeferred.complete((Object)path);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$2(ClientProjectSession $session, LanguageServerConnectionMode it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            Companion.getInstance($session.getProject()).getLspConnectionMode().set((Object)it);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$3(ClientProjectSession $session, int it) {
            Companion.getInstance($session.getProject()).getRemoteHostPort().set((Object)it);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$4(ClientProjectSession $session, boolean it) {
            Companion.getInstance($session.getProject()).getUseDynamicPort().set((Object)it);
            return Unit.INSTANCE;
        }
    }
}

