/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot;

import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007J\f\u0010\n\u001a\u00020\u0005*\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotMetadataFileWatcherUtil;", "", "<init>", "()V", "getFromMonoMetadataPath", "", "basePath", "Ljava/nio/file/Path;", "getGodot3Path", "projectPath", "md5", "getGodot4Path", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotMetadataFileWatcherUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotMetadataFileWatcherUtil.kt\ncom/jetbrains/rider/plugins/godot/GodotMetadataFileWatcherUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n669#2,11:84\n669#2,11:95\n*S KotlinDebug\n*F\n+ 1 GodotMetadataFileWatcherUtil.kt\ncom/jetbrains/rider/plugins/godot/GodotMetadataFileWatcherUtil\n*L\n54#1:84,11\n74#1:95,11\n*E\n"})
public final class GodotMetadataFileWatcherUtil {
    @NotNull
    public static final GodotMetadataFileWatcherUtil INSTANCE = new GodotMetadataFileWatcherUtil();

    private GodotMetadataFileWatcherUtil() {
    }

    @Nullable
    public final String getFromMonoMetadataPath(@NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Path metaFile = basePath.resolve(".mono/metadata/ide_server_meta.txt");
        Intrinsics.checkNotNull((Object)metaFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(metaFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path path = metaFile;
        List<String> list = Files.readAllLines(path, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
        List<String> lines = list;
        if (((Collection)lines).size() < 2) {
            return null;
        }
        if (Paths.get(lines.get(1), new String[0]).toFile().exists()) {
            return lines.get(1);
        }
        return null;
    }

    @Nullable
    public final String getGodot3Path(@NotNull Path projectPath) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (SystemInfo.isMac) {
            home = Paths.get(System.getenv("HOME"), new String[0]);
            path = home.resolve("Library/Application Support/Godot/projects");
        } else if (SystemInfo.isLinux) {
            home = Paths.get(System.getenv("HOME"), new String[0]);
            path = home.resolve(".config/godot/projects");
        } else if (SystemInfo.isWindows) {
            Path appData = Paths.get(System.getenv("APPDATA"), new String[0]);
            path = appData.resolve("Godot/projects");
        } else {
            throw new Exception("Unexpected OS.");
        }
        Path projectsSettingsPath = path;
        String md5 = this.md5(((Object)projectPath).toString());
        Path projectSettingsPath = projectsSettingsPath.resolve(projectPath.getFileName() + "-" + md5);
        File projectMetadataCfg = projectSettingsPath.resolve("project_metadata.cfg").toFile();
        if (projectMetadataCfg.exists()) {
            Object v1;
            block11: {
                Intrinsics.checkNotNull((Object)projectMetadataCfg);
                Iterable $this$singleOrNull$iv = FilesKt.readLines$default((File)projectMetadataCfg, null, (int)1, null);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"executable_path=", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block11;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            String line = v1;
            if (line != null) {
                String string = line.substring(17, ((Object)StringsKt.trimEnd((CharSequence)line)).toString().length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String path2 = string;
                if (Paths.get(path2, new String[0]).toFile().exists()) {
                    return path2;
                }
            }
        }
        return null;
    }

    private final String md5(String $this$md5) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = new BigInteger(1, md.digest(byArray)).toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return StringsKt.padStart((String)string2, (int)32, (char)'0');
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getGodot4Path(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Path projectMetadataCfg = projectPath.resolve(".godot/editor/project_metadata.cfg");
        Intrinsics.checkNotNull((Object)projectMetadataCfg);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(projectMetadataCfg, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object v2;
            block5: {
                void $this$singleOrNull$iv;
                Iterable<Path> iterable = projectMetadataCfg;
                List<String> list = Files.readAllLines(iterable, Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                iterable = list;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"executable_path=", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            String line = v2;
            if (line != null) {
                String string = line.substring(17, ((Object)StringsKt.trimEnd((CharSequence)line)).toString().length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String path = string;
                if (Paths.get(path, new String[0]).toFile().exists()) {
                    return path;
                }
            }
        }
        return null;
    }
}

