/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.states.common;

import com.jetbrains.wormhole.AssertionsKt;
import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.states.StateFactory;
import com.jetbrains.wormhole.states.WormholeState;
import com.jetbrains.wormhole.states.verifiers.WindowOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.AttachOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.UnknownRootEmbedOperationVerifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0001H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/wormhole/states/common/IntermediateTargetState;", "Lcom/jetbrains/wormhole/states/WormholeState;", "targetWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "stateFactory", "Lcom/jetbrains/wormhole/states/StateFactory;", "(Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/Platform;Lcom/jetbrains/wormhole/states/StateFactory;)V", "attachOperationVerifier", "Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "getAttachOperationVerifier", "()Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "embedOperationVerifier", "getEmbedOperationVerifier", "getStateFactory", "()Lcom/jetbrains/wormhole/states/StateFactory;", "attachToRoot", "hostWindowId", "isShowing", "", "detachFromRoot", "restorePreviousWindowState", "embedWindow", "unembedWindow", "component"})
public class IntermediateTargetState
extends WormholeState {
    @NotNull
    private final WindowOperationVerifier embedOperationVerifier;
    @NotNull
    private final WindowOperationVerifier attachOperationVerifier;
    private final WindowId targetWindowId;
    @NotNull
    private final StateFactory stateFactory;

    @Override
    @NotNull
    public WindowOperationVerifier getEmbedOperationVerifier() {
        return this.embedOperationVerifier;
    }

    @Override
    @NotNull
    public WindowOperationVerifier getAttachOperationVerifier() {
        return this.attachOperationVerifier;
    }

    @Override
    @NotNull
    public WormholeState embedWindow(@NotNull WindowId targetWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        return this.stateFactory.intermediateTargetState(targetWindowId);
    }

    @Override
    @NotNull
    public WormholeState unembedWindow() {
        return this.stateFactory.initialState();
    }

    @Override
    @NotNull
    public WormholeState attachToRoot(@NotNull WindowId hostWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        return isShowing ? this.stateFactory.finalState(this.targetWindowId, hostWindowId) : this.stateFactory.hiddenState(this.targetWindowId, hostWindowId);
    }

    @Override
    @NotNull
    public WormholeState detachFromRoot(boolean restorePreviousWindowState) {
        AssertionsKt.assert("Detaching root in " + "<init>" + " state looks suspicious");
        return this;
    }

    @NotNull
    protected final StateFactory getStateFactory() {
        return this.stateFactory;
    }

    public IntermediateTargetState(@NotNull WindowId targetWindowId, @NotNull Platform platform, @NotNull StateFactory stateFactory) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        this.targetWindowId = targetWindowId;
        this.stateFactory = stateFactory;
        this.embedOperationVerifier = new UnknownRootEmbedOperationVerifier(platform);
        this.attachOperationVerifier = new AttachOperationVerifier(this.targetWindowId, platform);
    }
}

