/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.states;

import com.jetbrains.states.State;
import com.jetbrains.states.StateMachine;
import com.jetbrains.wormhole.WormholeOperations;
import com.jetbrains.wormhole.events.Event;
import com.jetbrains.wormhole.events.EventBus;
import com.jetbrains.wormhole.events.WormholeEvent;
import com.jetbrains.wormhole.events.WormholeEventArgument;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.states.StateFactory;
import com.jetbrains.wormhole.states.WormholeState;
import com.jetbrains.wormhole.states.common.DeadTargetState;
import com.jetbrains.wormhole.states.common.IntermediateRootState;
import com.jetbrains.wormhole.swing.states.FinalState;
import com.jetbrains.wormhole.swing.states.IntermediateInitializedTargetState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/wormhole/states/WormholeStateMachine;", "Lcom/jetbrains/states/StateMachine;", "Lcom/jetbrains/wormhole/states/WormholeState;", "Lcom/jetbrains/wormhole/WormholeOperations;", "stateFactory", "Lcom/jetbrains/wormhole/states/StateFactory;", "eventBus", "Lcom/jetbrains/wormhole/events/EventBus;", "(Lcom/jetbrains/wormhole/states/StateFactory;Lcom/jetbrains/wormhole/events/EventBus;)V", "attachToRoot", "", "hostWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "isShowing", "", "detachFromRoot", "hideTargetOnRootDetach", "embedWindow", "targetWindowId", "hideComponent", "onStateChanged", "to", "onTargetDead", "showComponent", "unembedWindow", "component"})
public final class WormholeStateMachine
extends StateMachine<WormholeState>
implements WormholeOperations {
    private final EventBus eventBus;

    @Override
    public void embedWindow(@NotNull WindowId targetWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        this.switchTo((State)((WormholeState)this.getCurrentState()).embedWindow(targetWindowId, isShowing));
    }

    @Override
    public void unembedWindow() {
        this.switchTo((State)((WormholeState)this.getCurrentState()).unembedWindow());
    }

    @Override
    public void attachToRoot(@NotNull WindowId hostWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        this.switchTo((State)((WormholeState)this.getCurrentState()).attachToRoot(hostWindowId, isShowing));
    }

    @Override
    public void detachFromRoot(boolean hideTargetOnRootDetach) {
        this.switchTo((State)((WormholeState)this.getCurrentState()).detachFromRoot(hideTargetOnRootDetach));
    }

    @Override
    public void showComponent() {
        this.switchTo((State)((WormholeState)this.getCurrentState()).show());
    }

    @Override
    public void hideComponent() {
        this.switchTo((State)((WormholeState)this.getCurrentState()).hide());
    }

    @Override
    public void onTargetDead() {
        this.switchTo((State)((WormholeState)this.getCurrentState()).onTargetDead());
    }

    @Override
    protected void onStateChanged(@NotNull WormholeState to) {
        block1: {
            WormholeState wormholeState;
            block3: {
                block2: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                        wormholeState = to;
                        if (!(wormholeState instanceof FinalState)) break block0;
                        this.eventBus.fire((Event)WormholeEvent.Companion.getEmbeddedWindowShowed(), WormholeEventArgument.EmptyArgument.INSTANCE);
                        break block1;
                    }
                    if (!(wormholeState instanceof DeadTargetState)) break block2;
                    this.eventBus.fire((Event)WormholeEvent.Companion.getEmbeddedWindowDead(), WormholeEventArgument.EmptyArgument.INSTANCE);
                    break block1;
                }
                if (!(wormholeState instanceof IntermediateInitializedTargetState)) break block3;
                this.eventBus.fire((Event)WormholeEvent.Companion.getEmbeddedWindowHidden(), WormholeEventArgument.EmptyArgument.INSTANCE);
                break block1;
            }
            if (!(wormholeState instanceof IntermediateRootState)) break block1;
            this.eventBus.fire((Event)WormholeEvent.Companion.getAttachedToRoot(), new WormholeEventArgument.WindowId(((IntermediateRootState)to).getHostWindowId()));
        }
    }

    public WormholeStateMachine(@NotNull StateFactory stateFactory, @NotNull EventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        super((State)stateFactory.initialState());
        this.eventBus = eventBus;
    }
}

