/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.interop.windows.keyboard;

import com.jetbrains.wormhole.interop.windows.keyboard.KeyboardHookToken;
import com.jetbrains.wormhole.interop.windows.keyboard.WindowsKeyboardHookInstaller;
import com.jetbrains.wormhole.interop.windows.libraries.Kernel32Kt;
import com.jetbrains.wormhole.interop.windows.libraries.User32Kt;
import com.jetbrains.wormhole.logging.LogLevel;
import com.jetbrains.wormhole.logging.Logger;
import com.jetbrains.wormhole.logging.LoggerKt;
import com.jetbrains.wormhole.logging.NoOperationLogger;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHookInstaller;", "", "logger", "Lcom/jetbrains/wormhole/logging/Logger;", "(Lcom/jetbrains/wormhole/logging/Logger;)V", "handle", "Lcom/sun/jna/platform/win32/WinDef$HMODULE;", "kotlin.jvm.PlatformType", "installHook", "Lcom/jetbrains/wormhole/interop/windows/keyboard/KeyboardHookToken;", "hook", "Lcom/sun/jna/platform/win32/WinUser$LowLevelKeyboardProc;", "Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHook;", "InnerKeyboardHookToken", "KeyboardHookThread", "interop"})
public final class WindowsKeyboardHookInstaller {
    private final WinDef.HMODULE handle;
    private final Logger logger;

    @NotNull
    public final KeyboardHookToken installHook(@NotNull WinUser.LowLevelKeyboardProc hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        KeyboardHookThread keyboardHookThread = new KeyboardHookThread(hook);
        keyboardHookThread.start();
        return new InnerKeyboardHookToken(keyboardHookThread);
    }

    public WindowsKeyboardHookInstaller(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.handle = Kernel32Kt.getKernel32().GetModuleHandle(null);
    }

    public /* synthetic */ WindowsKeyboardHookInstaller(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = NoOperationLogger.INSTANCE;
        }
        this(logger);
    }

    public WindowsKeyboardHookInstaller() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHookInstaller$InnerKeyboardHookToken;", "Lcom/jetbrains/wormhole/interop/windows/keyboard/KeyboardHookToken;", "hookThread", "Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHookInstaller$KeyboardHookThread;", "Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHookInstaller;", "(Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHookInstaller;Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHookInstaller$KeyboardHookThread;)V", "remove", "", "interop"})
    private final class InnerKeyboardHookToken
    implements KeyboardHookToken {
        private final KeyboardHookThread hookThread;

        @Override
        public void remove() {
            this.hookThread.removeHook();
        }

        public InnerKeyboardHookToken(KeyboardHookThread hookThread) {
            Intrinsics.checkNotNullParameter((Object)hookThread, (String)"hookThread");
            this.hookThread = hookThread;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHookInstaller$KeyboardHookThread;", "Ljava/lang/Thread;", "hook", "Lcom/sun/jna/platform/win32/WinUser$LowLevelKeyboardProc;", "Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHook;", "(Lcom/jetbrains/wormhole/interop/windows/keyboard/WindowsKeyboardHookInstaller;Lcom/sun/jna/platform/win32/WinUser$LowLevelKeyboardProc;)V", "hookThreadId", "Lcom/sun/jna/platform/win32/WinDef$DWORD;", "isHookActive", "", "removeHook", "", "run", "interop"})
    private final class KeyboardHookThread
    extends Thread {
        private WinDef.DWORD hookThreadId;
        private boolean isHookActive;
        private final WinUser.LowLevelKeyboardProc hook;

        @Override
        public void run() {
            this.hookThreadId = new WinDef.DWORD((long)Kernel32Kt.getKernel32().GetCurrentThreadId());
            this.isHookActive = true;
            WinUser.HHOOK hHOOK = User32Kt.getUser32().SetWindowsHookEx(13, (WinUser.HOOKPROC)this.hook, (WinDef.HINSTANCE)WindowsKeyboardHookInstaller.this.handle, 0);
            LoggerKt.lazyLog(WindowsKeyboardHookInstaller.this.logger, LogLevel.DEBUG, (Function0<String>)((Function0)run.1.INSTANCE));
            WinUser.MSG mSG = new WinUser.MSG();
            while (this.isHookActive) {
                User32Kt.getUser32().GetMessage(mSG, null, 0, 0);
            }
            User32Kt.getUser32().UnhookWindowsHookEx(hHOOK);
            LoggerKt.lazyLog(WindowsKeyboardHookInstaller.this.logger, LogLevel.DEBUG, (Function0<String>)((Function0)run.2.INSTANCE));
        }

        public final void removeHook() {
            this.isHookActive = false;
            User32 user32 = User32Kt.getUser32();
            WinDef.DWORD dWORD = this.hookThreadId;
            if (dWORD == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hookThreadId");
            }
            user32.PostThreadMessage(dWORD.intValue(), 15, null, null);
        }

        public KeyboardHookThread(WinUser.LowLevelKeyboardProc hook) {
            Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
            this.hook = hook;
        }
    }
}

