/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.interop.windows;

import com.jetbrains.wormhole.SystemEnvironmentProvider;
import com.jetbrains.wormhole.events.EventBus;
import com.jetbrains.wormhole.interop.MainThreadScheduler;
import com.jetbrains.wormhole.interop.NativeWindowProxy;
import com.jetbrains.wormhole.interop.NativeWindowProxyFactory;
import com.jetbrains.wormhole.interop.ReadOnlyNativeWindowProxy;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.interop.windows.CreatedWindowWindowsNativeWindowProxy;
import com.jetbrains.wormhole.interop.windows.ExistingWindowWindowsNativeWindowProxy;
import com.jetbrains.wormhole.interop.windows.ReadOnlyWindowsNativeWindowProxy;
import com.jetbrains.wormhole.interop.windows.ShellMessageReader;
import com.jetbrains.wormhole.interop.windows.WindowClassInfo;
import com.jetbrains.wormhole.interop.windows.WindowProc;
import com.jetbrains.wormhole.interop.windows.WindowsNativeWindowProxy;
import com.jetbrains.wormhole.interop.windows.WindowsWindowId;
import com.jetbrains.wormhole.interop.windows.WindowsWindowIdKt;
import com.jetbrains.wormhole.interop.windows.libraries.Kernel32Kt;
import com.jetbrains.wormhole.interop.windows.libraries.User32Kt;
import com.jetbrains.wormhole.logging.Logger;
import com.sun.jna.Callback;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/wormhole/interop/windows/WindowsNativeWindowProxyFactory;", "Lcom/jetbrains/wormhole/interop/NativeWindowProxyFactory;", "eventBus", "Lcom/jetbrains/wormhole/events/EventBus;", "systemEnvironmentProvider", "Lcom/jetbrains/wormhole/SystemEnvironmentProvider;", "logger", "Lcom/jetbrains/wormhole/logging/Logger;", "(Lcom/jetbrains/wormhole/events/EventBus;Lcom/jetbrains/wormhole/SystemEnvironmentProvider;Lcom/jetbrains/wormhole/logging/Logger;)V", "shellMessageReader", "Lcom/jetbrains/wormhole/interop/windows/ShellMessageReader;", "windowProc", "Lcom/jetbrains/wormhole/interop/windows/WindowProc;", "canGetProxyForExistingWindow", "Lkotlin/Pair;", "", "", "windowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "create", "Lcom/jetbrains/wormhole/interop/NativeWindowProxy;", "className", "parentWindow", "Lcom/jetbrains/wormhole/interop/ReadOnlyNativeWindowProxy;", "mainThreadScheduler", "Lcom/jetbrains/wormhole/interop/MainThreadScheduler;", "find", "getProxyForExistingWindow", "interop"})
public final class WindowsNativeWindowProxyFactory
extends NativeWindowProxyFactory {
    private final WindowProc windowProc;
    private final ShellMessageReader shellMessageReader;
    private final SystemEnvironmentProvider systemEnvironmentProvider;
    private final Logger logger;

    @Override
    @NotNull
    public NativeWindowProxy create(@NotNull String className, @Nullable ReadOnlyNativeWindowProxy parentWindow, @NotNull MainThreadScheduler mainThreadScheduler) {
        Object object;
        block0: {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)mainThreadScheduler, (String)"mainThreadScheduler");
            WinDef.HMODULE hMODULE = Kernel32Kt.getKernel32().GetModuleHandle(null);
            WinUser.WNDCLASSEX wNDCLASSEX = new WinUser.WNDCLASSEX();
            boolean bl = false;
            boolean bl2 = false;
            WinUser.WNDCLASSEX wNDCLASSEX2 = wNDCLASSEX;
            boolean bl3 = false;
            wNDCLASSEX2.hInstance = (WinDef.HINSTANCE)hMODULE;
            wNDCLASSEX2.lpfnWndProc = (Callback)this.windowProc;
            wNDCLASSEX2.lpszClassName = className;
            WinUser.WNDCLASSEX wNDCLASSEX3 = wNDCLASSEX;
            User32Kt.getUser32().RegisterClassEx(wNDCLASSEX3);
            object = User32Kt.getUser32().CreateWindowEx(0, className, className, 0x10000000, 0, 0, 0, 0, null, null, (WinDef.HINSTANCE)hMODULE, null);
            bl2 = false;
            boolean bl4 = false;
            WinDef.HWND hWND = object;
            boolean bl5 = false;
            User32Kt.getUser32().SetLayeredWindowAttributes(hWND, 0, (byte)128, 2);
            WinDef.HWND hWND2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)hWND2, (String)"user32.CreateWindowEx(\n \u2026, 0, 128.toByte(), 0x2) }");
            wNDCLASSEX = hWND2;
            WinDef.HMODULE hMODULE2 = hMODULE;
            Intrinsics.checkNotNullExpressionValue((Object)hMODULE2, (String)"hInst");
            object = new CreatedWindowWindowsNativeWindowProxy((WinDef.HWND)wNDCLASSEX, this.logger, new WindowClassInfo(className, hMODULE2), mainThreadScheduler, this.shellMessageReader, this.systemEnvironmentProvider);
            ReadOnlyNativeWindowProxy readOnlyNativeWindowProxy = parentWindow;
            if (readOnlyNativeWindowProxy == null) break block0;
            ReadOnlyNativeWindowProxy readOnlyNativeWindowProxy2 = readOnlyNativeWindowProxy;
            bl4 = false;
            boolean bl6 = false;
            ReadOnlyNativeWindowProxy readOnlyNativeWindowProxy3 = readOnlyNativeWindowProxy2;
            boolean bl7 = false;
            ((WindowsNativeWindowProxy)object).bind(parentWindow);
        }
        return (NativeWindowProxy)object;
    }

    @Override
    @NotNull
    public Pair<Boolean, String> canGetProxyForExistingWindow(@NotNull WindowId windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        WindowsWindowId windowsWindowId = (WindowsWindowId)windowId;
        if (Intrinsics.areEqual((Object)WindowsWindowIdKt.getWindowClassName(windowsWindowId), (Object)"ApplicationFrameWindow")) {
            return new Pair((Object)false, (Object)"There is no support for UWP apps");
        }
        int n = Kernel32Kt.getKernel32().GetCurrentProcessId();
        IntByReference intByReference = new IntByReference();
        boolean bl = false;
        boolean bl2 = false;
        IntByReference intByReference2 = intByReference;
        boolean bl3 = false;
        User32Kt.getUser32().GetWindowThreadProcessId(windowsWindowId.getHWnd(), intByReference2);
        IntByReference intByReference3 = intByReference;
        if (intByReference3.getValue() == n) {
            return new Pair((Object)false, (Object)"Mutable proxy on window of current process can cause errors");
        }
        return new Pair((Object)true, null);
    }

    @Override
    @NotNull
    public NativeWindowProxy getProxyForExistingWindow(@NotNull WindowId windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        WindowsWindowId cfr_ignored_0 = (WindowsWindowId)windowId;
        WinDef.HWND hWND = ((WindowsWindowId)windowId).getHWnd();
        return new ExistingWindowWindowsNativeWindowProxy(hWND, this.systemEnvironmentProvider, this.logger);
    }

    @Override
    @NotNull
    public ReadOnlyNativeWindowProxy find(@NotNull WindowId windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        WindowsWindowId cfr_ignored_0 = (WindowsWindowId)windowId;
        WinDef.HWND hWND = ((WindowsWindowId)windowId).getHWnd();
        return new ReadOnlyWindowsNativeWindowProxy(hWND);
    }

    public WindowsNativeWindowProxyFactory(@NotNull EventBus eventBus, @NotNull SystemEnvironmentProvider systemEnvironmentProvider, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)systemEnvironmentProvider, (String)"systemEnvironmentProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.systemEnvironmentProvider = systemEnvironmentProvider;
        this.logger = logger;
        this.windowProc = new WindowProc(this.logger);
        this.shellMessageReader = new ShellMessageReader(eventBus);
    }
}

