/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.wizard;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.wizard.core.controller.RiderWizardController;
import com.jetbrains.rider.wizard.core.model.RiderWizardContext;
import com.jetbrains.rider.wizard.core.model.RiderWizardModel;
import com.jetbrains.rider.wizard.core.stat.RiderWizardStat;
import com.jetbrains.rider.wizard.core.view.RiderWizardView;
import com.jetbrains.rider.wizard.steps.base.RiderWizardStepController;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/wizard/RiderWizardDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "controllers", "Lkotlin/Function2;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Lcom/jetbrains/rider/wizard/core/model/RiderWizardContext;", "", "Lcom/jetbrains/rider/wizard/steps/base/RiderWizardStepController;", "RiderWizardDialog", "(Lkotlin/jvm/functions/Function2;)V", "lifetime", "model", "Lcom/jetbrains/rider/wizard/core/model/RiderWizardModel;", "getModel", "()Lcom/jetbrains/rider/wizard/core/model/RiderWizardModel;", "controller", "Lcom/jetbrains/rider/wizard/core/controller/RiderWizardController;", "view", "Lcom/jetbrains/rider/wizard/core/view/RiderWizardView;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "doCancelAction", "", "x", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderWizardDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderWizardDialog.kt\ncom/jetbrains/rider/wizard/RiderWizardDialog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n23#2:62\n82#2,3:63\n*S KotlinDebug\n*F\n+ 1 RiderWizardDialog.kt\ncom/jetbrains/rider/wizard/RiderWizardDialog\n*L\n49#1:62\n49#1:63,3\n*E\n"})
public final class RiderWizardDialog
extends DialogWrapper {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RiderWizardModel model;
    @NotNull
    private final RiderWizardController controller;
    @NotNull
    private final RiderWizardView view;

    public RiderWizardDialog(@NotNull Function2<? super Lifetime, ? super RiderWizardContext, ? extends List<? extends RiderWizardStepController>> controllers) {
        Intrinsics.checkNotNullParameter(controllers, (String)"controllers");
        super(null, null, false, DialogWrapper.IdeModalityType.IDE, false);
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.lifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
        this.model = new RiderWizardModel(controllers, this.lifetime);
        this.controller = new RiderWizardController(this.lifetime, this.model, this);
        this.view = new RiderWizardView(this.lifetime, this.model, this.controller);
        this.setSize(FlatWelcomeFrame.MAX_DEFAULT_WIDTH, FlatWelcomeFrame.DEFAULT_HEIGHT);
        this.setTitle("Customize " + ApplicationNamesInfo.getInstance().getFullProductNameWithEdition());
        this.setAutoAdjustable(false);
        this.setResizable(false);
        this.init();
    }

    @NotNull
    public final RiderWizardModel getModel() {
        return this.model;
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return this.view.getView();
    }

    public void doCancelAction() {
        if (this.controller.isCloseAllowed()) {
            this.doOKAction();
            return;
        }
        boolean bl = this.x();
        if (bl) {
            Object object;
            RiderWizardDialog riderWizardDialog = this;
            boolean bl2 = false;
            Logger logger = Logger.getInstance(RiderWizardDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            riderWizardDialog = logger;
            RiderWizardStat riderWizardStat = RiderWizardStat.INSTANCE;
            bl2 = false;
            RiderWizardDialog riderWizardDialog2 = riderWizardDialog;
            try {
                object = riderWizardDialog2;
                boolean bl3 = false;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)((RiderWizardStepController)this.controller.findCurrent().getValue()));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            riderWizardStat.onCancelled((RiderWizardStepController)LoggerKt.getOrLogException((Object)object, (Logger)riderWizardDialog));
            CustomConfigMigrationOption.writeConfigMarkerFile$default((CustomConfigMigrationOption)((CustomConfigMigrationOption)CustomConfigMigrationOption.StartWithCleanConfig.INSTANCE), null, (int)1, null);
            ApplicationKt.getApplicationEx().exit(true, true, false);
        }
    }

    private final boolean x() {
        String string = ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = ApplicationBundle.message((String)"exit.confirm.prompt", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(string, string2);
        String string3 = ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
        String string4 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCancelButtonText(...)");
        return ((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).ask((Component)this.getPeer().getContentPane());
    }
}

