/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.viewer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.RiderBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 $2\u00020\u0001:\u0003$%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\u0014J\u001d\u0010\u0017\u001a\u00020\u00142\r\u0010\u0018\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ \u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00128\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/viewer/IlViewerHostUi;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "IlViewerHostUi", "(Lcom/intellij/openapi/project/Project;)V", "activated", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getActivated", "()Lcom/jetbrains/rd/util/reactive/Property;", "ilViewerToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getIlViewerToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "panelLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "loadingLabelText", "", "activeBackend", "", "toolWindow", "activateToolwindow", "showUnavailabilityLabel", "reason", "Lorg/jetbrains/annotations/Nls;", "reasonLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createIlViewer", "viewerLifetime", "editor", "Lcom/intellij/openapi/editor/Editor;", "x", "lifetime", "panel", "Ljavax/swing/JPanel;", "Companion", "UnavailabilityLabel", "IlViewerPanel", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nIlViewerHostUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IlViewerHostUi.kt\ncom/jetbrains/rider/viewer/IlViewerHostUi\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n13#2:139\n13#3:140\n*S KotlinDebug\n*F\n+ 1 IlViewerHostUi.kt\ncom/jetbrains/rider/viewer/IlViewerHostUi\n*L\n40#1:139\n40#1:140\n*E\n"})
public final class IlViewerHostUi
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Property<Boolean> activated;
    @NotNull
    private final SequentialLifetimes panelLifetimes;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    private final String loadingLabelText;
    @NotNull
    private static final Logger logger;

    public IlViewerHostUi(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.activated = new Property((Object)false);
        this.panelLifetimes = new SequentialLifetimes(this.getServiceLifetime());
        this.loadingLabelText = RiderBundle.message("label.loading", new Object[0]);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow = this.getIlViewerToolWindow();
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                boolean bl = toolWindow2.isVisible();
                this.getActivated().set((Object)bl);
            }
        });
    }

    @NotNull
    public final Property<Boolean> getActivated() {
        return this.activated;
    }

    @Nullable
    public final ToolWindow getIlViewerToolWindow() {
        return ToolWindowManager.Companion.getInstance(this.project).getToolWindow("IL");
    }

    public final void activeBackend(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.activated.set((Object)true);
        this.x(Lifetime.Companion.getEternal(), toolWindow, new UnavailabilityLabel(this.loadingLabelText));
    }

    public final void activateToolwindow() {
        block0: {
            ToolWindow toolWindow = this.getIlViewerToolWindow();
            if (toolWindow == null) break block0;
            toolWindow.activate(null);
        }
    }

    public final void showUnavailabilityLabel(@Nullable String reason, @NotNull Lifetime reasonLifetime) {
        Intrinsics.checkNotNullParameter((Object)reasonLifetime, (String)"reasonLifetime");
        ToolWindow toolWindow = this.getIlViewerToolWindow();
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        logger.debug("showing unavailability reason: " + reason + " ");
        this.x(reasonLifetime, toolWindow2, new UnavailabilityLabel(reason));
    }

    public final void createIlViewer(@NotNull Lifetime viewerLifetime, @NotNull Editor editor2) {
        ToolWindow toolWindow;
        Intrinsics.checkNotNullParameter((Object)viewerLifetime, (String)"viewerLifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        logger.debug("showing IL viewer editor");
        editor2.getSettings().setLineNumbersShown(false);
        editor2.getSettings().setGutterIconsShown(false);
        editor2.getSettings().setRightMarginShown(false);
        if (editor2 instanceof EditorEx && (toolWindow = FileDocumentManager.getInstance().getFile((Document)((EditorEx)editor2).getDocument())) != null) {
            EditorColorsScheme editorColorsScheme = ((EditorEx)editor2).createBoundColorSchemeDelegate(EditorColorsUtil.getGlobalOrDefaultColorScheme());
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"createBoundColorSchemeDelegate(...)");
            EditorColorsScheme editorColorsScheme2 = editorColorsScheme;
            ((EditorEx)editor2).setColorsScheme(editorColorsScheme2);
            ((EditorEx)editor2).setHighlighter(EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter((VirtualFile)toolWindow, editorColorsScheme2, this.project));
        }
        ToolWindow toolWindow2 = this.getIlViewerToolWindow();
        if (toolWindow2 == null) {
            return;
        }
        toolWindow = toolWindow2;
        this.x(viewerLifetime, toolWindow, (JPanel)((Object)new IlViewerPanel(editor2)));
    }

    private final void x(Lifetime lifetime, ToolWindow toolWindow, JPanel jPanel) {
        Lifetime lifetime2 = RLifetimeKt.intersect((Lifetime)((Lifetime)this.panelLifetimes.next()), (Lifetime)lifetime);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.getFactory().createContent((JComponent)jPanel, "", false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        lifetime2.bracketIfAlive(() -> IlViewerHostUi.G(contentManager2, content2), () -> IlViewerHostUi.x(contentManager2, content2));
    }

    private static final Unit G(ContentManager contentManager, Content content) {
        contentManager.addContent(content);
        return Unit.INSTANCE;
    }

    private static final Unit x(ContentManager contentManager, Content content) {
        contentManager.removeContent(content, true);
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(IlViewerHostUi.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        IlViewerHostUi.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/viewer/IlViewerHostUi$Companion;", "", "IlViewerHostUi$Companion", "()V", "getInstance", "Lcom/jetbrains/rider/viewer/IlViewerHostUi;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nIlViewerHostUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IlViewerHostUi.kt\ncom/jetbrains/rider/viewer/IlViewerHostUi$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n30#2,2:139\n*S KotlinDebug\n*F\n+ 1 IlViewerHostUi.kt\ncom/jetbrains/rider/viewer/IlViewerHostUi$Companion\n*L\n38#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IlViewerHostUi getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<IlViewerHostUi> clazz = IlViewerHostUi.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (IlViewerHostUi)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/viewer/IlViewerHostUi$IlViewerPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "IlViewerHostUi$IlViewerPanel", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "x", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "dispose", "", "intellij.rider"})
    public static final class IlViewerPanel
    extends SimpleToolWindowPanel
    implements Disposable {
        @NotNull
        private final Editor editor;

        public IlViewerPanel(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(true, true);
            this.editor = editor2;
            logger.debug("creating panel for " + this.editor);
            this.setToolbar(this.x().getComponent());
            this.setContent(this.editor.getComponent());
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        private final ActionToolbar x() {
            AnAction anAction = ActionManager.getInstance().getAction("RiderIlViewerToolbar");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup actionGroup2 = (ActionGroup)anAction;
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("IlViewerToolbar", actionGroup2, true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            ActionToolbar actionToolbar2 = actionToolbar;
            actionToolbar2.setTargetComponent(this.editor.getComponent());
            return actionToolbar2;
        }

        public void dispose() {
            if (!this.editor.isDisposed()) {
                logger.debug("disposing panel for " + this.editor);
                EditorFactory.getInstance().releaseEditor(this.editor);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/viewer/IlViewerHostUi$UnavailabilityLabel;", "Ljavax/swing/JPanel;", "reason", "", "IlViewerHostUi$UnavailabilityLabel", "(Ljava/lang/String;)V", "intellij.rider"})
    public static final class UnavailabilityLabel
    extends JPanel {
        public UnavailabilityLabel(@NlsContexts.Label @Nullable String reason) {
            super(new GridBagLayout());
            this.add((Component)new JLabel(reason), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, this.getInsets(), 0, 0));
        }
    }
}

