/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.vcs.diff.view;

import com.intellij.openapi.project.Project;
import com.jetbrains.rider.model.AssemblyDiffLocations;
import com.jetbrains.rider.model.RdDiffTypeDescriptor;
import com.jetbrains.rider.vcs.diff.AssemblyDiffHost;
import com.jetbrains.rider.vcs.diff.AssemblyDiffRequestProcessor;
import com.jetbrains.rider.vcs.diff.assemblyTree.AssemblyDiffPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/vcs/diff/view/AssemblyDiffModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "locations", "Lcom/jetbrains/rider/model/AssemblyDiffLocations;", "processor", "Lcom/jetbrains/rider/vcs/diff/AssemblyDiffRequestProcessor;", "AssemblyDiffModel", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/model/AssemblyDiffLocations;Lcom/jetbrains/rider/vcs/diff/AssemblyDiffRequestProcessor;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLocations", "()Lcom/jetbrains/rider/model/AssemblyDiffLocations;", "getProcessor", "()Lcom/jetbrains/rider/vcs/diff/AssemblyDiffRequestProcessor;", "pane", "Lcom/jetbrains/rider/vcs/diff/assemblyTree/AssemblyDiffPane;", "treeId", "", "assemblyHost", "Lcom/jetbrains/rider/vcs/diff/AssemblyDiffHost;", "getAssemblyPane", "invalidateModel", "", "element", "Lcom/jetbrains/rider/model/RdDiffTypeDescriptor;", "disposeTree", "intellij.rider"})
public final class AssemblyDiffModel {
    @NotNull
    private final Project project;
    @NotNull
    private final AssemblyDiffLocations locations;
    @NotNull
    private final AssemblyDiffRequestProcessor processor;
    @NotNull
    private AssemblyDiffPane pane;
    private int treeId;
    @NotNull
    private AssemblyDiffHost assemblyHost;

    public AssemblyDiffModel(@NotNull Project project, @NotNull AssemblyDiffLocations locations, @NotNull AssemblyDiffRequestProcessor processor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        Intrinsics.checkNotNullParameter((Object)((Object)processor2), (String)"processor");
        this.project = project;
        this.locations = locations;
        this.processor = processor2;
        this.assemblyHost = AssemblyDiffHost.Companion.getInstance(this.project);
        this.treeId = this.assemblyHost.generateTreeId();
        this.pane = new AssemblyDiffPane(this.project, this.treeId);
        this.assemblyHost.addAssemblies(this.treeId, this.locations, this.pane, this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final AssemblyDiffLocations getLocations() {
        return this.locations;
    }

    @NotNull
    public final AssemblyDiffRequestProcessor getProcessor() {
        return this.processor;
    }

    @NotNull
    public final AssemblyDiffPane getAssemblyPane() {
        return this.pane;
    }

    public final void invalidateModel(@NotNull RdDiffTypeDescriptor element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.processor.loadElement(element);
        this.processor.updateRequest(true);
    }

    public final void disposeTree() {
        this.assemblyHost.deleteTreeById(this.treeId);
    }
}

