/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/utils/RiderEnvironmentAccessor;", "", "RiderEnvironmentAccessor", "()V", "getEnvironment", "", "", "getEnvironmentVariable", "name", "findFileInSystemPath", "Ljava/nio/file/Path;", "baseName", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderEnvironmentAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEnvironmentAccessor.kt\ncom/jetbrains/rider/utils/RiderEnvironmentAccessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class RiderEnvironmentAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PATH_VARIABLE = "PATH";

    @NotNull
    public final Map<String, String> getEnvironment() {
        Map map2 = EnvironmentUtil.getEnvironmentMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironmentMap(...)");
        return map2;
    }

    @Nullable
    public final String getEnvironmentVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getEnvironment().get(name);
    }

    @Nullable
    public final Path findFileInSystemPath(@NotNull String baseName) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        File file2 = PathEnvironmentVariableUtil.findInPath((String)baseName, (String)this.getEnvironmentVariable(PATH_VARIABLE), null);
        Path path2 = path = file2 != null ? file2.toPath() : null;
        if (path2 != null) {
            return path2;
        }
        if (SystemInfo.isWindows) {
            String string = PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)baseName);
            boolean bl = false;
            Path path3 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            return path3;
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/utils/RiderEnvironmentAccessor$Companion;", "", "RiderEnvironmentAccessor$Companion", "()V", "PATH_VARIABLE", "", "getInstance", "Lcom/jetbrains/rider/utils/RiderEnvironmentAccessor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderEnvironmentAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEnvironmentAccessor.kt\ncom/jetbrains/rider/utils/RiderEnvironmentAccessor$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,43:1\n30#2,2:44\n*S KotlinDebug\n*F\n+ 1 RiderEnvironmentAccessor.kt\ncom/jetbrains/rider/utils/RiderEnvironmentAccessor$Companion\n*L\n20#1:44,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderEnvironmentAccessor getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<RiderEnvironmentAccessor> clazz = RiderEnvironmentAccessor.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (RiderEnvironmentAccessor)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

