/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.trees;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeDescriptor;
import com.jetbrains.rider.unitTesting.trees.nodes.RiderUnitTestNode;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001 B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u001a\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001e\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestViewportEvaluator;", "Ljavax/swing/event/TreeExpansionListener;", "Ljavax/swing/event/TreeModelListener;", "Ljavax/swing/event/ChangeListener;", "viewport", "Ljavax/swing/JViewport;", "descriptor", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;", "RiderUnitTestViewportEvaluator", "(Ljavax/swing/JViewport;Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;)V", "getViewport", "()Ljavax/swing/JViewport;", "getDescriptor", "()Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "alarm", "Lcom/intellij/util/SingleAlarm;", "stateChanged", "", "event", "Ljavax/swing/event/ChangeEvent;", "treeExpanded", "p0", "Ljavax/swing/event/TreeExpansionEvent;", "treeCollapsed", "treeNodesInserted", "Ljavax/swing/event/TreeModelEvent;", "treeNodesRemoved", "treeStructureChanged", "treeNodesChanged", "x", "Companion", "intellij.rider"})
public final class RiderUnitTestViewportEvaluator
implements TreeExpansionListener,
TreeModelListener,
ChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JViewport viewport;
    @NotNull
    private final RiderUnitTestTreeDescriptor descriptor;
    @NotNull
    private final Tree tree;
    @NotNull
    private final SingleAlarm alarm;
    private static final int INVISIBLE_ROW_COUNT = 20;

    public RiderUnitTestViewportEvaluator(@NotNull JViewport viewport, @NotNull RiderUnitTestTreeDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)viewport, (String)"viewport");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.viewport = viewport;
        this.descriptor = descriptor2;
        this.tree = this.descriptor.getTree();
        SingleAlarm.Companion companion = SingleAlarm.Companion;
        Runnable runnable = () -> RiderUnitTestViewportEvaluator.x(this);
        CoroutineScope coroutineScope = this.descriptor.getLifetime().getCoroutineScope();
        this.alarm = companion.singleEdtAlarm(50, coroutineScope, runnable);
        this.tree.getModel().addTreeModelListener(this);
        this.descriptor.getLifetime().onTermination(() -> RiderUnitTestViewportEvaluator.k(this));
        this.tree.addTreeExpansionListener((TreeExpansionListener)this);
        this.descriptor.getLifetime().onTermination(() -> RiderUnitTestViewportEvaluator.G(this));
        this.viewport.addChangeListener(this);
        this.descriptor.getLifetime().onTermination(() -> RiderUnitTestViewportEvaluator.x(this));
    }

    @NotNull
    public final JViewport getViewport() {
        return this.viewport;
    }

    @NotNull
    public final RiderUnitTestTreeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void stateChanged(@NotNull ChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.alarm.request();
    }

    @Override
    public void treeExpanded(@Nullable TreeExpansionEvent p0) {
        this.alarm.request();
    }

    @Override
    public void treeCollapsed(@Nullable TreeExpansionEvent p0) {
        this.alarm.request();
    }

    @Override
    public void treeNodesInserted(@Nullable TreeModelEvent p0) {
        this.alarm.request();
    }

    @Override
    public void treeNodesRemoved(@Nullable TreeModelEvent p0) {
        this.alarm.request();
    }

    @Override
    public void treeStructureChanged(@Nullable TreeModelEvent p0) {
        this.alarm.request();
    }

    @Override
    public void treeNodesChanged(@Nullable TreeModelEvent p0) {
    }

    private final void x() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.descriptor.getLifetime())) {
            return;
        }
        Rectangle rectangle = this.viewport.getViewRect();
        int n = Math.max(this.tree.getClosestRowForLocation(rectangle.x, rectangle.y) - 20, 0);
        int n2 = Math.min(this.tree.getClosestRowForLocation(rectangle.x, rectangle.y + rectangle.height) + 20, this.tree.getRowCount());
        this.descriptor.log((Function0<String>)((Function0)() -> RiderUnitTestViewportEvaluator.x(n, n2)));
        List list2 = new ArrayList();
        int n3 = n;
        if (n3 <= n2) {
            while (true) {
                Object object;
                TreePath treePath = this.tree.getPathForRow(n3);
                Object object2 = object = treePath != null ? treePath.getLastPathComponent() : null;
                if (object instanceof RiderUnitTestNode) {
                    list2.add(((RiderUnitTestNode)((Object)object)).getId());
                }
                if (n3 == n2) break;
                ++n3;
            }
        }
        this.descriptor.evaluate(list2);
    }

    private static final void x(RiderUnitTestViewportEvaluator riderUnitTestViewportEvaluator) {
        riderUnitTestViewportEvaluator.x();
    }

    private static final Unit k(RiderUnitTestViewportEvaluator riderUnitTestViewportEvaluator) {
        riderUnitTestViewportEvaluator.tree.getModel().removeTreeModelListener(riderUnitTestViewportEvaluator);
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderUnitTestViewportEvaluator riderUnitTestViewportEvaluator) {
        riderUnitTestViewportEvaluator.tree.removeTreeExpansionListener((TreeExpansionListener)riderUnitTestViewportEvaluator);
        return Unit.INSTANCE;
    }

    private static final Unit x(RiderUnitTestViewportEvaluator riderUnitTestViewportEvaluator) {
        riderUnitTestViewportEvaluator.viewport.removeChangeListener(riderUnitTestViewportEvaluator);
        return Unit.INSTANCE;
    }

    private static final String x(int n, int n2) {
        return "EvaluateVisibleNodes for rows: " + n + " - " + n2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestViewportEvaluator$Companion;", "", "RiderUnitTestViewportEvaluator$Companion", "()V", "INVISIBLE_ROW_COUNT", "", "isViewportEvaluationEnabled", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isViewportEvaluationEnabled() {
            return Registry.Companion.is("rider.unit.testing.evaluate.viewport");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

