/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui.components.utils;

import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0004J\u0016\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/ui/components/utils/ChessBoardPainter;", "", "ChessBoardPainter", "()V", "pattern", "Ljava/awt/image/BufferedImage;", "value", "", "cellSize", "getCellSize", "()I", "setCellSize", "(I)V", "Ljava/awt/Color;", "whiteColor", "getWhiteColor", "()Ljava/awt/Color;", "setWhiteColor", "(Ljava/awt/Color;)V", "blackColor", "getBlackColor", "setBlackColor", "update", "", "createBackground", "g", "Ljava/awt/Graphics;", "rectangle", "Ljava/awt/Rectangle;", "x", "intellij.rider"})
public class ChessBoardPainter {
    @NotNull
    private BufferedImage pattern;
    private int cellSize = JBUI.scale((int)10);
    @NotNull
    private Color whiteColor;
    @NotNull
    private Color blackColor;

    public ChessBoardPainter() {
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        this.whiteColor = color;
        Color color2 = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        this.blackColor = color2;
        this.pattern = this.x();
    }

    public final int getCellSize() {
        return this.cellSize;
    }

    public final void setCellSize(int value2) {
        if (this.cellSize == value2) {
            return;
        }
        this.cellSize = value2;
        this.update();
    }

    @NotNull
    public final Color getWhiteColor() {
        return this.whiteColor;
    }

    public final void setWhiteColor(@NotNull Color value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (this.whiteColor == value2) {
            return;
        }
        this.whiteColor = value2;
        this.update();
    }

    @NotNull
    public final Color getBlackColor() {
        return this.blackColor;
    }

    public final void setBlackColor(@NotNull Color value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (this.blackColor == value2) {
            return;
        }
        this.blackColor = value2;
        this.update();
    }

    protected final void update() {
        this.pattern = this.x();
    }

    public final void createBackground(@NotNull Graphics g, @NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new TexturePaint(this.pattern, new Rectangle(rectangle.x, rectangle.y, this.pattern.getWidth(), this.pattern.getHeight())));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.dispose();
    }

    private final BufferedImage x() {
        BufferedImage bufferedImage = ImageUtil.createImage((int)(2 * this.cellSize), (int)(2 * this.cellSize), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage bufferedImage2 = bufferedImage;
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.blackColor);
        graphics2D.fillRect(0, 0, this.cellSize, this.cellSize);
        graphics2D.fillRect(this.cellSize, this.cellSize, this.cellSize, this.cellSize);
        graphics2D.setColor(this.whiteColor);
        graphics2D.fillRect(this.cellSize, 0, this.cellSize, this.cellSize);
        graphics2D.fillRect(0, this.cellSize, this.cellSize, this.cellSize);
        return bufferedImage2;
    }
}

